/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.simple;

import WayofTime.alchemicalWizardry.common.entity.projectile.FireProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.simple.HomSpell;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class SpellFireBurst
extends HomSpell {
    public Random itemRand = new Random();

    public SpellFireBurst() {
        this.setEnergies(100, 300, 400, 100);
    }

    @Override
    public ItemStack onOffensiveRangedRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveRangedEnergy());
        }
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (this.itemRand.nextFloat() * 0.4f + 0.8f));
        if (!par2World.isRemote) {
            FireProjectile proj = new FireProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 7);
            par2World.spawnEntityInWorld((Entity)proj);
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onOffensiveMeleeRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveMeleeEnergy());
        }
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (this.itemRand.nextFloat() * 0.4f + 0.8f));
        if (!par2World.isRemote) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    par2World.spawnEntityInWorld((Entity)new FireProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 8, 2, par3EntityPlayer.posX, par3EntityPlayer.posY + (double)par3EntityPlayer.getEyeHeight(), par3EntityPlayer.posZ, par3EntityPlayer.rotationYaw + (float)i * 10.0f, par3EntityPlayer.rotationPitch + (float)j * 10.0f));
                }
            }
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onDefensiveRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getDefensiveEnergy());
        }
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (this.itemRand.nextFloat() * 0.4f + 0.8f));
        int d0 = 2;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)par3EntityPlayer.posX, (double)par3EntityPlayer.posY, (double)par3EntityPlayer.posZ, (double)(par3EntityPlayer.posX + 1.0), (double)(par3EntityPlayer.posY + 2.0), (double)(par3EntityPlayer.posZ + 1.0)).expand((double)d0, (double)d0, (double)d0);
        List list = par3EntityPlayer.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        for (EntityLivingBase entityLiving : list) {
            if (entityLiving instanceof EntityPlayer && entityLiving.equals((Object)par3EntityPlayer)) continue;
            entityLiving.setFire(100);
            entityLiving.attackEntityFrom(DamageSource.inFire, 2.0f);
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onEnvironmentalRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getEnvironmentalEnergy());
        }
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (this.itemRand.nextFloat() * 0.4f + 0.8f));
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (!par2World.isAirBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ + k) || !(par2World.rand.nextFloat() < 0.8f)) continue;
                    par2World.setBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ + k, (Block)Blocks.fire);
                }
            }
        }
        return par1ItemStack;
    }
}

