/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.wind;

import WayofTime.alchemicalWizardry.api.spell.SelfSpellEffect;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class SelfEnvironmentalWind
extends SelfSpellEffect {
    public SelfEnvironmentalWind(int power, int potency, int cost) {
        super(power, potency, cost);
    }

    @Override
    public void onSelfUse(World world, EntityPlayer player) {
        double radius = 1.5 * (double)this.potencyUpgrades + 1.0;
        double posX = player.posX;
        double posY = player.posY - 0.7;
        double posZ = player.posZ;
        double wantedVel = 0.7 + 0.7 * (double)this.powerUpgrades;
        List<Entity> entities = SpellHelper.getEntitiesInRange(world, posX, posY, posZ, radius, radius);
        for (Entity entity : entities) {
            if (entity.equals((Object)player) || !(entity instanceof EntityLivingBase)) continue;
            double dist = Math.sqrt(entity.getDistanceToEntity((Entity)player));
            double xVel = wantedVel * (entity.posX - posX) / dist;
            double yVel = wantedVel * (entity.posY - posY) / dist;
            double zVel = wantedVel * (entity.posZ - posZ) / dist;
            entity.motionX = xVel;
            entity.motionY = yVel;
            entity.motionZ = zVel;
        }
    }
}

