/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class RitualEffectWellOfSuffering
extends RitualEffect {
    public static final int timeDelay = 25;
    public static final int amount = 10;
    private static final int tennebraeDrain = 5;
    private static final int potentiaDrain = 10;
    private static final int offensaDrain = 3;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (world.getWorldTime() % 25L != 0L) {
            return;
        }
        IBloodAltar tileAltar = null;
        boolean testFlag = false;
        for (int i = -5; i <= 5; ++i) {
            for (int j = -5; j <= 5; ++j) {
                for (int k = -10; k <= 10; ++k) {
                    if (!(world.getTileEntity(x + i, y + k, z + j) instanceof IBloodAltar)) continue;
                    tileAltar = (IBloodAltar)world.getTileEntity(x + i, y + k, z + j);
                    testFlag = true;
                }
            }
        }
        if (!testFlag) {
            return;
        }
        boolean hasPotentia = this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 10, false);
        int d0 = 10;
        int vertRange = hasPotentia ? 20 : 10;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).expand((double)d0, (double)vertRange, (double)d0);
        List list = world.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        int entityCount = 0;
        boolean hasTennebrae = this.canDrainReagent(ritualStone, ReagentRegistry.tenebraeReagent, 5, false);
        boolean hasOffensa = this.canDrainReagent(ritualStone, ReagentRegistry.offensaReagent, 3, false);
        if (currentEssence < this.getCostPerRefresh() * list.size()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            for (EntityLivingBase livingEntity : list) {
                if (!livingEntity.isEntityAlive() || livingEntity instanceof EntityPlayer || AlchemicalWizardry.wellBlacklist.contains(livingEntity.getClass()) || !livingEntity.attackEntityFrom(DamageSource.outOfWorld, (hasOffensa = hasOffensa && this.canDrainReagent(ritualStone, ReagentRegistry.offensaReagent, 3, true)) ? 2.0f : 1.0f)) continue;
                hasTennebrae = hasTennebrae && this.canDrainReagent(ritualStone, ReagentRegistry.tenebraeReagent, 5, true);
                ++entityCount;
                tileAltar.sacrificialDaggerCall(10 * (hasTennebrae ? 2 : 1) * (hasOffensa ? 2 : 1), true);
            }
            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh() * entityCount);
            if (hasPotentia) {
                this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 10, true);
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostSuffering[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> wellOfSufferingRitual = new ArrayList<RitualComponent>();
        wellOfSufferingRitual.add(new RitualComponent(1, 0, 1, 2));
        wellOfSufferingRitual.add(new RitualComponent(-1, 0, 1, 2));
        wellOfSufferingRitual.add(new RitualComponent(1, 0, -1, 2));
        wellOfSufferingRitual.add(new RitualComponent(-1, 0, -1, 2));
        wellOfSufferingRitual.add(new RitualComponent(2, -1, 2, 2));
        wellOfSufferingRitual.add(new RitualComponent(2, -1, -2, 2));
        wellOfSufferingRitual.add(new RitualComponent(-2, -1, 2, 2));
        wellOfSufferingRitual.add(new RitualComponent(-2, -1, -2, 2));
        wellOfSufferingRitual.add(new RitualComponent(0, -1, 2, 3));
        wellOfSufferingRitual.add(new RitualComponent(2, -1, 0, 3));
        wellOfSufferingRitual.add(new RitualComponent(0, -1, -2, 3));
        wellOfSufferingRitual.add(new RitualComponent(-2, -1, 0, 3));
        wellOfSufferingRitual.add(new RitualComponent(-3, -1, -3, 5));
        wellOfSufferingRitual.add(new RitualComponent(3, -1, -3, 5));
        wellOfSufferingRitual.add(new RitualComponent(-3, -1, 3, 5));
        wellOfSufferingRitual.add(new RitualComponent(3, -1, 3, 5));
        wellOfSufferingRitual.add(new RitualComponent(2, -1, 4, 1));
        wellOfSufferingRitual.add(new RitualComponent(4, -1, 2, 1));
        wellOfSufferingRitual.add(new RitualComponent(-2, -1, 4, 1));
        wellOfSufferingRitual.add(new RitualComponent(4, -1, -2, 1));
        wellOfSufferingRitual.add(new RitualComponent(2, -1, -4, 1));
        wellOfSufferingRitual.add(new RitualComponent(-4, -1, 2, 1));
        wellOfSufferingRitual.add(new RitualComponent(-2, -1, -4, 1));
        wellOfSufferingRitual.add(new RitualComponent(-4, -1, -2, 1));
        wellOfSufferingRitual.add(new RitualComponent(1, 0, 4, 1));
        wellOfSufferingRitual.add(new RitualComponent(4, 0, 1, 1));
        wellOfSufferingRitual.add(new RitualComponent(1, 0, -4, 1));
        wellOfSufferingRitual.add(new RitualComponent(-4, 0, 1, 1));
        wellOfSufferingRitual.add(new RitualComponent(-1, 0, 4, 1));
        wellOfSufferingRitual.add(new RitualComponent(4, 0, -1, 1));
        wellOfSufferingRitual.add(new RitualComponent(-1, 0, -4, 1));
        wellOfSufferingRitual.add(new RitualComponent(-4, 0, -1, 1));
        wellOfSufferingRitual.add(new RitualComponent(4, 1, 0, 4));
        wellOfSufferingRitual.add(new RitualComponent(0, 1, 4, 4));
        wellOfSufferingRitual.add(new RitualComponent(-4, 1, 0, 4));
        wellOfSufferingRitual.add(new RitualComponent(0, 1, -4, 4));
        return wellOfSufferingRitual;
    }
}

