/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.bindingRegistry.UnbindingRegistry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.items.armour.BoundArmour;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class RitualEffectUnbinding
extends RitualEffect {
    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            boolean d0 = false;
            AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)x, (double)((double)y + 1.0), (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1)).expand((double)d0, (double)d0, (double)d0);
            List list = world.getEntitiesWithinAABB(EntityItem.class, axisalignedbb);
            Iterator iterator = list.iterator();
            boolean drain = false;
            while (iterator.hasNext()) {
                int sanctusDrain = 1000;
                EntityItem item = (EntityItem)iterator.next();
                ItemStack itemStack = item.getEntityItem();
                if (itemStack == null) continue;
                boolean hasSanctus = this.canDrainReagent(ritualStone, ReagentRegistry.sanctusReagent, 1000, false);
                if (hasSanctus && itemStack.getItem() instanceof IBindable && !EnergyItems.getOwnerName(itemStack).equals("")) {
                    world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)x, (double)(y + 1), (double)(z - 5)));
                    world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)x, (double)(y + 1), (double)(z + 5)));
                    world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)(x - 5), (double)(y + 1), (double)z));
                    world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)(x + 5), (double)(y + 1), (double)z));
                    EnergyItems.setItemOwner(itemStack, "");
                    this.canDrainReagent(ritualStone, ReagentRegistry.sanctusReagent, 1000, true);
                    drain = true;
                    ritualStone.setActive(false);
                    break;
                }
                if (itemStack.getItem() == ModItems.boundHelmet) {
                    ritualStone.setVar1(5);
                } else if (itemStack.getItem() == ModItems.boundPlate) {
                    ritualStone.setVar1(8);
                } else if (itemStack.getItem() == ModItems.boundLeggings) {
                    ritualStone.setVar1(7);
                } else if (itemStack.getItem() == ModItems.boundBoots) {
                    ritualStone.setVar1(4);
                } else if (UnbindingRegistry.isRequiredItemValid(itemStack)) {
                    ritualStone.setVar1(UnbindingRegistry.getIndexForItem(itemStack) + 9);
                }
                if (ritualStone.getVar1() > 0 && ritualStone.getVar1() <= 8) {
                    item.setDead();
                    this.doLightning(world, x, y, z);
                    ItemStack[] inv = ((BoundArmour)itemStack.getItem()).getInternalInventory(itemStack);
                    int bloodSockets = 0;
                    if (itemStack.getItem() == ModItems.boundHelmet) {
                        bloodSockets = 5;
                    } else if (itemStack.getItem() == ModItems.boundPlate) {
                        bloodSockets = 8;
                    } else if (itemStack.getItem() == ModItems.boundLeggings) {
                        bloodSockets = 7;
                    } else if (itemStack.getItem() == ModItems.boundBoots) {
                        bloodSockets = 4;
                    }
                    if (inv != null) {
                        for (ItemStack internalItem : inv) {
                            if (internalItem == null) continue;
                            this.doLightning(world, x, y, z);
                            EntityItem newItem = new EntityItem(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, internalItem.copy());
                            world.spawnEntityInWorld((Entity)newItem);
                        }
                    }
                    EntityItem newItem = new EntityItem(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, new ItemStack(ModBlocks.bloodSocket, bloodSockets));
                    world.spawnEntityInWorld((Entity)newItem);
                    ritualStone.setActive(false);
                    drain = true;
                    break;
                }
                if (ritualStone.getVar1() < 9) continue;
                item.setDead();
                this.doLightning(world, x, y, z);
                List<ItemStack> spawnedItem = UnbindingRegistry.getOutputForIndex(ritualStone.getVar1() - 9);
                if (spawnedItem != null) {
                    for (ItemStack itemStack1 : spawnedItem) {
                        EntityItem newItem = new EntityItem(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, itemStack1.copy());
                        world.spawnEntityInWorld((Entity)newItem);
                    }
                }
                ritualStone.setActive(false);
                drain = true;
                break;
            }
            if (drain) {
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
            }
        }
        if (world.rand.nextInt(10) == 0) {
            SpellHelper.sendIndexedParticleToAllAround(world, x, y, z, 20, world.provider.dimensionId, 1, x, y, z);
        }
    }

    private void doLightning(World world, int x, int y, int z) {
        world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)x, (double)(y + 1), (double)(z - 5)));
        world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)x, (double)(y + 1), (double)(z + 5)));
        world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)(x - 5), (double)(y + 1), (double)z));
        world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)(x + 5), (double)(y + 1), (double)z));
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostUnbinding[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> unbindingRitual = new ArrayList<RitualComponent>();
        unbindingRitual.add(new RitualComponent(-2, 0, 0, 4));
        unbindingRitual.add(new RitualComponent(2, 0, 0, 4));
        unbindingRitual.add(new RitualComponent(0, 0, 2, 4));
        unbindingRitual.add(new RitualComponent(0, 0, -2, 4));
        unbindingRitual.add(new RitualComponent(-2, 0, -2, 3));
        unbindingRitual.add(new RitualComponent(-2, 0, -3, 3));
        unbindingRitual.add(new RitualComponent(-3, 0, -2, 3));
        unbindingRitual.add(new RitualComponent(2, 0, -2, 3));
        unbindingRitual.add(new RitualComponent(2, 0, -3, 3));
        unbindingRitual.add(new RitualComponent(3, 0, -2, 3));
        unbindingRitual.add(new RitualComponent(-2, 0, 2, 3));
        unbindingRitual.add(new RitualComponent(-2, 0, 3, 3));
        unbindingRitual.add(new RitualComponent(-3, 0, 2, 3));
        unbindingRitual.add(new RitualComponent(2, 0, 2, 3));
        unbindingRitual.add(new RitualComponent(2, 0, 3, 3));
        unbindingRitual.add(new RitualComponent(3, 0, 2, 3));
        unbindingRitual.add(new RitualComponent(3, 1, 3, 0));
        unbindingRitual.add(new RitualComponent(3, 1, -3, 0));
        unbindingRitual.add(new RitualComponent(-3, 1, -3, 0));
        unbindingRitual.add(new RitualComponent(-3, 1, 3, 0));
        unbindingRitual.add(new RitualComponent(3, 2, 3, 0));
        unbindingRitual.add(new RitualComponent(3, 2, -3, 0));
        unbindingRitual.add(new RitualComponent(-3, 2, -3, 0));
        unbindingRitual.add(new RitualComponent(-3, 2, 3, 0));
        unbindingRitual.add(new RitualComponent(3, 3, 3, 2));
        unbindingRitual.add(new RitualComponent(3, 3, -3, 2));
        unbindingRitual.add(new RitualComponent(-3, 3, -3, 2));
        unbindingRitual.add(new RitualComponent(-3, 3, 3, 2));
        unbindingRitual.add(new RitualComponent(-5, 0, 0, 2));
        unbindingRitual.add(new RitualComponent(5, 0, 0, 2));
        unbindingRitual.add(new RitualComponent(0, 0, 5, 2));
        unbindingRitual.add(new RitualComponent(0, 0, -5, 2));
        return unbindingRitual;
    }
}

