/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.entity.projectile.EntityMeteor;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class RitualEffectSummonMeteor
extends RitualEffect {
    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (ritualStone.getCooldown() > 0) {
            ritualStone.setCooldown(0);
        }
        if (currentEssence < this.getCostPerRefresh()) {
            EntityPlayer entityOwner = SpellHelper.getPlayerForUsername(owner);
            if (entityOwner == null) {
                return;
            }
            entityOwner.addPotionEffect(new PotionEffect(Potion.confusion.id, 80));
        } else {
            List entities = world.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)x, (double)(y + 1), (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1)));
            if (entities == null) {
                return;
            }
            for (EntityItem entityItem : entities) {
                if (entityItem == null || !MeteorRegistry.isValidParadigmItem(entityItem.getEntityItem())) continue;
                int meteorID = MeteorRegistry.getParadigmIDForItem(entityItem.getEntityItem());
                EntityMeteor meteor = new EntityMeteor(world, (float)x + 0.5f, 257.0, (float)z + 0.5f, meteorID);
                meteor.motionY = -1.0;
                if (this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 1000, true)) {
                    meteor.hasTerrae = true;
                }
                if (this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 1000, true)) {
                    meteor.hasOrbisTerrae = true;
                }
                if (this.canDrainReagent(ritualStone, ReagentRegistry.crystallosReagent, 1000, true)) {
                    meteor.hasCrystallos = true;
                }
                if (this.canDrainReagent(ritualStone, ReagentRegistry.incendiumReagent, 1000, true)) {
                    meteor.hasIncendium = true;
                }
                if (this.canDrainReagent(ritualStone, ReagentRegistry.tenebraeReagent, 1000, true)) {
                    meteor.hasTennebrae = true;
                }
                entityItem.setDead();
                world.spawnEntityInWorld((Entity)meteor);
                ritualStone.setActive(false);
                break;
            }
            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostFallingTower[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        int i;
        ArrayList<RitualComponent> meteorRitual = new ArrayList<RitualComponent>();
        meteorRitual.add(new RitualComponent(2, 0, 0, 2));
        meteorRitual.add(new RitualComponent(-2, 0, 0, 2));
        meteorRitual.add(new RitualComponent(0, 0, 2, 2));
        meteorRitual.add(new RitualComponent(0, 0, -2, 2));
        meteorRitual.add(new RitualComponent(3, 0, 1, 4));
        meteorRitual.add(new RitualComponent(3, 0, -1, 4));
        meteorRitual.add(new RitualComponent(-3, 0, 1, 4));
        meteorRitual.add(new RitualComponent(-3, 0, -1, 4));
        meteorRitual.add(new RitualComponent(1, 0, 3, 4));
        meteorRitual.add(new RitualComponent(-1, 0, 3, 4));
        meteorRitual.add(new RitualComponent(1, 0, -3, 4));
        meteorRitual.add(new RitualComponent(-1, 0, -3, 4));
        meteorRitual.add(new RitualComponent(4, 0, 2, 4));
        meteorRitual.add(new RitualComponent(4, 0, -2, 4));
        meteorRitual.add(new RitualComponent(-4, 0, 2, 4));
        meteorRitual.add(new RitualComponent(-4, 0, -2, 4));
        meteorRitual.add(new RitualComponent(2, 0, 4, 4));
        meteorRitual.add(new RitualComponent(-2, 0, 4, 4));
        meteorRitual.add(new RitualComponent(2, 0, -4, 4));
        meteorRitual.add(new RitualComponent(-2, 0, -4, 4));
        meteorRitual.add(new RitualComponent(5, 0, 3, 5));
        meteorRitual.add(new RitualComponent(5, 0, -3, 5));
        meteorRitual.add(new RitualComponent(-5, 0, 3, 5));
        meteorRitual.add(new RitualComponent(-5, 0, -3, 5));
        meteorRitual.add(new RitualComponent(3, 0, 5, 5));
        meteorRitual.add(new RitualComponent(-3, 0, 5, 5));
        meteorRitual.add(new RitualComponent(3, 0, -5, 5));
        meteorRitual.add(new RitualComponent(-3, 0, -5, 5));
        meteorRitual.add(new RitualComponent(-4, 0, -4, 5));
        meteorRitual.add(new RitualComponent(-4, 0, 4, 5));
        meteorRitual.add(new RitualComponent(4, 0, 4, 5));
        meteorRitual.add(new RitualComponent(4, 0, -4, 5));
        for (i = 4; i <= 6; ++i) {
            meteorRitual.add(new RitualComponent(i, 0, 0, 3));
            meteorRitual.add(new RitualComponent(-i, 0, 0, 3));
            meteorRitual.add(new RitualComponent(0, 0, i, 3));
            meteorRitual.add(new RitualComponent(0, 0, -i, 3));
        }
        meteorRitual.add(new RitualComponent(8, 0, 0, 3));
        meteorRitual.add(new RitualComponent(-8, 0, 0, 3));
        meteorRitual.add(new RitualComponent(0, 0, 8, 3));
        meteorRitual.add(new RitualComponent(0, 0, -8, 3));
        meteorRitual.add(new RitualComponent(8, 1, 0, 3));
        meteorRitual.add(new RitualComponent(-8, 1, 0, 3));
        meteorRitual.add(new RitualComponent(0, 1, 8, 3));
        meteorRitual.add(new RitualComponent(0, 1, -8, 3));
        meteorRitual.add(new RitualComponent(7, 1, 0, 3));
        meteorRitual.add(new RitualComponent(-7, 1, 0, 3));
        meteorRitual.add(new RitualComponent(0, 1, 7, 3));
        meteorRitual.add(new RitualComponent(0, 1, -7, 3));
        meteorRitual.add(new RitualComponent(7, 2, 0, 2));
        meteorRitual.add(new RitualComponent(-7, 2, 0, 2));
        meteorRitual.add(new RitualComponent(0, 2, 7, 2));
        meteorRitual.add(new RitualComponent(0, 2, -7, 2));
        meteorRitual.add(new RitualComponent(6, 2, 0, 2));
        meteorRitual.add(new RitualComponent(-6, 2, 0, 2));
        meteorRitual.add(new RitualComponent(0, 2, 6, 2));
        meteorRitual.add(new RitualComponent(0, 2, -6, 2));
        meteorRitual.add(new RitualComponent(6, 3, 0, 1));
        meteorRitual.add(new RitualComponent(-6, 3, 0, 1));
        meteorRitual.add(new RitualComponent(0, 3, 6, 1));
        meteorRitual.add(new RitualComponent(0, 3, -6, 1));
        meteorRitual.add(new RitualComponent(5, 3, 0, 1));
        meteorRitual.add(new RitualComponent(-5, 3, 0, 1));
        meteorRitual.add(new RitualComponent(0, 3, 5, 1));
        meteorRitual.add(new RitualComponent(0, 3, -5, 1));
        meteorRitual.add(new RitualComponent(5, 4, 0, 4));
        meteorRitual.add(new RitualComponent(-5, 4, 0, 4));
        meteorRitual.add(new RitualComponent(0, 4, 5, 4));
        meteorRitual.add(new RitualComponent(0, 4, -5, 4));
        for (i = -1; i <= 1; ++i) {
            meteorRitual.add(new RitualComponent(i, 4, 4, 4));
            meteorRitual.add(new RitualComponent(i, 4, -4, 4));
            meteorRitual.add(new RitualComponent(4, 4, i, 4));
            meteorRitual.add(new RitualComponent(-4, 4, i, 4));
        }
        meteorRitual.add(new RitualComponent(2, 4, 4, 1));
        meteorRitual.add(new RitualComponent(4, 4, 2, 1));
        meteorRitual.add(new RitualComponent(2, 4, -4, 1));
        meteorRitual.add(new RitualComponent(-4, 4, 2, 1));
        meteorRitual.add(new RitualComponent(-2, 4, 4, 1));
        meteorRitual.add(new RitualComponent(4, 4, -2, 1));
        meteorRitual.add(new RitualComponent(-2, 4, -4, 1));
        meteorRitual.add(new RitualComponent(-4, 4, -2, 1));
        meteorRitual.add(new RitualComponent(2, 4, 3, 2));
        meteorRitual.add(new RitualComponent(3, 4, 2, 2));
        meteorRitual.add(new RitualComponent(3, 4, 3, 2));
        meteorRitual.add(new RitualComponent(-2, 4, 3, 2));
        meteorRitual.add(new RitualComponent(3, 4, -2, 2));
        meteorRitual.add(new RitualComponent(3, 4, -3, 2));
        meteorRitual.add(new RitualComponent(2, 4, -3, 2));
        meteorRitual.add(new RitualComponent(-3, 4, 2, 2));
        meteorRitual.add(new RitualComponent(-3, 4, 3, 2));
        meteorRitual.add(new RitualComponent(-2, 4, -3, 2));
        meteorRitual.add(new RitualComponent(-3, 4, -2, 2));
        meteorRitual.add(new RitualComponent(-3, 4, -3, 2));
        return meteorRitual;
    }
}

