/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.RoutingFocusParadigm;
import WayofTime.alchemicalWizardry.api.RoutingFocusPosAndFacing;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.items.routing.InputRoutingFocus;
import WayofTime.alchemicalWizardry.common.items.routing.OutputRoutingFocus;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RitualEffectItemRouting
extends RitualEffect {
    Random rand = new Random();

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (world.getWorldTime() % 20L != 0L) {
            return;
        }
        HashMap tileMap = new HashMap();
        ArrayList<IInventory> outputList = new ArrayList<IInventory>();
        for (int i = 0; i < 4; ++i) {
            Int3 outputFocusChest = this.getOutputBufferChestLocation(i);
            TileEntity outputFocusInv = world.getTileEntity(x + outputFocusChest.xCoord, y + outputFocusChest.yCoord, z + outputFocusChest.zCoord);
            if (!(outputFocusInv instanceof IInventory)) continue;
            outputList.add((IInventory)outputFocusInv);
        }
        if (outputList.isEmpty()) {
            return;
        }
        for (IInventory outputFocusInventory : outputList) {
            RoutingFocusParadigm parad = new RoutingFocusParadigm();
            TileEntity outputChest = null;
            IInventory outputChestInventory = null;
            boolean lastItemWasFocus = true;
            for (int j = 0; j < outputFocusInventory.getSizeInventory(); ++j) {
                ItemStack keyStack = outputFocusInventory.getStackInSlot(j);
                if (keyStack == null) continue;
                if (keyStack.getItem() instanceof OutputRoutingFocus) {
                    if (!lastItemWasFocus) {
                        parad.clear();
                    }
                    OutputRoutingFocus outputFocus = (OutputRoutingFocus)keyStack.getItem();
                    parad.addRoutingFocusPosAndFacing(outputFocus.getPosAndFacing(keyStack));
                    parad.addLogic(outputFocus.getLogic(keyStack));
                    lastItemWasFocus = true;
                    continue;
                }
                lastItemWasFocus = false;
                for (RoutingFocusPosAndFacing posAndFacing : parad.locationList) {
                    if (posAndFacing == null) continue;
                    ForgeDirection inputDirection = posAndFacing.facing;
                    if (outputChest == null || !posAndFacing.location.equals(new Int3(outputChest.xCoord, outputChest.yCoord, outputChest.zCoord))) {
                        outputChest = world.getTileEntity(posAndFacing.location.xCoord, posAndFacing.location.yCoord, posAndFacing.location.zCoord);
                        if (!(outputChest instanceof IInventory)) continue;
                        outputChestInventory = (IInventory)outputChest;
                    }
                    for (int i = 0; i < 4; ++i) {
                        Int3 inputFocusChest = this.getInputBufferChestLocation(i);
                        TileEntity inputFocusInv = world.getTileEntity(x + inputFocusChest.xCoord, y + inputFocusChest.yCoord, z + inputFocusChest.zCoord);
                        if (!(inputFocusInv instanceof IInventory)) continue;
                        for (int ji = 0; ji < ((IInventory)inputFocusInv).getSizeInventory(); ++ji) {
                            int ni;
                            InputRoutingFocus inputFocus;
                            TileEntity inputChest;
                            ItemStack inputFocusStack = ((IInventory)inputFocusInv).getStackInSlot(ji);
                            if (inputFocusStack == null || !(inputFocusStack.getItem() instanceof InputRoutingFocus) || !((inputChest = world.getTileEntity((inputFocus = (InputRoutingFocus)inputFocusStack.getItem()).xCoord(inputFocusStack), inputFocus.yCoord(inputFocusStack), inputFocus.zCoord(inputFocusStack))) instanceof IInventory)) continue;
                            IInventory inputChestInventory = (IInventory)inputChest;
                            ForgeDirection syphonDirection = inputFocus.getSetDirection(inputFocusStack);
                            boolean[] canSyphonList = new boolean[inputChestInventory.getSizeInventory()];
                            if (inputChest instanceof ISidedInventory) {
                                int[] validSlots;
                                for (int in : validSlots = ((ISidedInventory)inputChest).getAccessibleSlotsFromSide(syphonDirection.ordinal())) {
                                    canSyphonList[in] = true;
                                }
                            } else {
                                for (ni = 0; ni < inputChestInventory.getSizeInventory(); ++ni) {
                                    canSyphonList[ni] = true;
                                }
                            }
                            for (ni = 0; ni < inputChestInventory.getSizeInventory(); ++ni) {
                                ItemStack syphonedStack;
                                if (!canSyphonList[ni] || (syphonedStack = inputChestInventory.getStackInSlot(ni)) == null || inputChestInventory instanceof ISidedInventory && !((ISidedInventory)inputChestInventory).canExtractItem(ni, syphonedStack, syphonDirection.ordinal())) continue;
                                int size = syphonedStack.stackSize;
                                if (!parad.doesItemMatch(keyStack, syphonedStack)) continue;
                                ItemStack newStack = null;
                                newStack = parad.maximumAmount <= 0 ? SpellHelper.insertStackIntoInventory(syphonedStack, outputChestInventory, inputDirection) : SpellHelper.insertStackIntoInventory(syphonedStack, outputChestInventory, inputDirection, parad.maximumAmount);
                                if (size == newStack.stackSize) continue;
                                int numberSyphoned = size - newStack.stackSize;
                                if (newStack != null && newStack.stackSize <= 0) {
                                    size = newStack.stackSize;
                                    newStack = null;
                                }
                                inputChestInventory.setInventorySlotContents(ni, newStack);
                            }
                        }
                    }
                }
            }
        }
    }

    public Int3 getInputBufferChestLocation(int number) {
        switch (number) {
            case 0: {
                return new Int3(1, 0, 0);
            }
            case 1: {
                return new Int3(-1, 0, 0);
            }
            case 2: {
                return new Int3(0, 0, 1);
            }
            case 3: {
                return new Int3(0, 0, -1);
            }
        }
        return new Int3(0, 0, 0);
    }

    public Int3 getOutputBufferChestLocation(int number) {
        switch (number) {
            case 0: {
                return new Int3(2, 0, 2);
            }
            case 1: {
                return new Int3(-2, 0, 2);
            }
            case 2: {
                return new Int3(2, 0, -2);
            }
            case 3: {
                return new Int3(-2, 0, -2);
            }
        }
        return new Int3(0, 0, 0);
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostPhantomHands[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> omegaRitual = new ArrayList<RitualComponent>();
        this.addCornerRunes(omegaRitual, 1, 0, 0);
        this.addOffsetRunes(omegaRitual, 2, 1, 0, 2);
        this.addParallelRunes(omegaRitual, 4, 0, 1);
        this.addParallelRunes(omegaRitual, 5, 0, 3);
        this.addCornerRunes(omegaRitual, 4, 0, 1);
        return omegaRitual;
    }
}

