/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class RitualEffectFeatheredEarth
extends RitualEffect {
    public static final int terraeDrain = 1;
    public static final int orbisTerraeDrain = 1;
    public static final int aetherDrain = 1;
    public static final int costCooldown = 10;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (ritualStone.getCooldown() > 0) {
            world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)(x + 4), (double)(y + 5), (double)(z + 4)));
            world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)(x + 4), (double)(y + 5), (double)(z - 4)));
            world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)(x - 4), (double)(y + 5), (double)(z - 4)));
            world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)(x - 4), (double)(y + 5), (double)(z + 4)));
            ritualStone.setCooldown(0);
        }
        boolean hasTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 1, false);
        boolean hasOrbisTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 1, false);
        boolean hasAether = this.canDrainReagent(ritualStone, ReagentRegistry.aetherReagent, 1, false);
        int range = this.getHorizontalRangeForReagent(hasTerrae, hasOrbisTerrae);
        int verticalRange = hasAether ? 60 : 30;
        List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).expand((double)range, (double)verticalRange, (double)range));
        int entityCount = 0;
        boolean flag = false;
        for (EntityLivingBase entity : entities) {
            ++entityCount;
        }
        if (currentEssence < this.getCostPerRefresh() * entityCount) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            for (EntityLivingBase entity : entities) {
                entity.fallDistance = 0.0f;
                flag = true;
            }
            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh() * entityCount);
            if (flag && world.getWorldTime() % 10L == 0L) {
                if (hasTerrae) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 1, true);
                }
                if (hasOrbisTerrae) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 1, true);
                }
                if (hasAether) {
                    this.canDrainReagent(ritualStone, ReagentRegistry.aetherReagent, 1, true);
                }
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostFeatheredEarth[1];
    }

    @Override
    public int getInitialCooldown() {
        return 1;
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> featheredEarthRitual = new ArrayList<RitualComponent>();
        featheredEarthRitual.add(new RitualComponent(1, 0, 0, 5));
        featheredEarthRitual.add(new RitualComponent(-1, 0, 0, 5));
        featheredEarthRitual.add(new RitualComponent(0, 0, 1, 5));
        featheredEarthRitual.add(new RitualComponent(0, 0, -1, 5));
        featheredEarthRitual.add(new RitualComponent(2, 0, 2, 4));
        featheredEarthRitual.add(new RitualComponent(-2, 0, 2, 4));
        featheredEarthRitual.add(new RitualComponent(-2, 0, -2, 4));
        featheredEarthRitual.add(new RitualComponent(2, 0, -2, 4));
        featheredEarthRitual.add(new RitualComponent(1, 0, 3, 3));
        featheredEarthRitual.add(new RitualComponent(0, 0, 3, 3));
        featheredEarthRitual.add(new RitualComponent(-1, 0, 3, 3));
        featheredEarthRitual.add(new RitualComponent(1, 0, -3, 3));
        featheredEarthRitual.add(new RitualComponent(0, 0, -3, 3));
        featheredEarthRitual.add(new RitualComponent(-1, 0, -3, 3));
        featheredEarthRitual.add(new RitualComponent(3, 0, 1, 3));
        featheredEarthRitual.add(new RitualComponent(3, 0, 0, 3));
        featheredEarthRitual.add(new RitualComponent(3, 0, -1, 3));
        featheredEarthRitual.add(new RitualComponent(-3, 0, 1, 3));
        featheredEarthRitual.add(new RitualComponent(-3, 0, 0, 3));
        featheredEarthRitual.add(new RitualComponent(-3, 0, -1, 3));
        featheredEarthRitual.add(new RitualComponent(4, 4, 4, 2));
        featheredEarthRitual.add(new RitualComponent(-4, 4, 4, 2));
        featheredEarthRitual.add(new RitualComponent(-4, 4, -4, 2));
        featheredEarthRitual.add(new RitualComponent(4, 4, -4, 2));
        featheredEarthRitual.add(new RitualComponent(4, 5, 5, 4));
        featheredEarthRitual.add(new RitualComponent(4, 5, 3, 4));
        featheredEarthRitual.add(new RitualComponent(5, 5, 4, 4));
        featheredEarthRitual.add(new RitualComponent(3, 5, 4, 4));
        featheredEarthRitual.add(new RitualComponent(-4, 5, 5, 4));
        featheredEarthRitual.add(new RitualComponent(-4, 5, 3, 4));
        featheredEarthRitual.add(new RitualComponent(-5, 5, 4, 4));
        featheredEarthRitual.add(new RitualComponent(-3, 5, 4, 4));
        featheredEarthRitual.add(new RitualComponent(4, 5, -5, 4));
        featheredEarthRitual.add(new RitualComponent(4, 5, -3, 4));
        featheredEarthRitual.add(new RitualComponent(5, 5, -4, 4));
        featheredEarthRitual.add(new RitualComponent(3, 5, -4, 4));
        featheredEarthRitual.add(new RitualComponent(-4, 5, -5, 4));
        featheredEarthRitual.add(new RitualComponent(-4, 5, -3, 4));
        featheredEarthRitual.add(new RitualComponent(-5, 5, -4, 4));
        featheredEarthRitual.add(new RitualComponent(-3, 5, -4, 4));
        return featheredEarthRitual;
    }

    public int getHorizontalRangeForReagent(boolean hasTerrae, boolean hasOrbisTerrae) {
        if (hasOrbisTerrae) {
            if (hasTerrae) {
                return 64;
            }
            return 45;
        }
        if (hasTerrae) {
            return 30;
        }
        return 20;
    }
}

