/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.renderer;

import WayofTime.alchemicalWizardry.api.renderer.MRSRenderer;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class AlchemyCircleRenderer
extends MRSRenderer {
    private ResourceLocation resourceLocation = new ResourceLocation("alchemicalwizardry:textures/models/TransCircle.png");
    private int colourRed;
    private int colourGreen;
    private int colourBlue;
    private int colourIntensity;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private double radius;
    private double initialY;
    private boolean renderWithoutReagents;

    public AlchemyCircleRenderer(ResourceLocation resource, int red, int green, int blue, int intensity, double xOff, double initialY, double yOff, double zOff, double radius, boolean renderWithoutReagents) {
        this.resourceLocation = resource;
        this.colourRed = red;
        this.colourGreen = green;
        this.colourBlue = blue;
        this.colourIntensity = intensity;
        this.xOffset = xOff;
        this.initialY = initialY;
        this.yOffset = yOff;
        this.zOffset = zOff;
        this.radius = radius;
        this.renderWithoutReagents = renderWithoutReagents;
    }

    @Override
    public void renderAt(IMasterRitualStone tile, double x, double y, double z) {
        if (tile.areTanksEmpty() && !this.renderWithoutReagents) {
            return;
        }
        GL11.glPushMatrix();
        float f1 = 1.0f;
        Tessellator tessellator = Tessellator.instance;
        this.bindTexture(this.resourceLocation);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        float f2 = 0.0f;
        float f3 = -f2 * 0.2f - (float)MathHelper.floor_float((float)(-f2 * 0.1f));
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(this.colourRed, this.colourGreen, this.colourBlue, this.colourIntensity);
        GL11.glTranslated((double)(x + 0.5 + this.xOffset), (double)(y + 0.5 + (this.yOffset - this.initialY) * ((double)tile.getRunningTime() / 100.0) + this.initialY), (double)(z + 0.5 + this.zOffset));
        float rotationAngle = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
        GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        tessellator.setBrightness(240);
        double finalRadius = this.radius * ((double)tile.getRunningTime() / 100.0);
        tessellator.addVertexWithUV(-finalRadius, 0.0, -finalRadius, 0.0, 0.0);
        tessellator.addVertexWithUV(finalRadius, 0.0, -finalRadius, 1.0, 0.0);
        tessellator.addVertexWithUV(finalRadius, 0.0, finalRadius, 1.0, 1.0);
        tessellator.addVertexWithUV(-finalRadius, 0.0, finalRadius, 0.0, 1.0);
        tessellator.draw();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

