/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil.holding;

import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryHolding
implements IInventory {
    public ItemStack parentItemStack;
    protected ItemStack[] inventory;
    protected static String NBT_MOST_SIG = "MostSig";
    protected static String NBT_LEAST_SIG = "LeastSig";
    protected static String NBT_ITEMS = "Items";

    public InventoryHolding(ItemStack itemStack) {
        this.parentItemStack = itemStack;
        this.inventory = new ItemStack[5];
        this.readFromNBT(itemStack.getTagCompound());
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        this.parentItemStack = this.findParentItemStack(entityPlayer);
        if (this.parentItemStack != null) {
            this.save();
        }
    }

    public ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (InventoryHolding.hasUUID(this.parentItemStack)) {
            UUID parentItemStackUUID = new UUID(this.parentItemStack.getTagCompound().getLong(NBT_MOST_SIG), this.parentItemStack.getTagCompound().getLong(NBT_LEAST_SIG));
            for (int i = 0; i < entityPlayer.inventory.getSizeInventory(); ++i) {
                ItemStack itemStack = entityPlayer.inventory.getStackInSlot(i);
                if (!InventoryHolding.hasUUID(itemStack) || itemStack.getTagCompound().getLong(NBT_MOST_SIG) != parentItemStackUUID.getMostSignificantBits() || itemStack.getTagCompound().getLong(NBT_LEAST_SIG) != parentItemStackUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
        }
        return null;
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.parentItemStack.getTagCompound();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            UUID uuid = UUID.randomUUID();
            nbtTagCompound.setLong(NBT_MOST_SIG, uuid.getMostSignificantBits());
            nbtTagCompound.setLong(NBT_LEAST_SIG, uuid.getLeastSignificantBits());
        }
        this.writeToNBT(nbtTagCompound);
        this.parentItemStack.setTagCompound(nbtTagCompound);
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        return slotIndex >= 0 && slotIndex < this.inventory.length ? this.inventory[slotIndex] : null;
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        if (this.inventory[slotIndex] != null) {
            ItemStack itemStack = this.inventory[slotIndex];
            this.inventory[slotIndex] = null;
            return itemStack;
        }
        return null;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        if (slotIndex >= 0 && slotIndex < this.inventory.length) {
            this.inventory[slotIndex] = itemStack;
        }
    }

    public String getInventoryName() {
        return "SigilOfHolding";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return itemStack.getItem() instanceof ISigil;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null && nbtTagCompound.hasKey(NBT_ITEMS) && nbtTagCompound.hasKey(NBT_ITEMS)) {
            NBTTagList tagList = nbtTagCompound.getTagList(NBT_ITEMS, 10);
            this.inventory = new ItemStack[this.getSizeInventory()];
            for (int i = 0; i < tagList.tagCount(); ++i) {
                NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
                byte slotIndex = tagCompound.getByte("Slot");
                if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
                this.inventory[slotIndex] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setByte("Slot", (byte)currentIndex);
            this.inventory[currentIndex].writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag(NBT_ITEMS, (NBTBase)tagList);
    }

    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return itemStack != null && itemStack.stackTagCompound != null && itemStack.stackTagCompound.hasKey(keyName);
    }

    public static boolean hasUUID(ItemStack itemStack) {
        return InventoryHolding.hasTag(itemStack, NBT_MOST_SIG) && InventoryHolding.hasTag(itemStack, NBT_LEAST_SIG);
    }

    public static void setUUID(ItemStack itemStack) {
        InventoryHolding.initNBTTagCompound(itemStack);
        if (!InventoryHolding.hasTag(itemStack, NBT_MOST_SIG) && !InventoryHolding.hasTag(itemStack, NBT_LEAST_SIG)) {
            UUID itemUUID = UUID.randomUUID();
            InventoryHolding.setLong(itemStack, NBT_MOST_SIG, itemUUID.getMostSignificantBits());
            InventoryHolding.setLong(itemStack, NBT_LEAST_SIG, itemUUID.getLeastSignificantBits());
        }
    }

    private static void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack.stackTagCompound == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
    }

    public static void setLong(ItemStack itemStack, String keyName, long keyValue) {
        InventoryHolding.initNBTTagCompound(itemStack);
        itemStack.stackTagCompound.setLong(keyName, keyValue);
    }
}

