/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class SigilFluid
extends Item
implements IFluidContainerItem,
ISigil {
    private int capacity = 128000;
    private static final int STATE_SYPHON = 0;
    private static final int STATE_FORCE_SYPHON = 1;
    private static final int STATE_PLACE = 2;
    private static final int STATE_INPUT_TANK = 3;
    private static final int STATE_DRAIN_TANK = 4;
    private static final int STATE_BEAST_DRAIN = 5;
    private static final int maxNumOfStates = 6;

    public SigilFluid() {
        this.setMaxDamage(0);
        this.setMaxStackSize(1);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.fluidsigil.desc"));
        if (par1ItemStack.getTagCompound() != null) {
            switch (this.getActionState(par1ItemStack)) {
                case 0: {
                    par3List.add(StatCollector.translateToLocal((String)"tooltip.fluidsigil.syphoningmode"));
                    break;
                }
                case 1: {
                    par3List.add(StatCollector.translateToLocal((String)"tooltip.fluidsigil.forcesyphonmode"));
                    break;
                }
                case 2: {
                    par3List.add(StatCollector.translateToLocal((String)"tooltip.fluidsigil.fluidplacementmode"));
                    break;
                }
                case 3: {
                    par3List.add(StatCollector.translateToLocal((String)"tooltip.fluidsigil.filltankmode"));
                    break;
                }
                case 4: {
                    par3List.add(StatCollector.translateToLocal((String)"tooltip.fluidsigil.draintankmode"));
                    break;
                }
                case 5: {
                    par3List.add(StatCollector.translateToLocal((String)"tooltip.fluidsigil.beastmode"));
                }
            }
            FluidStack fluid = this.getFluid(par1ItemStack);
            if (fluid != null && fluid.amount > 0) {
                String str = fluid.getFluid().getName();
                int amount = fluid.amount;
                par3List.add("" + amount + "mB of " + str);
            } else {
                par3List.add("Empty");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:WaterSigil");
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par3EntityPlayer.isSneaking()) {
            int curState = this.cycleActionState(par1ItemStack);
            this.sendMessageViaState(curState, par3EntityPlayer);
            return par1ItemStack;
        }
        switch (this.getActionState(par1ItemStack)) {
            case 0: {
                return this.fillItemFromWorld(par1ItemStack, par2World, par3EntityPlayer, false);
            }
            case 1: {
                return this.fillItemFromWorld(par1ItemStack, par2World, par3EntityPlayer, true);
            }
            case 2: {
                return this.emptyItemToWorld(par1ItemStack, par2World, par3EntityPlayer);
            }
            case 3: {
                return this.fillSelectedTank(par1ItemStack, par2World, par3EntityPlayer);
            }
            case 4: {
                return this.drainSelectedTank(par1ItemStack, par2World, par3EntityPlayer);
            }
            case 5: {
                return this.fillItemFromBeastWorld(par1ItemStack, par2World, par3EntityPlayer, true);
            }
        }
        return par1ItemStack;
    }

    public int getActionState(ItemStack item) {
        if (item.getTagCompound() == null) {
            item.setTagCompound(new NBTTagCompound());
        }
        return item.getTagCompound().getInteger("actionState");
    }

    public void setActionState(ItemStack item, int actionState) {
        if (item.getTagCompound() == null) {
            item.setTagCompound(new NBTTagCompound());
        }
        item.getTagCompound().setInteger("actionState", actionState);
    }

    public int cycleActionState(ItemStack item) {
        int state = this.getActionState(item);
        if (++state >= 6) {
            state = 0;
        }
        this.setActionState(item, state);
        return state;
    }

    public void sendMessageViaState(int state, EntityPlayer player) {
        if (player.worldObj.isRemote) {
            ChatComponentText cmc = new ChatComponentText("");
            switch (state) {
                case 0: {
                    cmc.appendText("Now in Syphoning Mode");
                    break;
                }
                case 1: {
                    cmc.appendText("Now in Force-syphon Mode");
                    break;
                }
                case 2: {
                    cmc.appendText("Now in Fluid Placement Mode");
                    break;
                }
                case 3: {
                    cmc.appendText("Now in Fill Tank Mode");
                    break;
                }
                case 4: {
                    cmc.appendText("Now in Drain Tank Mode");
                    break;
                }
                case 5: {
                    cmc.appendText("Now in Beast Mode");
                }
            }
            player.addChatComponentMessage((IChatComponent)cmc);
        }
    }

    public ItemStack fillItemFromBeastWorld(ItemStack container, World world, EntityPlayer player, boolean forceFill) {
        if (world.isRemote) {
            return container;
        }
        int range = 5;
        float f = 1.0f;
        boolean flag = true;
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(world, player, flag);
        if (movingobjectposition == null) {
            return container;
        }
        if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = movingobjectposition.blockX;
            int y = movingobjectposition.blockY;
            int z = movingobjectposition.blockZ;
            if (!world.canMineBlock(player, x, y, z)) {
                return container;
            }
            if (!player.canPlayerEdit(x, y, z, movingobjectposition.sideHit, container)) {
                return container;
            }
            boolean[][][] boolList = new boolean[range * 2 + 1][range * 2 + 1][range * 2 + 1];
            for (int i = 0; i < 2 * range + 1; ++i) {
                for (int j = 0; j < 2 * range + 1; ++j) {
                    for (int k = 0; k < 2 * range + 1; ++k) {
                        boolList[i][j][k] = false;
                    }
                }
            }
            ArrayList<Int3> positionList = new ArrayList<Int3>();
            boolList[range][range][range] = true;
            positionList.add(new Int3(range, range, range));
            boolean isReady = false;
            while (!isReady) {
                isReady = true;
                for (int i = 0; i < 2 * range + 1; ++i) {
                    for (int j = 0; j < 2 * range + 1; ++j) {
                        for (int k = 0; k < 2 * range + 1; ++k) {
                            Block block;
                            Fluid fluid;
                            if (!boolList[i][j][k]) continue;
                            if (i - 1 >= 0 && !boolList[i - 1][j][k] && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.getBlock(x - range + i - 1, y - range + j, z - range + k)))) != null) {
                                boolList[i - 1][j][k] = true;
                                positionList.add(new Int3(i - 1, j, k));
                                isReady = false;
                            }
                            if (j - 1 >= 0 && !boolList[i][j - 1][k] && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.getBlock(x - range + i, y - range + j - 1, z - range + k)))) != null) {
                                boolList[i][j - 1][k] = true;
                                positionList.add(new Int3(i, j - 1, k));
                                isReady = false;
                            }
                            if (k - 1 >= 0 && !boolList[i][j][k - 1] && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.getBlock(x - range + i, y - range + j, z - range + k - 1)))) != null) {
                                boolList[i][j][k - 1] = true;
                                positionList.add(new Int3(i, j, k - 1));
                                isReady = false;
                            }
                            if (i + 1 <= 2 * range && !boolList[i + 1][j][k] && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.getBlock(x - range + i + 1, y - range + j, z - range + k)))) != null) {
                                boolList[i + 1][j][k] = true;
                                positionList.add(new Int3(i + 1, j, k));
                                isReady = false;
                            }
                            if (j + 1 <= 2 * range && !boolList[i][j + 1][k] && (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.getBlock(x - range + i, y - range + j + 1, z - range + k)))) != null) {
                                boolList[i][j + 1][k] = true;
                                positionList.add(new Int3(i, j + 1, k));
                                isReady = false;
                            }
                            if (k + 1 > 2 * range || boolList[i][j][k + 1] || (fluid = FluidRegistry.lookupFluidForBlock((Block)(block = world.getBlock(x - range + i, y - range + j, z - range + k + 1)))) == null) continue;
                            boolList[i][j][k + 1] = true;
                            positionList.add(new Int3(i, j, k + 1));
                            isReady = false;
                        }
                    }
                }
            }
            for (Int3 pos : positionList) {
                FluidStack fillStack;
                int amount;
                Block block;
                int i = pos.xCoord;
                int j = pos.yCoord;
                int k = pos.zCoord;
                if (!boolList[i][j][k] || world.getBlock(x + i - range, y + j - range, z + k - range) == null || !(world.getBlock(x + i - range, y + j - range, z + k - range).getMaterial() instanceof MaterialLiquid) || (block = world.getBlock(x + i - range, y + j - range, z + k - range)) == null) continue;
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                AlchemicalWizardry.logger.info("x: " + (i - range) + " y: " + (j - range) + " z: " + (k - range));
                if (fluid == null || world.getBlockMetadata(x + i - range, y + j - range, z + k - range) != 0 || ((amount = this.fill(container, fillStack = new FluidStack(fluid, 1000), false)) <= 0 || !forceFill) && (amount < 1000 || forceFill)) continue;
                world.setBlockToAir(x + i - range, y + j - range, z + k - range);
                this.fill(container, new FluidStack(fluid, 1000), true);
            }
        }
        return container;
    }

    public ItemStack fillItemFromWorld(ItemStack container, World world, EntityPlayer player, boolean forceFill) {
        float f = 1.0f;
        boolean flag = true;
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(world, player, flag);
        if (movingobjectposition == null) {
            return container;
        }
        if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            if (!world.canMineBlock(player, i, j, k)) {
                return container;
            }
            if (!player.canPlayerEdit(i, j, k, movingobjectposition.sideHit, container)) {
                return container;
            }
            if (world.getBlock(i, j, k) != null && world.getBlock(i, j, k).getMaterial() instanceof MaterialLiquid) {
                Block block = world.getBlock(i, j, k);
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                if (fluid == null) {
                    return container;
                }
                FluidStack fillStack = new FluidStack(fluid, 1000);
                int amount = this.fill(container, fillStack, false);
                if (amount > 0 && forceFill || amount >= 1000 && !forceFill) {
                    if (!player.capabilities.isCreativeMode) {
                        world.setBlockToAir(i, j, k);
                    }
                    this.fill(container, new FluidStack(fluid, 1000), true);
                    if (player.capabilities.isCreativeMode) {
                        return container;
                    }
                }
            }
        }
        return container;
    }

    public ItemStack emptyItemToWorld(ItemStack container, World world, EntityPlayer player) {
        FluidStack simStack = this.drain(container, 1000, false);
        if (simStack != null && simStack.amount >= 1000) {
            Block fluidBlock = simStack.getFluid().getBlock();
            float f = 1.0f;
            double d0 = player.prevPosX + (player.posX - player.prevPosX) * (double)f;
            double d1 = player.prevPosY + (player.posY - player.prevPosY) * (double)f + 1.62 - (double)player.yOffset;
            double d2 = player.prevPosZ + (player.posZ - player.prevPosZ) * (double)f;
            boolean flag = false;
            MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(world, player, flag);
            if (movingobjectposition == null) {
                return container;
            }
            if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
                int i = movingobjectposition.blockX;
                int j = movingobjectposition.blockY;
                int k = movingobjectposition.blockZ;
                if (!world.canMineBlock(player, i, j, k)) {
                    return container;
                }
                if (movingobjectposition.sideHit == 0) {
                    --j;
                }
                if (movingobjectposition.sideHit == 1) {
                    ++j;
                }
                if (movingobjectposition.sideHit == 2) {
                    --k;
                }
                if (movingobjectposition.sideHit == 3) {
                    ++k;
                }
                if (movingobjectposition.sideHit == 4) {
                    --i;
                }
                if (movingobjectposition.sideHit == 5) {
                    ++i;
                }
                if (!player.canPlayerEdit(i, j, k, movingobjectposition.sideHit, container)) {
                    return container;
                }
                if (this.tryPlaceContainedLiquid(world, fluidBlock, d0, d1, d2, i, j, k) && !player.capabilities.isCreativeMode) {
                    this.drain(container, 1000, true);
                    return container;
                }
            }
            return container;
        }
        return container;
    }

    public boolean tryPlaceContainedLiquid(World par1World, Block block, double par2, double par4, double par6, int par8, int par9, int par10) {
        if (!par1World.isAirBlock(par8, par9, par10) && par1World.getBlock(par8, par9, par10).func_149730_j()) {
            return false;
        }
        if (par1World.getBlock(par8, par9, par10).getMaterial() instanceof MaterialLiquid && par1World.getBlockMetadata(par8, par9, par10) == 0) {
            return false;
        }
        if ((block == Blocks.water || block == Blocks.flowing_water) && par1World.provider.isHellWorld) {
            par1World.playSoundEffect(par2 + 0.5, par4 + 0.5, par6 + 0.5, "random.fizz", 0.5f, 2.6f + (par1World.rand.nextFloat() - par1World.rand.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                par1World.spawnParticle("largesmoke", (double)par8 + Math.random(), (double)par9 + Math.random(), (double)par10 + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            par1World.setBlock(par8, par9, par10, block, 0, 3);
        }
        return true;
    }

    public ItemStack fillSelectedTank(ItemStack container, World world, EntityPlayer player) {
        int k;
        int j;
        int i;
        TileEntity tile;
        FluidStack fluid = this.getFluid(container);
        if (fluid == null) {
            return container;
        }
        float f = 1.0f;
        boolean flag = false;
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(world, player, flag);
        if (movingobjectposition == null) {
            return container;
        }
        if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && (tile = world.getTileEntity(i = movingobjectposition.blockX, j = movingobjectposition.blockY, k = movingobjectposition.blockZ)) instanceof IFluidHandler) {
            int amount = ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)movingobjectposition.sideHit), fluid, true);
            this.drain(container, amount, true);
        }
        return container;
    }

    public ItemStack drainSelectedTank(ItemStack container, World world, EntityPlayer player) {
        FluidStack fluidAmount;
        int amount;
        int k;
        int j;
        int i;
        TileEntity tile;
        float f = 1.0f;
        boolean flag = false;
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(world, player, flag);
        if (movingobjectposition == null) {
            return container;
        }
        if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && (tile = world.getTileEntity(i = movingobjectposition.blockX, j = movingobjectposition.blockY, k = movingobjectposition.blockZ)) instanceof IFluidHandler && (amount = this.fill(container, fluidAmount = ((IFluidHandler)tile).drain(ForgeDirection.getOrientation((int)movingobjectposition.sideHit), this.getCapacity(container), false), false)) > 0) {
            ((IFluidHandler)tile).drain(ForgeDirection.getOrientation((int)movingobjectposition.sideHit), this.getCapacity(container), true);
            this.fill(container, fluidAmount, true);
        }
        return container;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.getTagCompound() == null || !container.getTagCompound().hasKey("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.getTagCompound().getCompoundTag("Fluid"));
    }

    public int getCapacity(ItemStack container) {
        return this.capacity;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (container.getTagCompound() == null || !container.getTagCompound().hasKey("Fluid")) {
                return Math.min(this.capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.getTagCompound().getCompoundTag("Fluid"));
            if (stack == null || stack.amount <= 0) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - stack.amount, resource.amount);
        }
        if (container.getTagCompound() == null) {
            container.setTagCompound(new NBTTagCompound());
        }
        if (!container.getTagCompound().hasKey("Fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (this.capacity < resource.amount) {
                fluidTag.setInteger("Amount", this.capacity);
                container.getTagCompound().setTag("Fluid", (NBTBase)fluidTag);
                return this.capacity;
            }
            container.getTagCompound().setTag("Fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.getTagCompound().getCompoundTag("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (stack == null || stack.amount <= 0) {
            NBTTagCompound fluidTag1 = resource.writeToNBT(new NBTTagCompound());
            if (this.capacity < resource.amount) {
                fluidTag1.setInteger("Amount", this.capacity);
                container.getTagCompound().setTag("Fluid", (NBTBase)fluidTag1);
                return this.capacity;
            }
            container.getTagCompound().setTag("Fluid", (NBTBase)fluidTag1);
            return resource.amount;
        }
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = this.capacity;
        }
        container.getTagCompound().setTag("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.getTagCompound() == null || !container.getTagCompound().hasKey("Fluid")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.getTagCompound().getCompoundTag("Fluid"));
        if (stack == null) {
            return null;
        }
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            if (maxDrain >= this.capacity) {
                container.getTagCompound().removeTag("Fluid");
                if (container.getTagCompound().hasNoTags()) {
                    container.setTagCompound(null);
                }
                return stack;
            }
            NBTTagCompound fluidTag = container.getTagCompound().getCompoundTag("Fluid");
            fluidTag.setInteger("Amount", fluidTag.getInteger("Amount") - maxDrain);
            container.getTagCompound().setTag("Fluid", (NBTBase)fluidTag);
        }
        return stack;
    }
}

