/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.armour;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.items.armour.OmegaArmour;
import WayofTime.alchemicalWizardry.common.renderer.model.ModelOmegaFire;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.biome.BiomeGenBase;

public class OmegaArmourFire
extends OmegaArmour {
    @SideOnly(value=Side.CLIENT)
    private IIcon helmetIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon plateIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon leggingsIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bootsIcon;

    public OmegaArmourFire(int armorType) {
        super(armorType);
        this.storeBiomeID = true;
        this.illegalEnchantmentList.add(Enchantment.fireProtection);
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "alchemicalwizardry:models/armor/OmegaFire.png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getChestModel() {
        return new ModelOmegaFire(1.0f, true, true, false, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getLegsModel() {
        return new ModelOmegaFire(0.5f, false, false, true, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:SheathedItem");
        this.helmetIcon = iconRegister.registerIcon("AlchemicalWizardry:OmegaHelmet_fire");
        this.plateIcon = iconRegister.registerIcon("AlchemicalWizardry:OmegaPlate_fire");
        this.leggingsIcon = iconRegister.registerIcon("AlchemicalWizardry:OmegaLeggings_fire");
        this.bootsIcon = iconRegister.registerIcon("AlchemicalWizardry:OmegaBoots_fire");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        if (this.equals(ModItems.boundHelmetFire)) {
            return this.helmetIcon;
        }
        if (this.equals(ModItems.boundPlateFire)) {
            return this.plateIcon;
        }
        if (this.equals(ModItems.boundLeggingsFire)) {
            return this.leggingsIcon;
        }
        if (this.equals(ModItems.boundBootsFire)) {
            return this.bootsIcon;
        }
        return this.itemIcon;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        int biomeID = this.getBiomeIDStored(stack);
        BiomeGenBase biome = BiomeGenBase.getBiome((int)biomeID);
        if (biome != null) {
            map.put((Object)SharedMonsterAttributes.maxHealth.getAttributeUnlocalizedName(), (Object)new AttributeModifier(new UUID(895132L, this.armorType), "Health modifier" + this.armorType, (double)(this.getDefaultArmourBoost() * this.getHealthBoostModifierForBiome(biome)), 1));
            map.put((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName(), (Object)new AttributeModifier(new UUID(196312L, this.armorType), "Damage modifier" + this.armorType, (double)(this.getDefaultArmourBoost() * this.getDamageModifierForBiome(biome)), 1));
        }
        return map;
    }

    public float getDefaultArmourBoost() {
        switch (this.armorType) {
            case 0: {
                return 2.5f;
            }
            case 1: {
                return 4.0f;
            }
            case 2: {
                return 3.5f;
            }
            case 3: {
                return 2.0f;
            }
        }
        return 0.25f;
    }

    public float getHealthBoostModifierForBiome(BiomeGenBase biome) {
        float modifier = 0.05f;
        if (biome.isEqualTo(BiomeGenBase.hell)) {
            return modifier * 2.0f;
        }
        if (biome.isEqualTo(BiomeGenBase.ocean)) {
            return modifier * -0.5f;
        }
        if (biome.temperature >= 1.0f) {
            return modifier * 1.5f;
        }
        return modifier * 0.5f;
    }

    public float getDamageModifierForBiome(BiomeGenBase biome) {
        float modifier = 0.03f;
        if (biome.isEqualTo(BiomeGenBase.hell)) {
            return modifier * 2.0f;
        }
        if (biome.isEqualTo(BiomeGenBase.ocean)) {
            return modifier * -0.5f;
        }
        if (biome.temperature >= 1.0f) {
            return modifier * 1.5f;
        }
        return modifier * 0.5f;
    }
}

