/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.common.block.RitualStone;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemRitualDismantler
extends EnergyItems {
    public ItemRitualDismantler() {
        this.setMaxStackSize(1);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:ritual_dismantler");
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List par3List, boolean x) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.dismatler.desc"));
        if (stack.hasTagCompound()) {
            par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + stack.getTagCompound().getString("ownerName"));
        }
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        return EnergyItems.checkAndSetItemOwner(stack, player) && this.breakRitualStoneAtMasterStone(stack, player, world, x, y, z);
    }

    public boolean breakRitualStoneAtMasterStone(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TEMasterStone) {
            TEMasterStone masterStone = (TEMasterStone)tileEntity;
            int direction = masterStone.getDirection();
            String ritualName = Rituals.checkValidRitual(world, x, y, z);
            List<RitualComponent> ritualList = Rituals.getRitualList(ritualName);
            if (ritualList == null) {
                return false;
            }
            for (RitualComponent rc : ritualList) {
                if (world.isAirBlock(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction)) || !(world.getBlock(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction)) instanceof RitualStone) || !EnergyItems.syphonBatteries(stack, player, this.getEnergyUsed()) && !player.capabilities.isCreativeMode) continue;
                world.setBlockToAir(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction));
                EntityItem entityItem = new EntityItem(world, player.posX, player.posY, player.posZ, new ItemStack(ModBlocks.ritualStone));
                if (world.isRemote) {
                    world.playAuxSFX(2005, x, y + 1, z, 0);
                    continue;
                }
                world.spawnEntityInWorld((Entity)entityItem);
            }
            return true;
        }
        return false;
    }
}

