/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.tileEntity.TESpellParadigmBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemComplexSpellCrystal
extends EnergyItems {
    public ItemComplexSpellCrystal() {
        this.setMaxStackSize(1);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:ComplexCrystal");
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.complexspellcrystal.desc"));
        if (par1ItemStack.getTagCompound() != null) {
            NBTTagCompound itemTag = par1ItemStack.getTagCompound();
            if (!par1ItemStack.getTagCompound().getString("ownerName").equals("")) {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + par1ItemStack.getTagCompound().getString("ownerName"));
            }
            par3List.add(StatCollector.translateToLocal((String)"tooltip.alchemy.coords") + " " + itemTag.getInteger("xCoord") + ", " + itemTag.getInteger("yCoord") + ", " + itemTag.getInteger("zCoord"));
            par3List.add(StatCollector.translateToLocal((String)"tooltip.alchemy.dimension") + " " + this.getDimensionID(par1ItemStack));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (par2World.isRemote) return par1ItemStack;
        WorldServer world = DimensionManager.getWorld((int)this.getDimensionID(par1ItemStack));
        if (world == null) return par1ItemStack;
        NBTTagCompound itemTag = par1ItemStack.getTagCompound();
        TileEntity tileEntity = world.getTileEntity(itemTag.getInteger("xCoord"), itemTag.getInteger("yCoord"), itemTag.getInteger("zCoord"));
        if (!(tileEntity instanceof TESpellParadigmBlock)) {
            return par1ItemStack;
        }
        TESpellParadigmBlock tileParad = (TESpellParadigmBlock)tileEntity;
        tileParad.castSpell(par2World, par3EntityPlayer, par1ItemStack);
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        return par1ItemStack;
    }

    public int getDimensionID(ItemStack itemStack) {
        if (itemStack.getTagCompound() == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        return itemStack.getTagCompound().getInteger("dimensionId");
    }
}

