/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.IAltarManipulator;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.tileEntity.TEAltar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBloodLetterPack
extends ItemArmor
implements ArmourUpgrade,
IAltarManipulator {
    @SideOnly(value=Side.CLIENT)
    private IIcon plateIcon;
    public int conversionRate = 100;
    public float activationPoint = 0.5f;
    public int tickRate = 20;
    public int maxStored = 10000;

    public ItemBloodLetterPack() {
        super(ItemArmor.ArmorMaterial.CHAIN, 0, 1);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.plateIcon = iconRegister.registerIcon("AlchemicalWizardry:BloodPack");
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.bloodletterpack.desc"));
        if (par1ItemStack.getTagCompound() != null) {
            par3List.add(StatCollector.translateToLocal((String)"tooltip.lp.storedlp") + " " + this.getStoredLP(par1ItemStack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.plateIcon;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "alchemicalwizardry:models/armor/bloodPack_layer_1.png";
    }

    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.isRemote) {
            return itemStack;
        }
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(world, player, false);
        if (movingobjectposition == null) {
            return super.onItemRightClick(itemStack, world, player);
        }
        if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            int amount;
            int x = movingobjectposition.blockX;
            int y = movingobjectposition.blockY;
            int z = movingobjectposition.blockZ;
            TileEntity tile = world.getTileEntity(x, y, z);
            if (!(tile instanceof TEAltar)) {
                return super.onItemRightClick(itemStack, world, player);
            }
            TEAltar altar = (TEAltar)tile;
            if (!altar.isActive() && (amount = this.getStoredLP(itemStack)) > 0) {
                int filledAmount = altar.fillMainTank(amount);
                this.setStoredLP(itemStack, amount -= filledAmount);
                world.markBlockForUpdate(x, y, z);
            }
        }
        return itemStack;
    }

    public void setStoredLP(ItemStack itemStack, int lp) {
        if (!itemStack.hasTagCompound()) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound tag = itemStack.getTagCompound();
        tag.setInteger("storedLP", lp);
    }

    public int getStoredLP(ItemStack itemStack) {
        if (!itemStack.hasTagCompound()) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound tag = itemStack.getTagCompound();
        return tag.getInteger("storedLP");
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.isRemote) {
            return;
        }
        if (world.getWorldTime() % (long)this.tickRate == 0L) {
            boolean shouldExecute;
            boolean bl = shouldExecute = player.getHealth() / player.getMaxHealth() > this.activationPoint && this.getStoredLP(itemStack) < this.maxStored;
            if (shouldExecute) {
                SoulNetworkHandler.hurtPlayer(player, 1.0f);
                this.setStoredLP(itemStack, Math.min(this.getStoredLP(itemStack) + this.conversionRate, this.maxStored));
            }
        }
    }

    @Override
    public void onArmourUpdate(World world, EntityPlayer player, ItemStack thisItemStack) {
    }

    @Override
    public boolean isUpgrade() {
        return true;
    }

    @Override
    public int getEnergyForTenSeconds() {
        return 0;
    }
}

