/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.api.soulNetwork.LifeEssenceNetwork;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class EnergyItems
extends Item
implements IBindable {
    private int energyUsed;

    public EnergyItems() {
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
    }

    protected void setEnergyUsed(int par1int) {
        this.energyUsed = par1int;
    }

    protected int getEnergyUsed() {
        return this.energyUsed;
    }

    protected void damagePlayer(World world, EntityPlayer player, int damage) {
        if (world != null) {
            double posX = player.posX;
            double posY = player.posY;
            double posZ = player.posZ;
            world.playSoundEffect((double)((float)posX + 0.5f), (double)((float)posY + 0.5f), (double)((float)posZ + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            float f = 1.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = f * f * 0.7f - 0.5f;
            float f3 = f * f * 0.6f - 0.7f;
            for (int l = 0; l < 8; ++l) {
                world.spawnParticle("reddust", posX + Math.random() - Math.random(), posY + Math.random() - Math.random(), posZ + Math.random() - Math.random(), (double)f1, (double)f2, (double)f3);
            }
        }
        for (int i = 0; i < damage; ++i) {
            player.setHealth(player.getHealth() - 1.0f);
            if (!((double)player.getHealth() <= 5.0E-4)) continue;
            player.inventory.dropAllItems();
            break;
        }
    }

    public static boolean syphonBatteries(ItemStack ist, EntityPlayer player, int damageToBeDone) {
        if (!player.worldObj.isRemote) {
            return SoulNetworkHandler.syphonAndDamageFromNetwork(ist, player, damageToBeDone);
        }
        World world = player.worldObj;
        if (world != null) {
            double posX = player.posX;
            double posY = player.posY;
            double posZ = player.posZ;
            SpellHelper.sendIndexedParticleToAllAround(world, posX, posY, posZ, 20, world.provider.dimensionId, 4, posX, posY, posZ);
            world.playSoundEffect((double)((float)player.posX + 0.5f), (double)((float)player.posY + 0.5f), (double)((float)player.posZ + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        }
        return true;
    }

    @Deprecated
    public static boolean syphonWhileInContainer(ItemStack ist, int damageToBeDone) {
        if (ist.getTagCompound() != null && !ist.getTagCompound().getString("ownerName").equals("")) {
            String ownerName = ist.getTagCompound().getString("ownerName");
            if (MinecraftServer.getServer() == null) {
                return false;
            }
            WorldServer world = MinecraftServer.getServer().worldServers[0];
            LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
            if (data == null) {
                data = new LifeEssenceNetwork(ownerName);
                world.setItemData(ownerName, (WorldSavedData)data);
            }
            if (data.currentEssence >= damageToBeDone) {
                data.currentEssence -= damageToBeDone;
                data.markDirty();
                return true;
            }
        }
        return false;
    }

    public static boolean canSyphonInContainer(ItemStack ist, int damageToBeDone) {
        if (ist.getTagCompound() != null && !ist.getTagCompound().getString("ownerName").equals("")) {
            String ownerName = ist.getTagCompound().getString("ownerName");
            if (MinecraftServer.getServer() == null) {
                return false;
            }
            WorldServer world = MinecraftServer.getServer().worldServers[0];
            LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
            if (data == null) {
                data = new LifeEssenceNetwork(ownerName);
                world.setItemData(ownerName, (WorldSavedData)data);
            }
            return data.currentEssence >= damageToBeDone;
        }
        return false;
    }

    public static void hurtPlayer(EntityPlayer user, int energySyphoned) {
        block4: {
            block3: {
                if (energySyphoned >= 100 || energySyphoned <= 0) break block3;
                if (user.capabilities.isCreativeMode) break block4;
                user.setHealth(user.getHealth() - 1.0f);
                if (user.getHealth() <= 5.0E-4f) {
                    user.onDeath(DamageSource.generic);
                }
                break block4;
            }
            if (energySyphoned >= 100 && !user.capabilities.isCreativeMode) {
                for (int i = 0; i < (energySyphoned + 99) / 100; ++i) {
                    user.setHealth(user.getHealth() - 1.0f);
                    if (!(user.getHealth() <= 5.0E-4f)) continue;
                    user.onDeath(DamageSource.generic);
                    break;
                }
            }
        }
    }

    public static boolean syphonAndDamageWhileInContainer(ItemStack ist, EntityPlayer player, int damageToBeDone) {
        if (!EnergyItems.syphonWhileInContainer(ist, damageToBeDone)) {
            EnergyItems.hurtPlayer(player, damageToBeDone);
        }
        return true;
    }

    public static boolean checkAndSetItemOwner(ItemStack item, EntityPlayer player) {
        return !SpellHelper.isFakePlayer(player) && SoulNetworkHandler.checkAndSetItemPlayer(item, player);
    }

    public static void setItemOwner(ItemStack item, String ownerName) {
        if (item.getTagCompound() == null) {
            item.setTagCompound(new NBTTagCompound());
        }
        item.getTagCompound().setString("ownerName", ownerName);
    }

    public static void checkAndSetItemOwner(ItemStack item, String ownerName) {
        if (item.getTagCompound() == null) {
            item.setTagCompound(new NBTTagCompound());
        }
        if (item.getTagCompound().getString("ownerName").equals("")) {
            item.getTagCompound().setString("ownerName", ownerName);
        }
    }

    public static String getOwnerName(ItemStack item) {
        if (item.getTagCompound() == null) {
            item.setTagCompound(new NBTTagCompound());
        }
        return item.getTagCompound().getString("ownerName");
    }

    @Deprecated
    public static void drainPlayerNetwork(EntityPlayer player, int damageToBeDone) {
        String ownerName = SpellHelper.getUsername(player);
        if (MinecraftServer.getServer() == null) {
            return;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.setItemData(ownerName, (WorldSavedData)data);
        }
        if (data.currentEssence >= damageToBeDone) {
            data.currentEssence -= damageToBeDone;
            data.markDirty();
        } else {
            EnergyItems.hurtPlayer(player, damageToBeDone);
        }
    }

    @Deprecated
    public static int getCurrentEssence(String ownerName) {
        if (MinecraftServer.getServer() == null) {
            return 0;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.setItemData(ownerName, (WorldSavedData)data);
        }
        return data.currentEssence;
    }

    @Deprecated
    public static void setCurrentEssence(String ownerName, int amount) {
        if (MinecraftServer.getServer() == null) {
            return;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.setItemData(ownerName, (WorldSavedData)data);
        }
        data.currentEssence = amount;
        data.markDirty();
    }

    @Deprecated
    public static void addEssenceToMaximum(String ownerName, int amount, int maximum) {
        if (MinecraftServer.getServer() == null) {
            return;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.setItemData(ownerName, (WorldSavedData)data);
        }
        if (data.currentEssence >= maximum) {
            return;
        }
        data.currentEssence = Math.min(maximum, data.currentEssence + amount);
        data.markDirty();
    }
}

