/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.soulNetwork.LifeEssenceNetwork;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class EnergyBattery
extends Item
implements ArmourUpgrade,
IBindable,
IBloodOrb {
    private int maxEssence;
    protected int orbLevel;

    public EnergyBattery(int damage) {
        this.setMaxStackSize(1);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.maxEssence = damage;
        this.orbLevel = 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:EnergyBattery");
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.energybattery.desc"));
        if (par1ItemStack.getTagCompound() != null) {
            par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + par1ItemStack.getTagCompound().getString("ownerName"));
        }
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer)) {
            return par1ItemStack;
        }
        World world = par3EntityPlayer.worldObj;
        if (world != null) {
            double posX = par3EntityPlayer.posX;
            double posY = par3EntityPlayer.posY;
            double posZ = par3EntityPlayer.posZ;
            world.playSoundEffect((double)((float)posX + 0.5f), (double)((float)posY + 0.5f), (double)((float)posZ + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            SpellHelper.sendIndexedParticleToAllAround(world, posX, posY, posZ, 20, world.provider.dimensionId, 4, posX, posY, posZ);
        }
        NBTTagCompound itemTag = par1ItemStack.getTagCompound();
        if (SpellHelper.isFakePlayer(par2World, par3EntityPlayer)) {
            return par1ItemStack;
        }
        if (itemTag == null || itemTag.getString("ownerName").equals("")) {
            return par1ItemStack;
        }
        if (world.isRemote) {
            return par1ItemStack;
        }
        if (itemTag.getString("ownerName").equals(SpellHelper.getUsername(par3EntityPlayer))) {
            SoulNetworkHandler.setMaxOrbToMax(itemTag.getString("ownerName"), this.orbLevel);
        }
        SoulNetworkHandler.addCurrentEssenceToMaximum(itemTag.getString("ownerName"), 200, this.getMaxEssence());
        EnergyItems.hurtPlayer(par3EntityPlayer, 200);
        return par1ItemStack;
    }

    public int damageItem(ItemStack par1ItemStack, int par2int) {
        if (par2int == 0) {
            return 0;
        }
        int before = this.getDamage(par1ItemStack);
        this.setDamage(par1ItemStack, this.getDamage(par1ItemStack) + par2int);
        return par2int - (this.getDamage(par1ItemStack) - before);
    }

    protected void damagePlayer(World world, EntityPlayer player, int damage) {
        if (world != null) {
            double posX = player.posX;
            double posY = player.posY;
            double posZ = player.posZ;
            world.playSoundEffect((double)((float)posX + 0.5f), (double)((float)posY + 0.5f), (double)((float)posZ + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            float f = 1.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = f * f * 0.7f - 0.5f;
            float f3 = f * f * 0.6f - 0.7f;
            for (int l = 0; l < 8; ++l) {
                world.spawnParticle("reddust", posX + Math.random() - Math.random(), posY + Math.random() - Math.random(), posZ + Math.random() - Math.random(), (double)f1, (double)f2, (double)f3);
            }
        }
        if (!player.capabilities.isCreativeMode) {
            for (int i = 0; i < damage; ++i) {
                player.setHealth(player.getHealth() - 1.0f);
            }
        }
        if (player.getHealth() <= 0.0f) {
            player.inventory.dropAllItems();
        }
    }

    @Override
    public int getMaxEssence() {
        return this.maxEssence;
    }

    @Override
    public int getOrbLevel() {
        return this.orbLevel;
    }

    @Override
    public void onArmourUpdate(World world, EntityPlayer player, ItemStack thisItemStack) {
    }

    @Override
    public boolean isUpgrade() {
        return false;
    }

    @Override
    public int getEnergyForTenSeconds() {
        return 0;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack;
    }

    public boolean hasContainerItem(ItemStack itemStack) {
        return true;
    }

    @Deprecated
    public int getCurrentEssence(ItemStack par1ItemStack) {
        if (par1ItemStack == null) {
            return 0;
        }
        NBTTagCompound itemTag = par1ItemStack.getTagCompound();
        if (itemTag == null || itemTag.getString("ownerName").equals("")) {
            return 0;
        }
        WorldServer worldSave = MinecraftServer.getServer().worldServers[0];
        String owner = itemTag.getString("ownerName");
        LifeEssenceNetwork data = (LifeEssenceNetwork)worldSave.loadItemData(LifeEssenceNetwork.class, owner);
        if (data == null) {
            data = new LifeEssenceNetwork(owner);
            worldSave.setItemData(owner, (WorldSavedData)data);
        }
        return data.currentEssence;
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack itemStack) {
        return false;
    }
}

