/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.api.summoningRegistry.SummoningRegistry;
import WayofTime.alchemicalWizardry.common.entity.mob.EntityDemon;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class DemonPlacer
extends Item {
    public DemonPlacer() {
        this.setHasSubtypes(true);
        this.setCreativeTab(CreativeTabs.tabMisc);
        this.maxStackSize = 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack par1ItemStack, int par2) {
        EntityList.EntityEggInfo entityegginfo = (EntityList.EntityEggInfo)EntityList.entityEggs.get(par1ItemStack.getItemDamage());
        return entityegginfo != null ? (par2 == 0 ? entityegginfo.primaryColor : entityegginfo.secondaryColor) : 0xFFFFFF;
    }

    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        String demonName;
        Entity entity;
        if (par3World.isRemote) {
            return true;
        }
        Block i1 = par3World.getBlock(par4, par5, par6);
        par4 += Facing.offsetsXForSide[par7];
        par5 += Facing.offsetsYForSide[par7];
        par6 += Facing.offsetsZForSide[par7];
        double d0 = 0.0;
        if (par7 == 1 && i1 != null && i1.getRenderType() == 11) {
            d0 = 0.5;
        }
        if ((entity = DemonPlacer.spawnCreature(par3World, demonName = DemonPlacer.getDemonString(par1ItemStack), (double)par4 + 0.5, (double)par5 + d0, (double)par6 + 0.5, par1ItemStack)) != null) {
            if (entity instanceof EntityLivingBase && par1ItemStack.hasDisplayName()) {
                ((EntityLiving)entity).setCustomNameTag(par1ItemStack.getDisplayName());
            }
            if (!par2EntityPlayer.capabilities.isCreativeMode) {
                --par1ItemStack.stackSize;
            }
        }
        return true;
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par2World.isRemote) {
            return par1ItemStack;
        }
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(par2World, par3EntityPlayer, true);
        if (movingobjectposition == null) {
            return par1ItemStack;
        }
        if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            String demonName;
            Entity entity;
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            if (!par2World.canMineBlock(par3EntityPlayer, i, j, k)) {
                return par1ItemStack;
            }
            if (!par3EntityPlayer.canPlayerEdit(i, j, k, movingobjectposition.sideHit, par1ItemStack)) {
                return par1ItemStack;
            }
            if (par2World.getBlock(i, j, k).getMaterial() == Material.water && (entity = DemonPlacer.spawnCreature(par2World, demonName = DemonPlacer.getDemonString(par1ItemStack), i, j, k, par1ItemStack)) != null) {
                if (entity instanceof EntityLivingBase && par1ItemStack.hasDisplayName()) {
                    ((EntityLiving)entity).setCustomNameTag(par1ItemStack.getDisplayName());
                }
                if (!par3EntityPlayer.capabilities.isCreativeMode) {
                    --par1ItemStack.stackSize;
                }
            }
        }
        return par1ItemStack;
    }

    public static Entity spawnCreature(World par0World, String par1, double par2, double par4, double par6, ItemStack itemStack) {
        EntityLivingBase entity = null;
        for (int j = 0; j < 1; ++j) {
            EntityPlayer owner;
            entity = SummoningRegistry.getEntityWithID(par0World, par1);
            if (entity == null || !(entity instanceof EntityLivingBase)) continue;
            EntityLiving entityliving = (EntityLiving)entity;
            entity.setLocationAndAngles(par2, par4, par6, MathHelper.wrapAngleTo180_float((float)(par0World.rand.nextFloat() * 360.0f)), 0.0f);
            entityliving.rotationYawHead = entityliving.rotationYaw;
            entityliving.renderYawOffset = entityliving.rotationYaw;
            if (entityliving instanceof EntityDemon && (owner = SpellHelper.getPlayerForUsername(DemonPlacer.getOwnerName(itemStack))) != null) {
                ((EntityDemon)entityliving).func_152115_b(owner.getPersistentID().toString());
                if (!DemonPlacer.getOwnerName(itemStack).equals("")) {
                    ((EntityDemon)entityliving).setTamed(true);
                }
            }
            par0World.spawnEntityInWorld((Entity)entity);
            entityliving.playLivingSound();
        }
        return entity;
    }

    public static void setOwnerName(ItemStack par1ItemStack, String ownerName) {
        if (par1ItemStack.getTagCompound() == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        par1ItemStack.getTagCompound().setString("ownerName", ownerName);
    }

    public static String getOwnerName(ItemStack par1ItemStack) {
        if (par1ItemStack.getTagCompound() == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        return par1ItemStack.getTagCompound().getString("ownerName");
    }

    public static void setDemonString(ItemStack itemStack, String demonName) {
        if (itemStack.getTagCompound() == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        itemStack.getTagCompound().setString("demonName", demonName);
    }

    public static String getDemonString(ItemStack itemStack) {
        if (itemStack.getTagCompound() == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        return itemStack.getTagCompound().getString("demonName");
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.demonplacer.desc"));
        if (par1ItemStack.getTagCompound() != null && !par1ItemStack.getTagCompound().getString("ownerName").equals("")) {
            par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.demonsowner") + " " + par1ItemStack.getTagCompound().getString("ownerName"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:DemonPlacer");
    }
}

