/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.common.ItemType;
import WayofTime.alchemicalWizardry.common.items.BoundPickaxe;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BoundAxe
extends ItemAxe
implements IBindable {
    public float efficiencyOnProperMaterial = 12.0f;
    public float damageVsEntity;
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;
    private int energyUsed;

    public BoundAxe() {
        super(AlchemicalWizardry.bloodBoundToolMaterial);
        this.maxStackSize = 1;
        this.efficiencyOnProperMaterial = 12.0f;
        this.damageVsEntity = 5.0f;
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.setEnergyUsed(5);
        this.setHarvestLevel("axe", 5);
    }

    public void setEnergyUsed(int i) {
        this.energyUsed = i;
    }

    public int getEnergyUsed() {
        return this.energyUsed;
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.boundaxe.desc"));
        if (par1ItemStack.getTagCompound() != null) {
            if (par1ItemStack.getTagCompound().getBoolean("isActive")) {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.sigil.state.activated"));
            } else {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.sigil.state.deactivated"));
            }
            if (!par1ItemStack.getTagCompound().getString("ownerName").equals("")) {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + par1ItemStack.getTagCompound().getString("ownerName"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:BoundAxe_activated");
        this.activeIcon = iconRegister.registerIcon("AlchemicalWizardry:BoundAxe_activated");
        this.passiveIcon = iconRegister.registerIcon("AlchemicalWizardry:SheathedItem");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tag;
        if (stack.getTagCompound() == null) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if ((tag = stack.getTagCompound()).getBoolean("isActive")) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            this.setActivated(par1ItemStack, !this.getActivated(par1ItemStack));
            par1ItemStack.getTagCompound().setInteger("worldTimeDelay", (int)(par2World.getWorldTime() - 1L) % 200);
            return par1ItemStack;
        }
        if (par2World.isRemote) {
            return par1ItemStack;
        }
        if (!this.getActivated(par1ItemStack) || SpellHelper.isFakePlayer(par2World, par3EntityPlayer)) {
            return par1ItemStack;
        }
        if (AlchemicalWizardry.disableBoundToolsRightClick) {
            return par1ItemStack;
        }
        if (par3EntityPlayer.isPotionActive(AlchemicalWizardry.customPotionInhibit)) {
            return par1ItemStack;
        }
        if (!EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, 10000)) {
            return par1ItemStack;
        }
        Vec3 blockVec = SpellHelper.getEntityBlockVector((Entity)par3EntityPlayer);
        int posX = (int)blockVec.xCoord;
        int posY = (int)blockVec.yCoord;
        int posZ = (int)blockVec.zCoord;
        boolean silkTouch = EnchantmentHelper.getSilkTouchModifier((EntityLivingBase)par3EntityPlayer);
        int fortuneLvl = EnchantmentHelper.getFortuneModifier((EntityLivingBase)par3EntityPlayer);
        HashMultiset dropMultiset = HashMultiset.create();
        for (int i = -5; i <= 5; ++i) {
            for (int j = 0; j <= 10; ++j) {
                for (int k = -5; k <= 5; ++k) {
                    float str;
                    Block block = par2World.getBlock(posX + i, posY + j, posZ + k);
                    int meta = par2World.getBlockMetadata(posX + i, posY + j, posZ + k);
                    if (block == null || !((str = this.func_150893_a(par1ItemStack, block)) > 1.1f) && (!(block instanceof BlockLeavesBase) || !par2World.canMineBlock(par3EntityPlayer, posX + i, posY + j, posZ + k))) continue;
                    if (silkTouch && block.canSilkHarvest(par2World, par3EntityPlayer, posX + i, posY + j, posZ + k, meta)) {
                        dropMultiset.add((Object)new ItemType(block, meta));
                    } else {
                        ArrayList itemDropList = block.getDrops(par2World, posX + i, posY + j, posZ + k, meta, fortuneLvl);
                        if (itemDropList != null) {
                            for (ItemStack stack : itemDropList) {
                                dropMultiset.add((Object)ItemType.fromStack(stack), stack.stackSize);
                            }
                        }
                    }
                    par2World.setBlockToAir(posX + i, posY + j, posZ + k);
                }
            }
        }
        BoundPickaxe.dropMultisetStacks((Multiset<ItemType>)dropMultiset, par2World, posX, (float)posY + par3EntityPlayer.getEyeHeight(), posZ);
        return par1ItemStack;
    }

    public void onUpdate(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.getTagCompound() == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        if (par2World.getWorldTime() % 200L == (long)par1ItemStack.getTagCompound().getInteger("worldTimeDelay") && par1ItemStack.getTagCompound().getBoolean("isActive") && !par3EntityPlayer.capabilities.isCreativeMode && !EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, 20)) {
            this.setActivated(par1ItemStack, false);
        }
        par1ItemStack.setItemDamage(0);
    }

    public void setActivated(ItemStack par1ItemStack, boolean newActivated) {
        NBTTagCompound itemTag = par1ItemStack.getTagCompound();
        if (itemTag == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        itemTag.setBoolean("isActive", newActivated);
    }

    public boolean getActivated(ItemStack par1ItemStack) {
        if (!par1ItemStack.hasTagCompound()) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound itemTag = par1ItemStack.getTagCompound();
        return itemTag.getBoolean("isActive");
    }

    public float func_150893_a(ItemStack par1ItemStack, Block par2Block) {
        if (!this.getActivated(par1ItemStack)) {
            return 0.0f;
        }
        return super.func_150893_a(par1ItemStack, par2Block);
    }

    public boolean hitEntity(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        return this.getActivated(par1ItemStack);
    }

    public boolean onBlockDestroyed(ItemStack par1ItemStack, World par2World, Block par3, int par4, int par5, int par6, EntityLivingBase par7EntityLivingBase) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return true;
    }

    public int getItemEnchantability() {
        return 30;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!this.getActivated(stack)) {
            return 0.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return this.efficiencyOnProperMaterial;
        }
        return this.func_150893_a(stack, block);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return !this.getActivated(stack);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return this.getActivated(stack) ? super.getHarvestLevel(stack, toolClass) : -1;
    }
}

