/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ExplosionProjectile
extends EnergyBlastProjectile {
    protected boolean causesEnvDamage;

    public ExplosionProjectile(World par1World) {
        super(par1World);
    }

    public ExplosionProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public ExplosionProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, boolean flag) {
        super(par1World, par2EntityPlayer, damage);
        this.causesEnvDamage = flag;
    }

    public ExplosionProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, int maxTicksInAir, double posX, double posY, double posZ, float rotationYaw, float rotationPitch, boolean flag) {
        super(par1World, par2EntityPlayer, damage, maxTicksInAir, posX, posY, posZ, rotationYaw, rotationPitch);
        this.causesEnvDamage = flag;
    }

    public ExplosionProjectile(World par1World, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase, float par4, float par5, int damage, int maxTicksInAir, boolean flag) {
        super(par1World, par2EntityLivingBase, par3EntityLivingBase, par4, par5, damage, maxTicksInAir);
        this.causesEnvDamage = flag;
    }

    @Override
    public DamageSource getDamageSource() {
        return DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity);
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit != null) {
            if (mop.entityHit == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.entityHit);
            this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 2.0f, this.causesEnvDamage);
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, 2.0f, this.causesEnvDamage);
        }
        this.setDead();
    }

    @Override
    public void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.shootingEntity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity), 1.0f);
            this.setDead();
        } else if (mop instanceof EntityLivingBase) {
            this.doDamage(this.projectileDamage, mop);
        }
        this.spawnHitParticles("magicCrit", 8);
        this.setDead();
    }

    @Override
    public void doFiringParticles() {
        this.worldObj.spawnParticle("mobSpellAmbient", this.posX + this.smallGauss(0.1), this.posY + this.smallGauss(0.1), this.posZ + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.worldObj.spawnParticle("explode", this.posX, this.posY, this.posZ, this.gaussian(this.motionX), this.gaussian(this.motionY), this.gaussian(this.motionZ));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("causesEnvDamage", this.causesEnvDamage);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.causesEnvDamage = par1NBTTagCompound.getBoolean("causesEnvDamage");
    }
}

