/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityCloudFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityParticleBeam
extends Entity
implements IProjectile,
IThrowableEntity {
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected int inTile = 0;
    protected int inData = 0;
    protected float colourRed = 0.0f;
    protected float colourGreen = 0.0f;
    protected float colourBlue = 0.0f;
    protected int xDest = 0;
    protected int yDest = 0;
    protected int zDest = 0;
    protected boolean inGround = false;
    public EntityLivingBase shootingEntity;
    protected int ticksInAir = 0;
    protected int maxTicksInAir = 600;
    private int ricochetCounter = 0;
    private boolean scheduledForDeath = false;
    protected int projectileDamage;

    public EntityParticleBeam(World par1World) {
        super(par1World);
        this.setSize(0.5f, 0.5f);
        this.maxTicksInAir = 600;
    }

    public EntityParticleBeam(World par1World, double par2, double par4, double par6) {
        super(par1World);
        this.setSize(0.5f, 0.5f);
        this.setPosition(par2, par4, par6);
        this.yOffset = 0.0f;
        this.maxTicksInAir = 600;
    }

    public EntityParticleBeam(World par1World, EntityLivingBase par2EntityPlayer, int damage) {
        super(par1World);
        this.shootingEntity = par2EntityPlayer;
        float par3 = 0.8f;
        this.setSize(0.5f, 0.5f);
        this.setLocationAndAngles(par2EntityPlayer.posX, par2EntityPlayer.posY + (double)par2EntityPlayer.getEyeHeight(), par2EntityPlayer.posZ, par2EntityPlayer.rotationYaw, par2EntityPlayer.rotationPitch);
        this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.posY -= 0.2;
        this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, par3 * 1.5f, 1.0f);
        this.projectileDamage = damage;
        this.maxTicksInAir = 600;
    }

    public EntityParticleBeam(World par1World, EntityLivingBase par2EntityPlayer, int damage, int maxTicksInAir, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        super(par1World);
        this.shootingEntity = par2EntityPlayer;
        float par3 = 0.8f;
        this.setSize(0.5f, 0.5f);
        this.setLocationAndAngles(posX, posY, posZ, rotationYaw, rotationPitch);
        this.setPosition(posX -= (double)(MathHelper.cos((float)(rotationYaw / 180.0f * (float)Math.PI)) * 0.16f), posY -= 0.2, posZ -= (double)(MathHelper.sin((float)(rotationYaw / 180.0f * (float)Math.PI)) * 0.16f));
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(rotationPitch / 180.0f * (float)Math.PI));
        this.motionZ = MathHelper.cos((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(rotationPitch / 180.0f * (float)Math.PI));
        this.motionY = -MathHelper.sin((float)(rotationPitch / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, par3 * 1.5f, 1.0f);
        this.projectileDamage = damage;
        this.maxTicksInAir = maxTicksInAir;
    }

    public EntityParticleBeam(World par1World, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase, float par4, float par5, int damage, int maxTicksInAir) {
        super(par1World);
        this.renderDistanceWeight = 10.0;
        this.shootingEntity = par2EntityLivingBase;
        this.posY = par2EntityLivingBase.posY + (double)par2EntityLivingBase.getEyeHeight() - (double)0.1f;
        double d0 = par3EntityLivingBase.posX - par2EntityLivingBase.posX;
        double d1 = par3EntityLivingBase.boundingBox.minY + (double)(par3EntityLivingBase.height / 1.5f) - this.posY;
        double d2 = par3EntityLivingBase.posZ - par2EntityLivingBase.posZ;
        double d3 = MathHelper.sqrt_double((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.setLocationAndAngles(par2EntityLivingBase.posX + d4, this.posY, par2EntityLivingBase.posZ + d5, f2, f3);
            this.yOffset = 0.0f;
            float f4 = (float)d3 * 0.2f;
            this.setThrowableHeading(d0, d1, d2, par4, par5);
        }
        this.projectileDamage = damage;
        this.maxTicksInAir = maxTicksInAir;
    }

    protected void entityInit() {
        this.dataWatcher.addObject(16, (Object)0);
    }

    public void setThrowableHeading(double var1, double var3, double var5, float var7, float var8) {
        float var9 = MathHelper.sqrt_double((double)(var1 * var1 + var3 * var3 + var5 * var5));
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        var1 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var3 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var5 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        this.motionX = var1 *= (double)var7;
        this.motionY = var3 *= (double)var7;
        this.motionZ = var5 *= (double)var7;
        float var10 = MathHelper.sqrt_double((double)(var1 * var1 + var5 * var5));
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(var1, var5) * 180.0 / Math.PI);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(var3, var10) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.setPosition(par1, par3, par5);
        this.setRotation(par7, par8);
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double par1, double par3, double par5) {
        this.motionX = par1;
        this.motionY = par3;
        this.motionZ = par5;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float var7 = MathHelper.sqrt_double((double)(par1 * par1 + par5 * par5));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(par3, var7) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch;
            this.prevRotationYaw = this.rotationYaw;
            this.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.ticksInAir > this.maxTicksInAir) {
            this.setDead();
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.setPosition(this.posX, this.posY, this.posZ);
        this.doFiringParticles();
        if (Math.pow(this.posX - (double)this.xDest, 2.0) + Math.pow(this.posY - (double)this.yDest, 2.0) + Math.pow(this.posZ - (double)this.zDest, 2.0) <= 1.0) {
            this.scheduledForDeath = true;
        }
        if (this.scheduledForDeath) {
            this.setDead();
        }
    }

    public void doFiringParticles() {
        if (!this.worldObj.isRemote) {
            return;
        }
        EntityCloudFX particle = new EntityCloudFX(this.worldObj, this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
        particle.setRBGColorF(this.colourRed + 0.15f * (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()), this.colourGreen + 0.15f * (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()), this.colourBlue + 0.15f * (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()));
        FMLClientHandler.instance().getClient().effectRenderer.addEffect((EntityFX)particle);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setShort("xTile", (short)this.xTile);
        par1NBTTagCompound.setShort("yTile", (short)this.yTile);
        par1NBTTagCompound.setShort("zTile", (short)this.zTile);
        par1NBTTagCompound.setByte("inTile", (byte)this.inTile);
        par1NBTTagCompound.setByte("inData", (byte)this.inData);
        par1NBTTagCompound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        par1NBTTagCompound.setInteger("ticksInAir", this.ticksInAir);
        par1NBTTagCompound.setInteger("maxTicksInAir", this.maxTicksInAir);
        par1NBTTagCompound.setInteger("projectileDamage", this.projectileDamage);
        par1NBTTagCompound.setFloat("colourRed", this.colourRed);
        par1NBTTagCompound.setFloat("colourGreen", this.colourGreen);
        par1NBTTagCompound.setFloat("colourBlue", this.colourBlue);
        par1NBTTagCompound.setInteger("xDest", this.xDest);
        par1NBTTagCompound.setInteger("yDest", this.yDest);
        par1NBTTagCompound.setInteger("zDest", this.zDest);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.xTile = par1NBTTagCompound.getShort("xTile");
        this.yTile = par1NBTTagCompound.getShort("yTile");
        this.zTile = par1NBTTagCompound.getShort("zTile");
        this.inTile = par1NBTTagCompound.getByte("inTile") & 0xFF;
        this.inData = par1NBTTagCompound.getByte("inData") & 0xFF;
        this.inGround = par1NBTTagCompound.getByte("inGround") == 1;
        this.ticksInAir = par1NBTTagCompound.getInteger("ticksInAir");
        this.maxTicksInAir = par1NBTTagCompound.getInteger("maxTicksInAir");
        this.projectileDamage = par1NBTTagCompound.getInteger("projectileDamage");
        this.colourRed = par1NBTTagCompound.getFloat("colourRed");
        this.colourGreen = par1NBTTagCompound.getFloat("colourGreen");
        this.colourBlue = par1NBTTagCompound.getFloat("colourBlue");
        this.xDest = par1NBTTagCompound.getInteger("xDest");
        this.yDest = par1NBTTagCompound.getInteger("yDest");
        this.zDest = par1NBTTagCompound.getInteger("zDest");
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    protected void spawnHitParticles(String string, int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.worldObj.spawnParticle(string, this.posX, this.posY - (double)(string == "portal" ? 1 : 0), this.posZ, this.gaussian(this.motionX), this.gaussian(this.motionY), this.gaussian(this.motionZ));
        }
    }

    public DamageSource getDamageSource() {
        return DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity);
    }

    public double smallGauss(double d) {
        return ((double)this.worldObj.rand.nextFloat() - 0.5) * d;
    }

    public double gaussian(double d) {
        return d + d * (((double)this.rand.nextFloat() - 0.5) / 4.0);
    }

    private int getRicochetMax() {
        return 0;
    }

    public Entity getThrower() {
        return this.shootingEntity;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.shootingEntity = (EntityLivingBase)entity;
        }
    }

    public void setColour(float red, float green, float blue) {
        this.colourRed = red;
        this.colourGreen = green;
        this.colourBlue = blue;
    }

    public void setDestination(int xDest, int yDest, int zDest) {
        this.xDest = xDest;
        this.yDest = yDest;
        this.zDest = zDest;
    }
}

