/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityMeteor
extends EnergyBlastProjectile {
    private int meteorID;
    public boolean hasTerrae;
    public boolean hasOrbisTerrae;
    public boolean hasCrystallos;
    public boolean hasIncendium;
    public boolean hasTennebrae;

    public EntityMeteor(World par1World) {
        super(par1World);
        this.meteorID = 0;
    }

    public EntityMeteor(World par1World, double par2, double par4, double par6, int meteorID) {
        super(par1World, par2, par4, par6);
        this.meteorID = meteorID;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("meteorID", this.meteorID);
        par1NBTTagCompound.setBoolean("hasTerrae", this.hasTerrae);
        par1NBTTagCompound.setBoolean("hasOrbisTerrae", this.hasOrbisTerrae);
        par1NBTTagCompound.setBoolean("hasCrystallos", this.hasCrystallos);
        par1NBTTagCompound.setBoolean("hasIncendium", this.hasIncendium);
        par1NBTTagCompound.setBoolean("hasTennebrae", this.hasTennebrae);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.meteorID = par1NBTTagCompound.getInteger("meteorID");
        this.hasTerrae = par1NBTTagCompound.getBoolean("hasTerrae");
        this.hasOrbisTerrae = par1NBTTagCompound.getBoolean("hasOrbisTerrae");
        this.hasIncendium = par1NBTTagCompound.getBoolean("hasIncendium");
        this.hasCrystallos = par1NBTTagCompound.getBoolean("hasCrystallos");
        this.hasTennebrae = par1NBTTagCompound.getBoolean("hasTennebrae");
    }

    @Override
    public DamageSource getDamageSource() {
        return DamageSource.fallingBlock;
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (this.worldObj.isRemote) {
            return;
        }
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit != null) {
            this.onImpact(mop.entityHit);
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            MeteorRegistry.createMeteorImpact(this.worldObj, mop.blockX, mop.blockY, mop.blockZ, this.meteorID, new boolean[]{this.hasTerrae, this.hasOrbisTerrae, this.hasCrystallos, this.hasIncendium, this.hasTennebrae});
        }
        this.setDead();
    }

    @Override
    public void onImpact(Entity mop) {
        MeteorRegistry.createMeteorImpact(this.worldObj, (int)this.posX, (int)this.posY, (int)this.posZ, this.meteorID, new boolean[]{this.hasTerrae, this.hasOrbisTerrae, this.hasCrystallos, this.hasIncendium, this.hasTennebrae});
        this.setDead();
    }
}

