/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityBloodLightProjectile
extends EnergyBlastProjectile {
    public EntityBloodLightProjectile(World par1World) {
        super(par1World);
    }

    public EntityBloodLightProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public EntityBloodLightProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage) {
        super(par1World, par2EntityPlayer, damage);
    }

    public EntityBloodLightProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, int maxTicksInAir, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        super(par1World, par2EntityPlayer, damage, maxTicksInAir, posX, posY, posZ, rotationYaw, rotationPitch);
    }

    public EntityBloodLightProjectile(World par1World, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase, float par4, float par5, int damage, int maxTicksInAir) {
        super(par1World, par2EntityLivingBase, par3EntityLivingBase, par4, par5, damage, maxTicksInAir);
    }

    @Override
    public DamageSource getDamageSource() {
        return DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity);
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit != null) {
            if (mop.entityHit == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.entityHit);
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            int sideHit = mop.sideHit;
            int blockX = mop.blockX;
            int blockY = mop.blockY;
            int blockZ = mop.blockZ;
            if (sideHit == 0 && this.worldObj.isAirBlock(blockX, blockY - 1, blockZ)) {
                this.worldObj.setBlock(blockX, blockY - 1, blockZ, ModBlocks.blockBloodLight);
            }
            if (sideHit == 1 && this.worldObj.isAirBlock(blockX, blockY + 1, blockZ)) {
                this.worldObj.setBlock(blockX, blockY + 1, blockZ, ModBlocks.blockBloodLight);
            }
            if (sideHit == 2 && this.worldObj.isAirBlock(blockX, blockY, blockZ - 1)) {
                this.worldObj.setBlock(blockX, blockY, blockZ - 1, ModBlocks.blockBloodLight);
            }
            if (sideHit == 3 && this.worldObj.isAirBlock(blockX, blockY, blockZ + 1)) {
                this.worldObj.setBlock(blockX, blockY, blockZ + 1, ModBlocks.blockBloodLight);
            }
            if (sideHit == 4 && this.worldObj.isAirBlock(blockX - 1, blockY, blockZ)) {
                this.worldObj.setBlock(blockX - 1, blockY, blockZ, ModBlocks.blockBloodLight);
            }
            if (sideHit == 5 && this.worldObj.isAirBlock(blockX + 1, blockY, blockZ)) {
                this.worldObj.setBlock(blockX + 1, blockY, blockZ, ModBlocks.blockBloodLight);
            }
        }
        this.setDead();
    }

    @Override
    public void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.shootingEntity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity), 1.0f);
            this.setDead();
        } else if (mop instanceof EntityLivingBase) {
            ((EntityLivingBase)mop).setRevengeTarget(this.shootingEntity);
            this.doDamage(1, mop);
        }
        if (this.worldObj.isAirBlock((int)this.posX, (int)this.posY, (int)this.posZ)) {
            this.worldObj.setBlock((int)this.posX, (int)this.posY, (int)this.posZ, (Block)Blocks.fire);
        }
        this.spawnHitParticles("magicCrit", 8);
        this.setDead();
    }
}

