/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.mob;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.entity.mob.EntityBoulderFist;
import WayofTime.alchemicalWizardry.common.entity.mob.EntityDemon;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityElemental
extends EntityDemon {
    private EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.2, false);
    private static float maxTamedHealth = 100.0f;
    private static float maxUntamedHealth = 100.0f;
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    private Entity targetedEntity;
    private int aggroCooldown;
    public int prevAttackCounter;
    public int attackCounter;

    public EntityElemental(World par1World, String entityAirElementalID) {
        super(par1World, entityAirElementalID);
        this.setSize(0.5f, 1.0f);
        this.setAggro(false);
        this.setTamed(false);
        if (par1World != null && !par1World.isRemote) {
            this.setCombatTask();
        }
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        if ((double)this.worldObj.rand.nextFloat() < 1.0 - Math.pow(0.6f, par2 + 1)) {
            this.entityDropItem(new ItemStack(ModItems.demonBloodShard, 1, 0), 0.0f);
        }
    }

    protected void fall(float par1) {
    }

    protected void updateFallState(double par1, boolean par3) {
    }

    public void moveEntityWithHeading(float par1, float par2) {
        if (this.isInWater()) {
            this.moveFlying(par1, par2, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.8f;
            this.motionY *= (double)0.8f;
            this.motionZ *= (double)0.8f;
        } else if (this.handleLavaMovement()) {
            this.moveFlying(par1, par2, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        } else {
            float f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.54600006f;
                Block i = this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.boundingBox.minY) - 1, MathHelper.floor_double((double)this.posZ));
                if (i != null) {
                    f2 = i.slipperiness * 0.91f;
                }
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            this.moveFlying(par1, par2, this.onGround ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.54600006f;
                Block j = this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.boundingBox.minY) - 1, MathHelper.floor_double((double)this.posZ));
                if (j != null) {
                    f2 = j.slipperiness * 0.91f;
                }
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)f2;
            this.motionY *= (double)f2;
            this.motionZ *= (double)f2;
        }
    }

    public boolean isOnLadder() {
        return false;
    }

    protected void updateEntityActionState() {
        if (this.getHealth() <= this.getMaxHealth() / 2.0f && this.worldObj.rand.nextInt(200) == 0) {
            this.addPotionEffect(new PotionEffect(AlchemicalWizardry.customPotionReciprocation.id, 100, 1));
        }
        this.prevAttackCounter = this.attackCounter;
        double d0 = this.waypointX - this.posX;
        double d1 = this.waypointY - this.posY;
        double d2 = this.waypointZ - this.posZ;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        if (d3 < 1.0 || d3 > 3600.0) {
            this.waypointX = this.posX + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointY = this.posY + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointZ = this.posZ + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.rand.nextInt(5) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d3 = (double)MathHelper.sqrt_double((double)d3))) {
                this.motionX += d0 / d3 * 0.1;
                this.motionY += d1 / d3 * 0.1;
                this.motionZ += d2 / d3 * 0.1;
            } else {
                this.waypointX = this.posX + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
                this.waypointY = this.posY + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
                this.waypointZ = this.posZ + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
            }
        }
        if (this.targetedEntity != null && this.targetedEntity.isDead) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null || this.aggroCooldown-- <= 0) {
            this.targetedEntity = EntityElemental.getClosestVulnerableMonsterToEntity((Entity)this, 100.0);
            if (this.targetedEntity != null) {
                this.aggroCooldown = 20;
            }
        }
        double d4 = 64.0;
        if (this.targetedEntity != null && this.targetedEntity.getDistanceSqToEntity((Entity)this) < d4 * d4) {
            double d5 = this.targetedEntity.posX - this.posX;
            double d6 = this.targetedEntity.boundingBox.minY + (double)(this.targetedEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
            double d7 = this.targetedEntity.posZ - this.posZ;
            this.renderYawOffset = this.rotationYaw = -((float)Math.atan2(d5, d7)) * 180.0f / (float)Math.PI;
            if (this.courseChangeCooldown <= 0) {
                if (this.isCourseTraversable(this.targetedEntity.posX, this.targetedEntity.posY, this.targetedEntity.posZ, Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7))) {
                    this.waypointX = this.targetedEntity.posX;
                    this.waypointY = this.targetedEntity.posY;
                    this.waypointZ = this.targetedEntity.posZ;
                    this.motionX += d5 / d3 * 0.1;
                    this.motionY += d6 / d3 * 0.1;
                    this.motionZ += d7 / d3 * 0.1;
                } else {
                    this.waypointX = this.posX + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.waypointY = this.posY + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.waypointZ = this.posZ + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.motionX += d5 / d3 * 0.1;
                    this.motionY += d6 / d3 * 0.1;
                    this.motionZ += d7 / d3 * 0.1;
                }
            }
            if (this.canEntityBeSeen(this.targetedEntity)) {
                if (Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7) < 4.0) {
                    ++this.attackCounter;
                    if (this.attackCounter >= 10) {
                        this.worldObj.playAuxSFXAtEntity(null, 1008, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
                        this.inflictEffectOnEntity(this.targetedEntity);
                        this.attackCounter = -40;
                    }
                }
            } else if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        } else {
            this.renderYawOffset = this.rotationYaw = -((float)Math.atan2(this.motionX, this.motionZ)) * 180.0f / (float)Math.PI;
            if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        }
    }

    private boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double d4 = (this.waypointX - this.posX) / par7;
        double d5 = (this.waypointY - this.posY) / par7;
        double d6 = (this.waypointZ - this.posZ) / par7;
        AxisAlignedBB axisalignedbb = this.boundingBox.copy();
        int i = 1;
        while ((double)i < par7) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.worldObj.getCollidingBoundingBoxes((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getMaxSpawnedInChunk() {
        return 1;
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setCombatTask();
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.3f);
        if (this.isTamed()) {
            this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)maxTamedHealth);
        } else {
            this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)maxUntamedHealth);
        }
    }

    public boolean isAIEnabled() {
        return false;
    }

    public void setAttackTarget(EntityLivingBase par1EntityLivingBase) {
        super.setAttackTarget(par1EntityLivingBase);
    }

    protected void updateAITick() {
        this.dataWatcher.updateObject(18, (Object)Float.valueOf(this.getHealth()));
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, (Object)Float.valueOf(this.getHealth()));
        this.dataWatcher.addObject(19, (Object)0);
    }

    protected void playStepSound(int par1, int par2, int par3, int par4) {
        this.playSound("mob.zombie.step", 0.15f, 1.0f);
    }

    protected String getLivingSound() {
        return "none";
    }

    protected String getHurtSound() {
        return "none";
    }

    protected String getDeathSound() {
        return "none";
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    public void onUpdate() {
        super.onUpdate();
    }

    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    public int getVerticalFaceSpeed() {
        return this.isSitting() ? 20 : super.getVerticalFaceSpeed();
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        Entity entity = par1DamageSource.getEntity();
        this.aiSit.setSitting(false);
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            par2 = (par2 + 1.0f) / 2.0f;
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        int i = this.isTamed() ? 6 : 7;
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)i);
    }

    public void setTamed(boolean par1) {
        super.setTamed(par1);
        if (par1) {
            this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)maxTamedHealth);
        } else {
            this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)maxUntamedHealth);
        }
    }

    public boolean isBreedingItem(ItemStack par1ItemStack) {
        return false;
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean func_142018_a(EntityLivingBase par1EntityLivingBase, EntityLivingBase par2EntityLivingBase) {
        if (!(par1EntityLivingBase instanceof EntityCreeper) && !(par1EntityLivingBase instanceof EntityGhast)) {
            EntityBoulderFist entitywolf;
            if (par1EntityLivingBase instanceof EntityBoulderFist && (entitywolf = (EntityBoulderFist)par1EntityLivingBase).isTamed() && entitywolf.getOwner() == par2EntityLivingBase) {
                return false;
            }
            return par1EntityLivingBase instanceof EntityPlayer && par2EntityLivingBase instanceof EntityPlayer && !((EntityPlayer)par2EntityLivingBase).canAttackPlayer((EntityPlayer)par1EntityLivingBase) ? false : !(par1EntityLivingBase instanceof EntityHorse) || !((EntityHorse)par1EntityLivingBase).isTame();
        }
        return false;
    }

    public void setCombatTask() {
        this.tasks.removeTask((EntityAIBase)this.aiAttackOnCollide);
        this.tasks.addTask(4, (EntityAIBase)this.aiAttackOnCollide);
    }

    public void inflictEffectOnEntity(Entity target) {
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).addPotionEffect(new PotionEffect(AlchemicalWizardry.customPotionDrowning.id, 100, 0));
        }
    }

    public static Entity getClosestVulnerableMonsterToEntity(Entity par1Entity, double par2) {
        double d4 = -1.0;
        double par1 = par1Entity.posX;
        double par3 = par1Entity.posY;
        double par5 = par1Entity.posZ;
        EntityLivingBase entityLiving = null;
        World world = par1Entity.worldObj;
        double range = Math.sqrt(par2);
        double verticalRange = Math.sqrt(par2);
        List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, AxisAlignedBB.getBoundingBox((double)(par1 - 0.5), (double)(par3 - 0.5), (double)(par5 - 0.5), (double)(par1 + 0.5), (double)(par3 + 0.5), (double)(par5 + 0.5)).expand(range, verticalRange, range));
        if (entities == null) {
            return null;
        }
        for (int i = 0; i < entities.size(); ++i) {
            EntityLivingBase entityLiving1 = (EntityLivingBase)entities.get(i);
            if (entityLiving1 instanceof EntityPlayer && ((EntityPlayer)entityLiving1).capabilities.disableDamage || !entityLiving1.isEntityAlive()) continue;
            double d5 = entityLiving1.getDistanceSq(par1, par3, par5);
            double d6 = par2;
            if (entityLiving1.isSneaking()) {
                d6 = par2 * (double)0.8f;
            }
            if (entityLiving1.isInvisible()) {
                float f;
                float f2 = f = entityLiving1 instanceof EntityPlayer ? ((EntityPlayer)entityLiving1).getArmorVisibility() : 1.0f;
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d6 *= (double)(0.7f * f);
            }
            if (!(par2 < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4) || par1Entity == entityLiving1) continue;
            d4 = d5;
            entityLiving = entityLiving1;
        }
        return entityLiving;
    }

    public int getTotalArmorValue() {
        return 10;
    }
}

