/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.mob;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.IDemon;
import WayofTime.alchemicalWizardry.common.items.DemonPlacer;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class EntityDemon
extends EntityTameable
implements IDemon {
    private boolean isAggro;
    private String demonID;
    protected boolean dropCrystal = true;

    public EntityDemon(World par1World, String demonID) {
        super(par1World);
        this.demonID = demonID;
    }

    @Override
    public boolean getDoesDropCrystal() {
        return this.dropCrystal;
    }

    @Override
    public void setDropCrystal(boolean crystal) {
        this.dropCrystal = crystal;
    }

    @Override
    public void setSummonedConditions() {
        this.setAggro(true);
    }

    @Override
    public boolean isAggro() {
        return this.isAggro;
    }

    @Override
    public void setAggro(boolean aggro) {
        this.isAggro = aggro;
    }

    public EntityAgeable createChild(EntityAgeable entityageable) {
        return null;
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setBoolean("dropCrystal", this.getDoesDropCrystal());
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.setDropCrystal(tag.getBoolean("dropCrystal"));
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (this.getDoesDropCrystal()) {
            ItemStack drop = new ItemStack(ModItems.demonPlacer);
            DemonPlacer.setDemonString(drop, this.getDemonID());
            if (this.getOwner() instanceof EntityPlayer) {
                DemonPlacer.setOwnerName(drop, SpellHelper.getUsername((EntityPlayer)this.getOwner()));
            }
            if (this.hasCustomNameTag()) {
                drop.setStackDisplayName(this.getCustomNameTag());
            }
            this.entityDropItem(drop, 0.0f);
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.isAggro() && this.worldObj.getWorldTime() % 100L == 0L) {
            this.heal(1.0f);
        }
    }

    public void sendSittingMessageToPlayer(EntityPlayer owner, boolean isSitting) {
        if (owner != null && owner.worldObj.isRemote) {
            ChatComponentTranslation chatmessagecomponent = isSitting ? new ChatComponentTranslation("message.demon.willstay", new Object[0]) : new ChatComponentTranslation("message.demon.shallfollow", new Object[0]);
            owner.addChatComponentMessage((IChatComponent)chatmessagecomponent);
        }
    }

    public String getDemonID() {
        return this.demonID;
    }

    protected void setDemonID(String id) {
        this.demonID = id;
    }
}

