/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.demonVillage.tileEntity;

import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.ITilePortalNode;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.TEDemonPortal;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;

public class TEDemonChest
extends TileEntityChest
implements ITilePortalNode {
    public Int3 portalLocation = new Int3(0, 0, 0);

    public String getInventoryName() {
        return "Demon's Chest";
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        NBTTagCompound portalTag = tag.getCompoundTag("portalLocation");
        this.portalLocation = Int3.readFromNBT(portalTag);
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagCompound portalTag = this.portalLocation.writeToNBT(new NBTTagCompound());
        tag.setTag("portalLocation", (NBTBase)portalTag);
    }

    public void openInventory() {
        super.openInventory();
        this.notifyPortalOfInteraction();
    }

    public void checkForAdjacentChests() {
    }

    @Override
    public void setPortalLocation(TEDemonPortal teDemonPortal) {
        if (teDemonPortal != null) {
            this.portalLocation = new Int3(teDemonPortal.xCoord, teDemonPortal.yCoord, teDemonPortal.zCoord);
        }
    }

    public TEDemonPortal getDemonPortal() {
        TileEntity tile = this.worldObj.getTileEntity(this.portalLocation.xCoord, this.portalLocation.yCoord, this.portalLocation.zCoord);
        if (tile instanceof TEDemonPortal) {
            return (TEDemonPortal)tile;
        }
        return null;
    }

    public void notifyPortalOfInteraction() {
        TEDemonPortal portal = this.getDemonPortal();
        if (portal == null) {
            return;
        }
        portal.notifyDemons(this.xCoord, this.yCoord, this.zCoord, 50.0);
    }
}

