/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.demonVillage.demonHoard.demon;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.LocalRitualStorage;
import WayofTime.alchemicalWizardry.common.EntityAITargetAggroCloaking;
import WayofTime.alchemicalWizardry.common.demonVillage.ai.EntityAIOccasionalRangedAttack;
import WayofTime.alchemicalWizardry.common.demonVillage.ai.EntityDemonAIHurtByTarget;
import WayofTime.alchemicalWizardry.common.demonVillage.ai.IOccasionalRangedAttackMob;
import WayofTime.alchemicalWizardry.common.demonVillage.demonHoard.demon.IHoardDemon;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.TEDemonPortal;
import WayofTime.alchemicalWizardry.common.entity.mob.EntityDemon;
import WayofTime.alchemicalWizardry.common.entity.projectile.HolyProjectile;
import WayofTime.alchemicalWizardry.common.rituals.LocalStorageAlphaPact;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityMinorDemonGrunt
extends EntityDemon
implements IOccasionalRangedAttackMob,
IHoardDemon {
    private EntityAIOccasionalRangedAttack aiArrowAttack = new EntityAIOccasionalRangedAttack(this, 1.0, 40, 40, 15.0f, 5.0);
    private EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.2, false);
    private boolean isAngry = true;
    private Int3 demonPortal;
    private static float maxTamedHealth = 200.0f;
    private static float maxUntamedHealth = 200.0f;
    private boolean enthralled = false;

    public EntityMinorDemonGrunt(World par1World) {
        super(par1World, AlchemicalWizardry.entityMinorDemonGruntID);
        this.setSize(0.7f, 1.8f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)this.aiSit);
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityDemonAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(4, (EntityAIBase)new EntityAITargetAggroCloaking(this, EntityPlayer.class, 0, false, 0));
        this.setAggro(false);
        this.setTamed(false);
        this.demonPortal = new Int3(0, 0, 0);
        if (par1World != null && !par1World.isRemote) {
            this.setCombatTask();
        }
    }

    public boolean isTameable() {
        return false;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.3f);
        if (this.isTamed()) {
            this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)maxTamedHealth);
        } else {
            this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)maxUntamedHealth);
        }
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        if (!this.getDoesDropCrystal()) {
            ItemStack lifeShardStack = new ItemStack(ModItems.baseItems, 1, 28);
            ItemStack soulShardStack = new ItemStack(ModItems.baseItems, 1, 29);
            int dropAmount = 0;
            for (int i = 0; i <= par2; ++i) {
                dropAmount += this.worldObj.rand.nextFloat() < 0.6f ? 1 : 0;
            }
            ItemStack drop = this.worldObj.rand.nextBoolean() ? lifeShardStack : soulShardStack;
            drop.stackSize = dropAmount;
            if (dropAmount > 0) {
                this.entityDropItem(drop, 0.0f);
            }
        } else {
            super.dropFewItems(par1, par2);
        }
    }

    @Override
    public void setPortalLocation(Int3 position) {
        this.demonPortal = position;
    }

    @Override
    public Int3 getPortalLocation() {
        return this.demonPortal;
    }

    public boolean isAIEnabled() {
        return true;
    }

    public void setAttackTarget(EntityLivingBase par1EntityLivingBase) {
        super.setAttackTarget(par1EntityLivingBase);
        if (par1EntityLivingBase == null) {
            this.setAngry(false);
        } else if (!this.isTamed()) {
            this.setAngry(true);
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("Angry", this.isAngry());
        this.demonPortal.writeToNBT(par1NBTTagCompound);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setAngry(par1NBTTagCompound.getBoolean("Angry"));
        this.demonPortal = Int3.readFromNBT(par1NBTTagCompound);
        this.setCombatTask();
    }

    protected String getLivingSound() {
        return "none";
    }

    protected String getHurtSound() {
        return "none";
    }

    protected String getDeathSound() {
        return "mob.wolf.death";
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    public void onUpdate() {
        if (!this.enthralled) {
            IMasterRitualStone stone;
            LocalRitualStorage stor;
            TileEntity tile = this.worldObj.getTileEntity(this.demonPortal.xCoord, this.demonPortal.yCoord, this.demonPortal.zCoord);
            if (tile instanceof TEDemonPortal) {
                ((TEDemonPortal)tile).enthrallDemon((EntityLivingBase)this);
                this.enthralled = true;
            } else if (tile instanceof IMasterRitualStone && (stor = (stone = (IMasterRitualStone)tile).getLocalStorage()) instanceof LocalStorageAlphaPact) {
                LocalStorageAlphaPact storage = (LocalStorageAlphaPact)stor;
                storage.thrallDemon(this);
            }
        }
        super.onUpdate();
    }

    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    public int getVerticalFaceSpeed() {
        return this.isSitting() ? 20 : super.getVerticalFaceSpeed();
    }

    public void setTamed(boolean par1) {
        super.setTamed(par1);
        if (par1) {
            this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)maxTamedHealth);
        } else {
            this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)maxUntamedHealth);
        }
    }

    public boolean interact(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
        if (this.isTamed()) {
            ItemFood itemfood;
            if (itemstack != null && itemstack.getItem() instanceof ItemFood && (itemfood = (ItemFood)itemstack.getItem()).isWolfsFavoriteMeat() && this.dataWatcher.getWatchableObjectFloat(18) < maxTamedHealth) {
                if (!par1EntityPlayer.capabilities.isCreativeMode) {
                    --itemstack.stackSize;
                }
                this.heal(itemfood.func_150905_g(itemstack));
                if (itemstack.stackSize <= 0) {
                    par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, null);
                }
                return true;
            }
            if (this.getOwner() instanceof EntityPlayer && SpellHelper.getUsername(par1EntityPlayer).equalsIgnoreCase(SpellHelper.getUsername((EntityPlayer)this.getOwner())) && !this.isBreedingItem(itemstack)) {
                if (!this.worldObj.isRemote) {
                    this.aiSit.setSitting(!this.isSitting());
                    this.isJumping = false;
                    this.setPathToEntity(null);
                    this.setTarget(null);
                    this.setAttackTarget(null);
                }
                this.sendSittingMessageToPlayer(par1EntityPlayer, !this.isSitting());
            }
        } else if (this.isTameable() && itemstack != null && itemstack.getItem().equals(ModItems.weakBloodOrb) && !this.isAngry()) {
            if (!par1EntityPlayer.capabilities.isCreativeMode) {
                --itemstack.stackSize;
            }
            if (itemstack.stackSize <= 0) {
                par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, null);
            }
            if (!this.worldObj.isRemote) {
                if (this.rand.nextInt(1) == 0) {
                    this.setTamed(true);
                    this.setPathToEntity(null);
                    this.setAttackTarget(null);
                    this.aiSit.setSitting(true);
                    this.setHealth(maxTamedHealth);
                    this.func_152115_b(par1EntityPlayer.getUniqueID().toString());
                    this.playTameEffect(true);
                    this.worldObj.setEntityState((Entity)this, (byte)7);
                } else {
                    this.playTameEffect(false);
                    this.worldObj.setEntityState((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.interact(par1EntityPlayer);
    }

    public boolean isBreedingItem(ItemStack par1ItemStack) {
        return false;
    }

    public boolean isAngry() {
        return this.isAngry;
    }

    public void setAngry(boolean angry) {
        this.isAngry = angry;
    }

    public boolean canMateWith(EntityAnimal par1EntityAnimal) {
        return false;
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean func_142018_a(EntityLivingBase par1EntityLivingBase, EntityLivingBase par2EntityLivingBase) {
        if (!(par1EntityLivingBase instanceof EntityCreeper) && !(par1EntityLivingBase instanceof EntityGhast)) {
            EntityDemon entitywolf;
            if (par1EntityLivingBase instanceof EntityDemon && (entitywolf = (EntityDemon)par1EntityLivingBase).isTamed() && entitywolf.getOwner() == par2EntityLivingBase) {
                return false;
            }
            return par1EntityLivingBase instanceof EntityPlayer && par2EntityLivingBase instanceof EntityPlayer && !((EntityPlayer)par2EntityLivingBase).canAttackPlayer((EntityPlayer)par1EntityLivingBase) ? false : !(par1EntityLivingBase instanceof EntityHorse) || !((EntityHorse)par1EntityLivingBase).isTame();
        }
        return false;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        int i;
        int n = i = this.isTamed() ? 20 : 20;
        if (par1Entity instanceof IHoardDemon && ((IHoardDemon)par1Entity).isSamePortal(this)) {
            return false;
        }
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)i);
    }

    public void attackEntityWithRangedAttack(EntityLivingBase par1EntityLivingBase, float par2) {
        if (par1EntityLivingBase instanceof IHoardDemon && ((IHoardDemon)par1EntityLivingBase).isSamePortal(this)) {
            return;
        }
        HolyProjectile hol = new HolyProjectile(this.worldObj, (EntityLivingBase)this, par1EntityLivingBase, 1.8f, 0.0f, 15, 600);
        this.worldObj.spawnEntityInWorld((Entity)hol);
    }

    public void setCombatTask() {
        this.tasks.removeTask((EntityAIBase)this.aiAttackOnCollide);
        this.tasks.removeTask((EntityAIBase)this.aiArrowAttack);
        this.tasks.addTask(4, (EntityAIBase)this.aiArrowAttack);
        this.tasks.addTask(5, (EntityAIBase)this.aiAttackOnCollide);
    }

    @Override
    public boolean shouldUseRangedAttack() {
        return true;
    }

    @Override
    public boolean thrallDemon(Int3 location) {
        this.setPortalLocation(location);
        return true;
    }

    @Override
    public boolean isSamePortal(IHoardDemon demon) {
        Int3 position = demon.getPortalLocation();
        TileEntity portal = this.worldObj.getTileEntity(this.demonPortal.xCoord, this.demonPortal.yCoord, this.demonPortal.zCoord);
        return portal instanceof TEDemonPortal ? portal == this.worldObj.getTileEntity(position.xCoord, position.yCoord, position.zCoord) : false;
    }
}

