/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.demonVillage.ai;

import WayofTime.alchemicalWizardry.common.demonVillage.ai.IOccasionalRangedAttackMob;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;

public class EntityAIOccasionalRangedAttack
extends EntityAIBase {
    private final EntityLiving entityHost;
    private final IOccasionalRangedAttackMob rangedAttackEntityHost;
    private EntityLivingBase attackTarget;
    private int rangedAttackTime = -1;
    private double entityMoveSpeed;
    private int field_75318_f;
    private int field_96561_g;
    private int maxRangedAttackTime;
    private float field_96562_i;
    private float field_82642_h;
    private static final String __OBFID = "CL_00001609";
    private double range;

    public EntityAIOccasionalRangedAttack(IOccasionalRangedAttackMob p_i1649_1_, double p_i1649_2_, int p_i1649_4_, float p_i1649_5_, double range) {
        this(p_i1649_1_, p_i1649_2_, p_i1649_4_, p_i1649_4_, p_i1649_5_, range);
    }

    public EntityAIOccasionalRangedAttack(IOccasionalRangedAttackMob p_i1650_1_, double p_i1650_2_, int p_i1650_4_, int p_i1650_5_, float p_i1650_6_, double range) {
        if (!(p_i1650_1_ instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = p_i1650_1_;
        this.entityHost = (EntityLiving)p_i1650_1_;
        this.entityMoveSpeed = p_i1650_2_;
        this.field_96561_g = p_i1650_4_;
        this.maxRangedAttackTime = p_i1650_5_;
        this.field_96562_i = p_i1650_6_;
        this.field_82642_h = p_i1650_6_ * p_i1650_6_;
        this.setMutexBits(3);
        this.range = range;
    }

    public boolean shouldExecute() {
        EntityLivingBase entitylivingbase = this.entityHost.getAttackTarget();
        if (entitylivingbase == null) {
            return false;
        }
        if (this.rangedAttackEntityHost.shouldUseRangedAttack() && this.isInRange(entitylivingbase)) {
            this.attackTarget = entitylivingbase;
            return true;
        }
        return false;
    }

    public boolean continueExecuting() {
        return this.shouldExecute() || !this.entityHost.getNavigator().noPath() && this.rangedAttackEntityHost.shouldUseRangedAttack();
    }

    public boolean isInRange(EntityLivingBase target) {
        double xi = this.entityHost.posX;
        double xf = target.posX;
        double yi = this.entityHost.posY;
        double yf = target.posY;
        double zi = this.entityHost.posZ;
        double zf = target.posZ;
        return (xi - xf) * (xi - xf) + (yi - yf) * (yi - yf) + (zi - zf) * (zi - zf) >= this.range * this.range;
    }

    public void resetTask() {
        this.attackTarget = null;
        this.field_75318_f = 0;
        this.rangedAttackTime = -1;
    }

    public void updateTask() {
        double d0 = this.entityHost.getDistanceSq(this.attackTarget.posX, this.attackTarget.boundingBox.minY, this.attackTarget.posZ);
        boolean flag = this.entityHost.getEntitySenses().canSee((Entity)this.attackTarget);
        this.field_75318_f = flag ? ++this.field_75318_f : 0;
        if (d0 <= (double)this.field_82642_h && this.field_75318_f >= 20) {
            this.entityHost.getNavigator().clearPathEntity();
        } else {
            this.entityHost.getNavigator().tryMoveToEntityLiving((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.getLookHelper().setLookPositionWithEntity((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            float f;
            if (d0 > (double)this.field_82642_h || !flag) {
                return;
            }
            float f1 = f = MathHelper.sqrt_double((double)d0) / this.field_96562_i;
            if (f < 0.1f) {
                f1 = 0.1f;
            }
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.rangedAttackEntityHost.attackEntityWithRangedAttack(this.attackTarget, f1);
            this.rangedAttackTime = MathHelper.floor_float((float)(f * (float)(this.maxRangedAttackTime - this.field_96561_g) + (float)this.field_96561_g));
        } else if (this.rangedAttackTime < 0) {
            float f = MathHelper.sqrt_double((double)d0) / this.field_96562_i;
            this.rangedAttackTime = MathHelper.floor_float((float)(f * (float)(this.maxRangedAttackTime - this.field_96561_g) + (float)this.field_96561_g));
        }
    }
}

