/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.compress;

import WayofTime.alchemicalWizardry.api.compress.CompressionHandler;
import WayofTime.alchemicalWizardry.api.compress.CompressionRegistry;
import WayofTime.alchemicalWizardry.common.compress.StorageBlockCraftingManager;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AdvancedCompressionHandler
extends CompressionHandler {
    @Override
    public ItemStack compressInventory(ItemStack[] inv, World world) {
        return this.test(inv, true, world);
    }

    public ItemStack test(ItemStack[] inv, boolean doDrain, World world) {
        for (ItemStack invStack : inv) {
            if (invStack == null) continue;
            for (int i = 2; i <= 3; ++i) {
                ItemStack stacky = AdvancedCompressionHandler.getRecipe(invStack, world, i);
                if (stacky == null) continue;
                int threshold = CompressionRegistry.getItemThreshold(invStack);
                int needed = i * i;
                int neededLeft = this.iterateThroughInventory(invStack, threshold + invStack.getMaxStackSize() - needed, inv, needed, false);
                if (neededLeft > 0) continue;
                this.iterateThroughInventory(invStack, 0, inv, needed, true);
                return stacky;
            }
        }
        return null;
    }

    public int iterateThroughInventory(ItemStack required, int kept, ItemStack[] inv, int needed, boolean doDrain) {
        int i = -1;
        for (ItemStack invStack : inv) {
            int remainingFromStack;
            ++i;
            if (invStack == null || !invStack.isItemEqual(required) || !(invStack.getTagCompound() == null ? required.getTagCompound() == null : invStack.getTagCompound().equals((Object)required.getTagCompound()))) continue;
            int stackSize = invStack.stackSize;
            int used = 0;
            if (kept > 0) {
                remainingFromStack = Math.max(stackSize - kept, 0);
                used += stackSize - remainingFromStack;
            }
            if ((kept -= used) <= 0 && needed > 0) {
                remainingFromStack = Math.max(stackSize - used - needed, 0);
                if (doDrain) {
                    invStack.stackSize = remainingFromStack + used;
                    if (invStack.stackSize <= 0) {
                        inv[i] = null;
                    }
                }
                needed -= stackSize - used - remainingFromStack;
            }
            if (needed > 0) continue;
            return 0;
        }
        return needed;
    }

    public static boolean isResultStackReversible(ItemStack stack, int gridSize, World world) {
        if (stack == null) {
            return false;
        }
        InventoryCrafting inventory = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer player) {
                return false;
            }
        }, 2, 2);
        inventory.setInventorySlotContents(0, stack);
        ItemStack returnStack = StorageBlockCraftingManager.getInstance().findMatchingRecipe(inventory, world);
        if (returnStack == null) {
            return false;
        }
        ItemStack compressedStack = null;
        switch (gridSize) {
            case 2: {
                compressedStack = AdvancedCompressionHandler.get22Recipe(returnStack, world);
                break;
            }
            case 3: {
                compressedStack = AdvancedCompressionHandler.get33Recipe(returnStack, world);
            }
        }
        if (compressedStack == null) {
            return false;
        }
        return SpellHelper.areItemStacksEqual(stack, compressedStack);
    }

    public static ItemStack getRecipe(ItemStack stack, World world, int gridSize) {
        InventoryCrafting inventory = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer player) {
                return false;
            }
        }, gridSize, gridSize);
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            inventory.setInventorySlotContents(i, stack);
        }
        return StorageBlockCraftingManager.getInstance().findMatchingRecipe(inventory, world);
    }

    public static boolean has22Recipe(ItemStack stack, World world) {
        return AdvancedCompressionHandler.get22Recipe(stack, world) != null;
    }

    public static ItemStack get22Recipe(ItemStack stack, World world) {
        return AdvancedCompressionHandler.getRecipe(stack, world, 2);
    }

    public static boolean has33Recipe(ItemStack stack, World world) {
        return AdvancedCompressionHandler.get33Recipe(stack, world) != null;
    }

    public static ItemStack get33Recipe(ItemStack stack, World world) {
        return AdvancedCompressionHandler.getRecipe(stack, world, 3);
    }
}

