/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.block;

import WayofTime.alchemicalWizardry.common.tileEntity.TEMimicBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MimicBlock
extends BlockContainer {
    public MimicBlock() {
        super(Material.water);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setBlockName("blockMimic");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity TE = world.getTileEntity(x, y, z);
        if (!(TE instanceof TEMimicBlock)) {
            return true;
        }
        TEMimicBlock mimic = (TEMimicBlock)TE;
        Block block = mimic.getBlock();
        return block == null || block.shouldSideBeRendered(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderBlockPass() {
        return 1;
    }

    public boolean canCollideCheck(int meta, boolean bool) {
        return meta == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity TE = blockAccess.getTileEntity(x, y, z);
        TEMimicBlock mimic = (TEMimicBlock)TE;
        Block block = mimic.getBlock();
        int meta = mimic.getMetaOfMimic();
        return block != null ? block.getIcon(side, meta) : this.blockIcon;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TEMimicBlock();
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    public boolean isBlockSolid(IBlockAccess world, int x, int y, int z, int meta) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TEMimicBlock) {
            Block block = ((TEMimicBlock)tile).getBlock();
            int mimicMeta = ((TEMimicBlock)tile).getMetaOfMimic();
            if (block != null) {
                return block.isBlockSolid(world, x, y, z, mimicMeta);
            }
        }
        return super.isBlockSolid(world, x, y, z, meta);
    }

    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TileEntity tile = world.getTileEntity(target.blockX, target.blockY, target.blockZ);
        TEMimicBlock TE = (TEMimicBlock)tile;
        if (TE != null) {
            Block block = TE.getBlock();
            double xOffset = (double)target.blockX + world.rand.nextDouble() * (block.getBlockBoundsMaxX() - block.getBlockBoundsMinX() - (double)0.2f) + (double)0.1f + block.getBlockBoundsMinX();
            double yOffset = (double)target.blockY + world.rand.nextDouble() * (block.getBlockBoundsMaxY() - block.getBlockBoundsMinY() - (double)0.2f) + (double)0.1f + block.getBlockBoundsMinY();
            double zOffset = (double)target.blockZ + world.rand.nextDouble() * (block.getBlockBoundsMaxZ() - block.getBlockBoundsMinZ() - (double)0.2f) + (double)0.1f + block.getBlockBoundsMinZ();
            switch (target.sideHit) {
                case 0: {
                    yOffset = (double)target.blockY + block.getBlockBoundsMinY() - 0.1;
                    break;
                }
                case 1: {
                    yOffset = (double)target.blockY + block.getBlockBoundsMaxY() + 0.1;
                    break;
                }
                case 2: {
                    zOffset = (double)target.blockZ + block.getBlockBoundsMinZ() - 0.1;
                    break;
                }
                case 3: {
                    zOffset = (double)target.blockZ + block.getBlockBoundsMaxZ() + 0.1;
                    break;
                }
                case 4: {
                    xOffset = (double)target.blockX + block.getBlockBoundsMinX() - 0.1;
                    break;
                }
                case 5: {
                    xOffset = (double)target.blockX + block.getBlockBoundsMaxX() + 0.1;
                }
            }
            MimicBlock.addHitEffect(TE, target, xOffset, yOffset, zOffset, null, effectRenderer);
            return true;
        }
        return super.addHitEffects(world, target, effectRenderer);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        TEMimicBlock tile = (TEMimicBlock)world.getTileEntity(x, y, z);
        Block block = tile.getBlock();
        return block != null ? block.getCollisionBoundingBoxFromPool(world, x, y, z) : super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess blockAccess, int x, int y, int z) {
        Block block;
        TEMimicBlock TE = (TEMimicBlock)blockAccess.getTileEntity(x, y, z);
        if (TE != null && (block = TE.getBlock()) != null) {
            return block.colorMultiplier(blockAccess, x, y, z);
        }
        return super.colorMultiplier(blockAccess, x, y, z);
    }

    public void velocityToAddToEntity(World world, int x, int y, int z, Entity entity, Vec3 vec) {
        Block block;
        TEMimicBlock TE = (TEMimicBlock)world.getTileEntity(x, y, z);
        if (TE != null && (block = TE.getBlock()) != null) {
            block.velocityToAddToEntity(world, x, y, z, entity, vec);
        }
    }

    public static void addHitEffect(TEMimicBlock TE, MovingObjectPosition target, double x, double y, double z, ItemStack itemStack, EffectRenderer effectRenderer) {
        EntityDiggingFX particle = new EntityDiggingFX(TE.getWorldObj(), x, y, z, 0.0, 0.0, 0.0, TE.getBlock(), TE.getMetaOfMimic());
        effectRenderer.addEffect(particle.applyColourMultiplier(target.blockX, target.blockY, target.blockZ).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f));
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        TEMimicBlock TE = (TEMimicBlock)world.getTileEntity(x, y, z);
        if (TE != null) {
            if (TE.getBlockEffectWhileInside(entity, x, y, z)) {
                return;
            }
            Block block = TE.getBlock();
            if (block != null) {
                block.onEntityCollidedWithBlock(world, x, y, z, entity);
                return;
            }
        }
        super.onEntityCollidedWithBlock(world, x, y, z, entity);
    }
}

