/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.block;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.items.ActivationCrystal;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockMasterStone
extends BlockContainer {
    public BlockMasterStone() {
        super(Material.iron);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.setBlockName("blockMasterStone");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("AlchemicalWizardry:MasterStone");
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer player) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TEMasterStone) {
            ((TEMasterStone)tile).useOnRitualBroken();
        }
        super.onBlockHarvested(world, x, y, z, meta, player);
    }

    public void onBlockDestroyedByExplosion(World world, int x, int y, int z, Explosion explosion) {
        super.onBlockDestroyedByExplosion(world, x, y, z, explosion);
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TEMasterStone) {
            ((TEMasterStone)tile).useOnRitualBrokenExplosion();
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int idk, float what, float these, float are) {
        TEMasterStone tileEntity = (TEMasterStone)world.getTileEntity(x, y, z);
        if (tileEntity == null || player.isSneaking()) {
            return false;
        }
        ItemStack playerItem = player.getCurrentEquippedItem();
        if (playerItem == null) {
            return false;
        }
        Item item = playerItem.getItem();
        if (!(item instanceof ActivationCrystal)) {
            return false;
        }
        ActivationCrystal acItem = (ActivationCrystal)item;
        tileEntity.activateRitual(world, acItem.getCrystalLevel(playerItem), playerItem, player, ActivationCrystal.getOwnerName(playerItem));
        world.markBlockForUpdate(x, y, z);
        return true;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TEMasterStone();
    }
}

