/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.block;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.items.IAltarManipulator;
import WayofTime.alchemicalWizardry.common.items.EnergyBattery;
import WayofTime.alchemicalWizardry.common.items.sigil.holding.SigilOfHolding;
import WayofTime.alchemicalWizardry.common.tileEntity.TEAltar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockAltar
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon2;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottomIcon;

    public BlockAltar() {
        super(Material.rock);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.setBlockName("bloodAltar");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.topIcon = iconRegister.registerIcon("AlchemicalWizardry:BloodAltar_Top");
        this.sideIcon2 = iconRegister.registerIcon("AlchemicalWizardry:BloodAltar_SideType2");
        this.bottomIcon = iconRegister.registerIcon("AlchemicalWizardry:BloodAltar_Bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        switch (side) {
            case 0: {
                return this.bottomIcon;
            }
            case 1: {
                return this.topIcon;
            }
        }
        return this.sideIcon2;
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int meta) {
        ItemStack stack;
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TEAltar && (stack = ((TEAltar)tile).getStackInSlot(0)) != null && stack.getItem() instanceof EnergyBattery) {
            EnergyBattery bloodOrb = (EnergyBattery)stack.getItem();
            int maxEssence = bloodOrb.getMaxEssence();
            int currentEssence = bloodOrb.getCurrentEssence(stack);
            int level = currentEssence * 15 / maxEssence;
            return Math.min(15, level) % 16;
        }
        return 0;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int idk, float what, float these, float are) {
        TEAltar tileEntity = (TEAltar)world.getTileEntity(x, y, z);
        if (tileEntity == null || player.isSneaking()) {
            return false;
        }
        ItemStack playerItem = player.getCurrentEquippedItem();
        if (playerItem != null) {
            if (playerItem.getItem().equals(ModItems.divinationSigil)) {
                if (player.worldObj.isRemote) {
                    world.markBlockForUpdate(x, y, z);
                } else {
                    tileEntity.sendChatInfoToPlayer(player);
                }
                return true;
            }
            if (playerItem.getItem().equals(ModItems.itemSeerSigil)) {
                if (player.worldObj.isRemote) {
                    world.markBlockForUpdate(x, y, z);
                } else {
                    tileEntity.sendMoreChatInfoToPlayer(player);
                }
                return true;
            }
            if (playerItem.getItem() instanceof IAltarManipulator) {
                return false;
            }
            if (playerItem.getItem().equals(ModItems.sigilOfHolding)) {
                ItemStack item = SigilOfHolding.getCurrentSigil(playerItem);
                if (item != null && item.getItem().equals(ModItems.divinationSigil)) {
                    if (player.worldObj.isRemote) {
                        world.markBlockForUpdate(x, y, z);
                    } else {
                        tileEntity.sendChatInfoToPlayer(player);
                    }
                    return true;
                }
                if (item != null && item.getItem().equals(ModItems.itemSeerSigil)) {
                    if (player.worldObj.isRemote) {
                        world.markBlockForUpdate(x, y, z);
                    } else {
                        tileEntity.sendMoreChatInfoToPlayer(player);
                    }
                    return true;
                }
            }
        }
        if (tileEntity.getStackInSlot(0) == null && playerItem != null) {
            ItemStack newItem = playerItem.copy();
            newItem.stackSize = 1;
            --playerItem.stackSize;
            tileEntity.setInventorySlotContents(0, newItem);
            tileEntity.startCycle();
        } else if (tileEntity.getStackInSlot(0) != null && playerItem == null) {
            player.inventory.addItemStackToInventory(tileEntity.getStackInSlot(0));
            tileEntity.setInventorySlotContents(0, null);
            tileEntity.setActive();
        }
        world.markBlockForUpdate(x, y, z);
        return true;
    }

    public void breakBlock(World world, int x, int y, int z, Block par5, int par6) {
        this.dropItems(world, x, y, z);
        super.breakBlock(world, x, y, z, par5, par6);
    }

    private void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            if (item == null || item.stackSize <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.getItem(), item.stackSize, item.getItemDamage()));
            if (item.hasTagCompound()) {
                entityItem.getEntityItem().setTagCompound((NBTTagCompound)item.getTagCompound().copy());
            }
            float factor = 0.05f;
            entityItem.motionX = rand.nextGaussian() * (double)factor;
            entityItem.motionY = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.motionZ = rand.nextGaussian() * (double)factor;
            world.spawnEntityInWorld((Entity)entityItem);
            item.stackSize = 0;
        }
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return -1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean hasTileEntity() {
        return true;
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        TEAltar tileEntity = (TEAltar)world.getTileEntity(x, y, z);
        if (!tileEntity.isActive()) {
            return;
        }
        if (rand.nextInt(3) != 0) {
            return;
        }
    }

    public TileEntity createNewTileEntity(World var1, int var2) {
        return new TEAltar();
    }
}

