/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.BloodMagicConfiguration;
import WayofTime.alchemicalWizardry.api.BlockStack;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.event.TeleposeEvent;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.common.CoordAndRange;
import WayofTime.alchemicalWizardry.common.IDemon;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.achievements.ModAchievements;
import WayofTime.alchemicalWizardry.common.demonVillage.demonHoard.demon.IHoardDemon;
import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergySword;
import WayofTime.alchemicalWizardry.common.items.armour.BoundArmour;
import WayofTime.alchemicalWizardry.common.items.armour.OmegaArmour;
import WayofTime.alchemicalWizardry.common.omega.OmegaParadigm;
import WayofTime.alchemicalWizardry.common.omega.OmegaRegistry;
import WayofTime.alchemicalWizardry.common.omega.ReagentRegenConfiguration;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import vazkii.botania.api.internal.IManaBurst;

public class AlchemicalWizardryEventHooks {
    public static Map<String, Boolean> playerFlightBuff = new HashMap<String, Boolean>();
    public static List<String> playersWith1Step = new ArrayList<String>();
    public static Map<Integer, List<CoordAndRange>> respawnMap = new HashMap<Integer, List<CoordAndRange>>();
    public static Map<Integer, List<CoordAndRange>> forceSpawnMap = new HashMap<Integer, List<CoordAndRange>>();
    public static ArrayList<BlockStack> teleposerBlacklist = new ArrayList();
    public static Random rand = new Random();

    @SubscribeEvent
    public void onEntityInteractEvent(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        OmegaParadigm parad = OmegaRegistry.getOmegaParadigmOfWeilder(player);
        if (parad == null) {
            return;
        }
        ItemStack heldItem = player.getHeldItem();
        if (heldItem == null) {
            parad.onEmptyHandEntityInteract(player, event.target);
        } else if (heldItem.getItem() instanceof EnergySword) {
            parad.onBoundSwordInteractWithEntity(player, event.target);
        }
    }

    @SubscribeEvent
    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        if (event.isCancelable() && event.left != null && event.right != null && (event.left.getItem() instanceof BoundArmour || event.right.getItem() instanceof BoundArmour)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!event.isCanceled() && event.entityLiving instanceof EntityPlayer && !event.entityLiving.worldObj.isRemote) {
            float prevHp;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (APISpellHelper.getCurrentAdditionalMaxHP(player) > 0.0f) {
                APISpellHelper.setPlayerReagentRegenCooldownTag(player, 400);
            }
            if ((prevHp = APISpellHelper.getCurrentAdditionalHP((EntityPlayer)event.entityLiving)) > 0.0f) {
                float recalculatedAmount = ISpecialArmor.ArmorProperties.ApplyArmor((EntityLivingBase)player, (ItemStack[])player.inventory.armorInventory, (DamageSource)event.source, (double)event.ammount);
                if (recalculatedAmount <= 0.0f) {
                    return;
                }
                recalculatedAmount = SpellHelper.applyPotionDamageCalculations((EntityLivingBase)player, event.source, recalculatedAmount);
                float ratio = recalculatedAmount / event.ammount;
                float f1 = recalculatedAmount;
                recalculatedAmount = Math.max(recalculatedAmount - player.getAbsorptionAmount(), 0.0f);
                player.setAbsorptionAmount(player.getAbsorptionAmount() - (f1 - recalculatedAmount));
                if (prevHp > recalculatedAmount) {
                    ItemStack chestStack;
                    float hp = prevHp - recalculatedAmount;
                    event.ammount = 0.0f;
                    Reagent reagent = APISpellHelper.getPlayerReagentType(player);
                    OmegaParadigm paradigm = OmegaRegistry.getParadigmForReagent(reagent);
                    if (paradigm != null && (chestStack = player.inventory.armorInventory[2]) != null && chestStack.getItem() instanceof OmegaArmour && ((OmegaArmour)chestStack.getItem()).paradigm == paradigm) {
                        paradigm.onHPBarDepleted(player, chestStack);
                    }
                    APISpellHelper.setCurrentAdditionalHP(player, hp);
                    NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getAddedHPPacket(hp, APISpellHelper.getCurrentAdditionalMaxHP(player)), (EntityPlayerMP)player);
                } else {
                    APISpellHelper.setCurrentAdditionalHP(player, 0.0f);
                    NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getAddedHPPacket(0.0f, APISpellHelper.getCurrentAdditionalMaxHP(player)), (EntityPlayerMP)player);
                    event.ammount -= prevHp / ratio;
                    if (event.ammount < 0.0f) {
                        event.ammount = 0.0f;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void omegaUpdateReagentAndHpEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer && !event.entityLiving.worldObj.isRemote) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            Reagent reagent = APISpellHelper.getPlayerReagentType(player);
            float reagentAmount = APISpellHelper.getPlayerCurrentReagentAmount(player);
            boolean hasReagentChanged = false;
            if (reagentAmount > 0.0f && OmegaRegistry.hasParadigm(reagent)) {
                int cooldown = APISpellHelper.getPlayerReagentRegenCooldownTag(player);
                boolean canHealHPBar = true;
                if (cooldown > 0) {
                    float extra = 0.0f;
                    if (player.isPotionActive(AlchemicalWizardry.customPotionSoulHarden)) {
                        extra += 0.25f * (float)(1 + player.getActivePotionEffect(AlchemicalWizardry.customPotionSoulHarden).getAmplifier());
                    }
                    if (player.isPotionActive(AlchemicalWizardry.customPotionSoulFray)) {
                        extra -= 0.25f * (float)(1 + player.getActivePotionEffect(AlchemicalWizardry.customPotionSoulFray).getAmplifier());
                    }
                    int deduction = -1 - (extra >= 0.0f ? (rand.nextFloat() < extra ? 1 : 0) : (rand.nextFloat() < -extra / 2.0f ? -1 : 0));
                    APISpellHelper.setPlayerReagentRegenCooldownTag(player, Math.max(cooldown + deduction, 0));
                    canHealHPBar = false;
                }
                OmegaParadigm parad = OmegaRegistry.getParadigmForReagent(reagent);
                ReagentRegenConfiguration config = parad.getRegenConfig(player);
                if (parad.isPlayerWearingFullSet(player)) {
                    if (canHealHPBar) {
                        int tickRate = config.tickRate;
                        if (player.isPotionActive(Potion.regeneration)) {
                            int i = player.getActivePotionEffect(Potion.regeneration).getAmplifier();
                            double factor = Math.pow(1.5, i + 1);
                            tickRate = Math.max((int)((double)tickRate / factor), 1);
                        }
                        if (event.entityLiving.worldObj.getWorldTime() % (long)tickRate == 0L) {
                            boolean hasHealthChanged = false;
                            int maxHealth = parad.getMaxAdditionalHealth();
                            float health = APISpellHelper.getCurrentAdditionalHP(player);
                            if (health > (float)maxHealth) {
                                health = maxHealth;
                                hasHealthChanged = true;
                            } else if (health < (float)maxHealth) {
                                float addedAmount = Math.min(Math.min(reagentAmount / config.costPerPoint, (float)config.healPerTick), (float)maxHealth - health);
                                float drain = addedAmount * config.costPerPoint;
                                reagentAmount -= drain;
                                hasReagentChanged = true;
                                health += addedAmount;
                                hasHealthChanged = true;
                            }
                            if (player instanceof EntityPlayerMP && hasHealthChanged) {
                                APISpellHelper.setCurrentAdditionalHP(player, health);
                                NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getAddedHPPacket(health, maxHealth), (EntityPlayerMP)player);
                            }
                        }
                    }
                } else {
                    reagentAmount = 0.0f;
                    APISpellHelper.setPlayerMaxReagentAmount(player, 0.0f);
                    NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getReagentBarPacket(null, 0.0f, 0.0f), (EntityPlayerMP)player);
                    APISpellHelper.setCurrentAdditionalHP(player, 0.0f);
                    NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getAddedHPPacket(0.0f, 0.0f), (EntityPlayerMP)player);
                }
                float costPerTick = parad.getCostPerTickOfUse(player);
                if (parad.doDrainReagent(player)) {
                    if (reagentAmount > costPerTick) {
                        hasReagentChanged = true;
                        reagentAmount = Math.max(0.0f, reagentAmount - costPerTick);
                    } else {
                        hasReagentChanged = true;
                        reagentAmount = 0.0f;
                    }
                }
                hasReagentChanged = true;
            }
            if (reagentAmount <= 0.0f) {
                ItemStack[] armourInventory;
                boolean hasRevertedArmour = false;
                for (ItemStack stack : armourInventory = player.inventory.armorInventory) {
                    if (stack == null || !(stack.getItem() instanceof OmegaArmour)) continue;
                    ((OmegaArmour)stack.getItem()).revertArmour(player, stack);
                    hasRevertedArmour = true;
                }
                if (hasRevertedArmour) {
                    APISpellHelper.setCurrentAdditionalHP(player, 0.0f);
                    NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getAddedHPPacket(0.0f, 0.0f), (EntityPlayerMP)player);
                }
            }
            if (player instanceof EntityPlayerMP && hasReagentChanged) {
                APISpellHelper.setPlayerCurrentReagentAmount(player, reagentAmount);
                NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getReagentBarPacket(reagent, reagentAmount, APISpellHelper.getPlayerMaxReagentAmount(player)), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDamageEvent(LivingAttackEvent event) {
        if (event.source.isProjectile() && event.entityLiving.isPotionActive(AlchemicalWizardry.customPotionProjProt) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        List<CoordAndRange> list;
        List<CoordAndRange> list2;
        if (!(event.entityLiving instanceof EntityMob)) {
            return;
        }
        String respawnRitual = "AW028SpawnWard";
        int dimension = event.world.provider.dimensionId;
        if (respawnMap.containsKey(dimension) && (list2 = respawnMap.get(dimension)) != null) {
            for (CoordAndRange coords : list2) {
                TileEntity tile = event.world.getTileEntity(coords.xCoord, coords.yCoord, coords.zCoord);
                if (tile instanceof TEMasterStone && ((TEMasterStone)tile).isRunning && ((TEMasterStone)tile).getCurrentRitual().equals(respawnRitual)) {
                    if (!(event.x > (float)(coords.xCoord - coords.horizRadius)) || !(event.x < (float)(coords.xCoord + coords.horizRadius)) || !(event.z > (float)(coords.zCoord - coords.horizRadius)) || !(event.z < (float)(coords.zCoord + coords.horizRadius)) || !(event.y > (float)(coords.yCoord - coords.vertRadius)) || !(event.y < (float)(coords.yCoord + coords.vertRadius))) continue;
                    switch (event.getResult()) {
                        case ALLOW: {
                            event.setResult(Event.Result.DEFAULT);
                            break;
                        }
                        case DEFAULT: {
                            event.setResult(Event.Result.DENY);
                            break;
                        }
                        case DENY: {
                            break;
                        }
                    }
                    break;
                }
                list2.remove(coords);
            }
        }
        if (event.entityLiving instanceof EntityCreeper) {
            return;
        }
        String forceSpawnRitual = "AW029VeilOfEvil";
        if (forceSpawnMap.containsKey(dimension) && (list = forceSpawnMap.get(dimension)) != null) {
            for (CoordAndRange coords : list) {
                TileEntity tile = event.world.getTileEntity(coords.xCoord, coords.yCoord, coords.zCoord);
                if (tile instanceof TEMasterStone && ((TEMasterStone)tile).isRunning && ((TEMasterStone)tile).getCurrentRitual().equals(forceSpawnRitual)) {
                    if (!(event.x > (float)(coords.xCoord - coords.horizRadius)) || !(event.x < (float)(coords.xCoord + coords.horizRadius)) || !(event.z > (float)(coords.zCoord - coords.horizRadius)) || !(event.z < (float)(coords.zCoord + coords.horizRadius)) || !(event.y > (float)(coords.yCoord - coords.vertRadius)) || !(event.y < (float)(coords.yCoord + coords.vertRadius))) continue;
                    switch (event.getResult()) {
                        case ALLOW: {
                            break;
                        }
                        case DEFAULT: {
                            event.setResult(Event.Result.ALLOW);
                            break;
                        }
                        case DENY: {
                            event.setResult(Event.Result.DEFAULT);
                            break;
                        }
                    }
                    break;
                }
                list.remove(coords);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        if (AlchemicalWizardry.respawnWithDebuff && event.player != null) {
            event.player.addPotionEffect(new PotionEffect(AlchemicalWizardry.customPotionSoulFray.id, 6000, 0));
        }
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (event.entityLiving.isPotionActive(AlchemicalWizardry.customPotionBoost)) {
            int i = event.entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionBoost).getAmplifier();
            event.entityLiving.motionY += (double)(0.1f * (float)(2 + i));
        }
        if (event.entityLiving.isPotionActive(AlchemicalWizardry.customPotionHeavyHeart)) {
            event.entityLiving.motionY = 0.0;
        }
    }

    @SubscribeEvent
    public void onEndermanTeleportEvent(EnderTeleportEvent event) {
        if (event.entityLiving.isPotionActive(AlchemicalWizardry.customPotionPlanarBinding) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingAttackEvent event) {
        Entity entityAttacking;
        EntityLivingBase entityAttacked = event.entityLiving;
        if (entityAttacked.isPotionActive(AlchemicalWizardry.customPotionReciprocation) && (entityAttacking = event.source.getSourceOfDamage()) != null && entityAttacking instanceof EntityLivingBase) {
            int i = event.entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionReciprocation).getAmplifier();
            float damageRecieve = event.ammount / 2.0f * (float)(i + 1);
            entityAttacking.attackEntityFrom(DamageSource.generic, damageRecieve);
        }
        if (entityAttacked.isPotionActive(AlchemicalWizardry.customPotionFlameCloak)) {
            int i = event.entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionFlameCloak).getAmplifier();
            Entity entityAttacking2 = event.source.getSourceOfDamage();
            if (entityAttacking2 != null && entityAttacking2 instanceof EntityLivingBase && !entityAttacking2.isImmuneToFire() && !((EntityLivingBase)entityAttacking2).isPotionActive(Potion.fireResistance)) {
                entityAttacking2.attackEntityFrom(DamageSource.inFire, (float)(2 * i + 2));
                entityAttacking2.setFire(3);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving = event.entityLiving;
        double x = entityLiving.posX;
        double y = entityLiving.posY;
        double z = entityLiving.posZ;
        Vec3 blockVector = SpellHelper.getEntityBlockVector((Entity)entityLiving);
        int xPos = (int)blockVector.xCoord;
        int yPos = (int)blockVector.yCoord;
        int zPos = (int)blockVector.zCoord;
        if (entityLiving instanceof EntityPlayer && !entityLiving.worldObj.isRemote && entityLiving.worldObj.getTotalWorldTime() % 20L == 0L && entityLiving instanceof EntityPlayerMP) {
            String ownerName = SoulNetworkHandler.getUsername((EntityPlayer)entityLiving);
            NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getLPPacket(SoulNetworkHandler.getCurrentEssence(ownerName), SoulNetworkHandler.getMaximumForOrbTier(SoulNetworkHandler.getCurrentMaxOrb(ownerName))), (EntityPlayerMP)entityLiving);
        }
        if (entityLiving instanceof EntityPlayer && entityLiving.worldObj.isRemote) {
            EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
            boolean highStepListed = playersWith1Step.contains(entityPlayer.getDisplayName());
            boolean hasHighStep = entityPlayer.isPotionActive(AlchemicalWizardry.customPotionBoost);
            if (hasHighStep && !highStepListed) {
                playersWith1Step.add(SpellHelper.getUsername(entityPlayer));
            }
            if (!hasHighStep && highStepListed) {
                playersWith1Step.remove(SpellHelper.getUsername(entityPlayer));
                entityPlayer.stepHeight = 0.5f;
            }
        }
        if (event.entityLiving.isPotionActive(AlchemicalWizardry.customPotionFeatherFall)) {
            event.entityLiving.fallDistance = 0.0f;
        }
        if (event.entityLiving.isPotionActive(AlchemicalWizardry.customPotionDrowning) && !event.entityLiving.isPotionActive(Potion.waterBreathing)) {
            int i = event.entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionDrowning).getAmplifier();
            if (event.entityLiving.worldObj.getWorldTime() % (long)(20 / (i + 1)) == 0L) {
                event.entityLiving.attackEntityFrom(DamageSource.drown, 2.0f);
                event.entityLiving.hurtResistantTime = Math.min(event.entityLiving.hurtResistantTime, 20 / (i + 1));
            }
        }
        if (event.entityLiving.isPotionActive(AlchemicalWizardry.customPotionBoost)) {
            int i = event.entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionBoost).getAmplifier();
            float percentIncrease = (float)(i + 1) * 0.05f;
            if (event.entityLiving instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)event.entityLiving;
                entityPlayer.stepHeight = 1.0f;
                if ((entityPlayer.onGround || entityPlayer.capabilities.isFlying) && entityPlayer.moveForward > 0.0f) {
                    entityPlayer.moveFlying(0.0f, 1.0f, entityPlayer.capabilities.isFlying ? percentIncrease / 2.0f : percentIncrease);
                }
            }
        }
        if (event.entityLiving.isPotionActive(AlchemicalWizardry.customPotionProjProt)) {
            int i = event.entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionProjProt).getAmplifier();
            EntityLivingBase entity = event.entityLiving;
            int posX = (int)Math.round(entity.posX - 0.5);
            int posY = (int)Math.round(entity.posY);
            int posZ = (int)Math.round(entity.posZ - 0.5);
            int d0 = (int)((double)(i + 1) * 2.5);
            AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)((double)posX - 0.5), (double)((double)posY - 0.5), (double)((double)posZ - 0.5), (double)((double)posX + 0.5), (double)((double)posY + 0.5), (double)((double)posZ + 0.5)).expand((double)d0, (double)d0, (double)d0);
            List list = event.entityLiving.worldObj.getEntitiesWithinAABB(Entity.class, axisalignedbb);
            for (Entity projectile : list) {
                if (projectile == null || !(projectile instanceof IProjectile) || AlchemicalWizardry.isBotaniaLoaded && this.isManaBurst(projectile)) continue;
                Entity throwingEntity = null;
                if (projectile instanceof EntityArrow) {
                    throwingEntity = ((EntityArrow)projectile).shootingEntity;
                } else if (projectile instanceof EnergyBlastProjectile) {
                    throwingEntity = ((EnergyBlastProjectile)projectile).shootingEntity;
                } else if (projectile instanceof EntityThrowable) {
                    throwingEntity = ((EntityThrowable)projectile).getThrower();
                }
                if (throwingEntity != null && throwingEntity.equals((Object)entity)) continue;
                double delX = projectile.posX - entity.posX;
                double delY = projectile.posY - entity.posY;
                double delZ = projectile.posZ - entity.posZ;
                double angle = (delX * projectile.motionX + delY * projectile.motionY + delZ * projectile.motionZ) / (Math.sqrt(delX * delX + delY * delY + delZ * delZ) * Math.sqrt(projectile.motionX * projectile.motionX + projectile.motionY * projectile.motionY + projectile.motionZ * projectile.motionZ));
                if ((angle = Math.acos(angle)) < 2.356194490192345) continue;
                if (throwingEntity != null) {
                    delX = -projectile.posX + throwingEntity.posX;
                    delY = -projectile.posY + (throwingEntity.posY + (double)throwingEntity.getEyeHeight());
                    delZ = -projectile.posZ + throwingEntity.posZ;
                }
                double curVel = Math.sqrt(delX * delX + delY * delY + delZ * delZ);
                double newVel = Math.sqrt(projectile.motionX * projectile.motionX + projectile.motionY * projectile.motionY + projectile.motionZ * projectile.motionZ);
                projectile.motionX = newVel * (delX /= curVel);
                projectile.motionY = newVel * (delY /= curVel);
                projectile.motionZ = newVel * (delZ /= curVel);
            }
        }
        if (event.entityLiving.isPotionActive(AlchemicalWizardry.customPotionFlight)) {
            if (event.entityLiving instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)event.entityLiving;
                String ownerName = SpellHelper.getUsername(entityPlayer);
                playerFlightBuff.put(ownerName, true);
                entityPlayer.capabilities.allowFlying = true;
            }
        } else if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)event.entityLiving;
            String ownerName = SpellHelper.getUsername(entityPlayer);
            if (!playerFlightBuff.containsKey(ownerName)) {
                playerFlightBuff.put(ownerName, false);
            }
            if (playerFlightBuff.get(ownerName).booleanValue()) {
                playerFlightBuff.put(ownerName, false);
                if (!entityPlayer.capabilities.isCreativeMode) {
                    entityPlayer.capabilities.allowFlying = false;
                    entityPlayer.capabilities.isFlying = false;
                    entityPlayer.sendPlayerAbilities();
                }
            }
        }
        if (entityLiving.isPotionActive(AlchemicalWizardry.customPotionFlameCloak)) {
            entityLiving.worldObj.spawnParticle("flame", x + SpellHelper.gaussian(1.0), y - 1.3 + SpellHelper.gaussian(0.3), z + SpellHelper.gaussian(1.0), 0.0, 0.06, 0.0);
            int i = event.entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionFlameCloak).getAmplifier();
            double range = (double)i * 0.5;
            List<Entity> entities = SpellHelper.getEntitiesInRange(entityLiving.worldObj, x, y, z, range, range);
            if (entities != null) {
                for (Entity entity : entities) {
                    if (entity.equals((Object)entityLiving) || entity.isImmuneToFire() || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).isPotionActive(Potion.fireResistance)) continue;
                    entity.setFire(3);
                }
            }
        }
        if (entityLiving.isPotionActive(AlchemicalWizardry.customPotionIceCloak)) {
            if (entityLiving.worldObj.getWorldTime() % 2L == 0L) {
                entityLiving.worldObj.spawnParticle("reddust", x + SpellHelper.gaussian(1.0), y - 1.3 + SpellHelper.gaussian(0.3), z + SpellHelper.gaussian(1.0), 116.0, 187.0, 251.0);
            }
            int r = event.entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionIceCloak).getAmplifier();
            int horizRange = r + 1;
            int vertRange = 1;
            if (!entityLiving.worldObj.isRemote) {
                for (int i = -horizRange; i <= horizRange; ++i) {
                    for (int k = -horizRange; k <= horizRange; ++k) {
                        for (int j = -vertRange - 1; j <= vertRange - 1; ++j) {
                            SpellHelper.freezeWaterBlock(entityLiving.worldObj, xPos + i, yPos + j, zPos + k);
                        }
                    }
                }
            }
        }
        if (entityLiving.isPotionActive(AlchemicalWizardry.customPotionHeavyHeart)) {
            entityLiving.worldObj.spawnParticle("flame", x + SpellHelper.gaussian(1.0), y - 1.3 + SpellHelper.gaussian(0.3), z + SpellHelper.gaussian(1.0), 0.0, 0.06, 0.0);
            int i = event.entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionHeavyHeart).getAmplifier();
            double decrease = 0.025 * (double)(i + 1);
            if (entityLiving.motionY > -0.9) {
                entityLiving.motionY -= decrease;
            }
            if (entityLiving instanceof EntityPlayer) {
                SpellHelper.setPlayerSpeedFromServer((EntityPlayer)entityLiving, entityLiving.motionX, entityLiving.motionY - decrease, entityLiving.motionZ);
            }
        }
        if (entityLiving.isPotionActive(AlchemicalWizardry.customPotionFireFuse)) {
            entityLiving.worldObj.spawnParticle("flame", x + SpellHelper.gaussian(1.0), y - 1.3 + SpellHelper.gaussian(0.3), z + SpellHelper.gaussian(1.0), 0.0, 0.06, 0.0);
            int r = event.entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionFireFuse).getAmplifier();
            int radius = r + 1;
            if (entityLiving.getActivePotionEffect(AlchemicalWizardry.customPotionFireFuse).getDuration() <= 2) {
                entityLiving.worldObj.createExplosion(null, x, y, z, (float)radius, false);
            }
        }
    }

    @SubscribeEvent
    public void onTelepose(TeleposeEvent event) {
        BlockStack initialBlock = new BlockStack(event.initialBlock, event.initialMetadata);
        BlockStack finalBlock = new BlockStack(event.finalBlock, event.finalMetadata);
        if (teleposerBlacklist.contains(initialBlock) || teleposerBlacklist.contains(finalBlock)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityPlayer player;
        EntityLivingBase entityLiving = event.entityLiving;
        if (entityLiving instanceof IDemon && event.source.getEntity() instanceof EntityPlayer) {
            player = (EntityPlayer)event.source.getEntity();
            player.addStat((StatBase)ModAchievements.demonSpawn, 1);
        }
        if (entityLiving instanceof IHoardDemon && event.source.getEntity() instanceof EntityPlayer) {
            player = (EntityPlayer)event.source.getEntity();
            player.addStat((StatBase)ModAchievements.demons, 1);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("AWWayofTime")) {
            BloodMagicConfiguration.syncConfig();
            AlchemicalWizardry.logger.info("Refreshing configuration file.");
        }
    }

    @Optional.Method(modid="Botania")
    private boolean isManaBurst(Entity entity) {
        if (entity instanceof IManaBurst) {
            ItemStack lens = ((IManaBurst)entity).getSourceLens();
            return lens.getItemDamage() == 8 || lens.getItemDamage() == 11;
        }
        return false;
    }
}

