/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.renderer;

import WayofTime.alchemicalWizardry.api.alchemy.energy.IReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.client.renderer.HUDElement;
import WayofTime.alchemicalWizardry.common.items.armour.OmegaArmour;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static boolean enableItemName = false;
    public static boolean enabled = true;
    public static boolean showInChat = true;
    public static int lpBarX = 12;
    public static int lpBarY = 75;
    public static int zLevel = 0;
    private static int xOffsetDefault;
    public static int xOffset;
    private static int yOffsetDefault;
    public static int yOffset;
    private static int yOffsetBottomCenterDefault;
    public static int yOffsetBottomCenter;
    private static boolean applyXOffsetToCenterDefault;
    public static boolean applyXOffsetToCenter;
    private static boolean applyYOffsetToMiddleDefault;
    public static boolean applyYOffsetToMiddle;
    public static String listMode;
    public static String alignMode;
    private static ScaledResolution scaledResolution;

    public static boolean onTickInGame(Minecraft mc) {
        if (enabled && (mc.inGameHasFocus || mc.currentScreen == null || mc.currentScreen instanceof GuiChat && showInChat) && !mc.gameSettings.showDebugInfo) {
            float maxHP;
            int max;
            int maxAmount;
            ItemStack stack;
            EntityClientPlayerMP player = mc.thePlayer;
            player.getEntityData();
            if (SpellHelper.canPlayerSeeAlchemy((EntityPlayer)player)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                scaledResolution = new ScaledResolution(mc, mc.displayWidth, mc.displayHeight);
                RenderHelper.displayArmorStatus(mc);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if ((stack = player.inventory.armorItemInSlot(2)) != null && stack.getItem() instanceof OmegaArmour && (maxAmount = (int)APISpellHelper.getPlayerMaxReagentAmount((EntityPlayer)player)) > 0) {
                float val = APISpellHelper.getPlayerCurrentReagentAmount((EntityPlayer)player);
                ReagentStack reagentStack = new ReagentStack(APISpellHelper.getPlayerReagentType((EntityPlayer)player), (int)val);
                if (reagentStack != null && reagentStack.amount > 0) {
                    RenderHelper.renderTestHUD(mc, reagentStack, maxAmount);
                }
            }
            if (SpellHelper.canPlayerSeeLPBar((EntityPlayer)player) && (max = APISpellHelper.getPlayerMaxLPTag((EntityPlayer)player)) > 1) {
                RenderHelper.renderLPHUD(mc, APISpellHelper.getPlayerLPTag((EntityPlayer)player), max);
            }
            if ((maxHP = APISpellHelper.getCurrentAdditionalMaxHP((EntityPlayer)player)) > 0.0f) {
                RenderHelper.renderHPHUD(mc, APISpellHelper.getCurrentAdditionalHP((EntityPlayer)player), maxHP);
            }
        }
        return true;
    }

    private static void renderLPHUD(Minecraft mc, int lpAmount, int maxAmount) {
        GL11.glPushMatrix();
        int xSize = 32;
        int ySize = 32;
        int amount = Math.max((int)(256.0 * ((double)(maxAmount - lpAmount) / (double)maxAmount)), 0);
        int x = (lpBarX - xSize / 2) * 8;
        int y = (lpBarY - ySize / 2) * 8;
        ResourceLocation test2 = new ResourceLocation("alchemicalwizardry", "textures/gui/container1.png");
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        mc.getTextureManager().bindTexture(test2);
        GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
        RenderHelper.drawTexturedModalRect(x, y + amount, 0, amount, 256.0, 256 - amount);
        ResourceLocation test = new ResourceLocation("alchemicalwizardry", "textures/gui/lpVial.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.getTextureManager().bindTexture(test);
        RenderHelper.drawTexturedModalRect(x, y, 0, 0, 256.0, 256.0);
        GL11.glPopMatrix();
    }

    private static void renderHPHUD(Minecraft mc, float hpAmount, float maxAmount) {
        GL11.glPushMatrix();
        int xSize = 32;
        int ySize = 32;
        int amount = Math.max((int)(256.0 * ((double)hpAmount / (double)maxAmount)), 0);
        int x = (lpBarX + 8 - xSize / 2) * 8;
        int y = (lpBarY + 32 - ySize / 2) * 8;
        ResourceLocation test2 = new ResourceLocation("alchemicalwizardry", "textures/gui/HPBar2.png");
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        mc.getTextureManager().bindTexture(test2);
        GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
        RenderHelper.drawTexturedModalRect(x, y, amount, 0, amount, 256.0);
        ResourceLocation test = new ResourceLocation("alchemicalwizardry", "textures/gui/HPBar1.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.getTextureManager().bindTexture(test);
        RenderHelper.drawTexturedModalRect(x, y, 0, 0, 256.0, 256.0);
        GL11.glPopMatrix();
    }

    private static List<HUDElement> getHUDElements(Minecraft mc) {
        ArrayList<HUDElement> elements = new ArrayList<HUDElement>();
        MovingObjectPosition movingobjectposition = mc.objectMouseOver;
        WorldClient world = mc.theWorld;
        if (movingobjectposition == null) {
            return elements;
        }
        if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = movingobjectposition.blockX;
            int y = movingobjectposition.blockY;
            int z = movingobjectposition.blockZ;
            TileEntity tile = world.getTileEntity(x, y, z);
            if (!(tile instanceof IReagentHandler)) {
                return elements;
            }
            IReagentHandler relay = (IReagentHandler)tile;
            ReagentContainerInfo[] infos = relay.getContainerInfo(ForgeDirection.getOrientation((int)movingobjectposition.sideHit));
            if (infos != null) {
                for (ReagentContainerInfo info : infos) {
                    ItemStack itemStack;
                    if (info == null || info.reagent == null || info.reagent.reagent == null || (itemStack = ReagentRegistry.getItemForReagent(info.reagent.reagent)) == null) continue;
                    elements.add(new HUDElement(itemStack, 16, 16, 2, info.reagent.amount));
                }
            }
        }
        return elements;
    }

    private static int getX(int width) {
        if (alignMode.toLowerCase().contains("center")) {
            return scaledResolution.getScaledWidth() / 2 - width / 2 + (applyXOffsetToCenter ? xOffset : 0);
        }
        if (alignMode.toLowerCase().contains("right")) {
            return scaledResolution.getScaledWidth() - width - xOffset;
        }
        return xOffset;
    }

    private static int getY(int rowCount, int height) {
        if (alignMode.toLowerCase().contains("middle")) {
            return scaledResolution.getScaledHeight() / 2 - rowCount * height / 2 + (applyYOffsetToMiddle ? yOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("bottomleft") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.getScaledHeight() - rowCount * height - yOffset;
        }
        if (alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.getScaledHeight() - rowCount * height - yOffsetBottomCenter;
        }
        return yOffset;
    }

    private static int getElementsWidth(List<HUDElement> elements) {
        int r = 0;
        for (HUDElement he : elements) {
            r += he.width();
        }
        return r;
    }

    public static void drawTexturedModalRect(int p_73729_1_, int p_73729_2_, int p_73729_3_, int p_73729_4_, double p_73729_5_, double p_73729_6_) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)p_73729_1_, (double)p_73729_2_ + p_73729_6_, (double)zLevel, (double)((float)p_73729_3_ * f), ((double)p_73729_4_ + p_73729_6_) * (double)f1);
        tessellator.addVertexWithUV((double)p_73729_1_ + p_73729_5_, (double)p_73729_2_ + p_73729_6_, (double)zLevel, ((double)p_73729_3_ + p_73729_5_) * (double)f, ((double)p_73729_4_ + p_73729_6_) * (double)f1);
        tessellator.addVertexWithUV((double)p_73729_1_ + p_73729_5_, (double)p_73729_2_, (double)zLevel, ((double)p_73729_3_ + p_73729_5_) * (double)f, (double)((float)p_73729_4_ * f1));
        tessellator.addVertexWithUV((double)p_73729_1_, (double)p_73729_2_, (double)zLevel, (double)((float)p_73729_3_ * f), (double)((float)p_73729_4_ * f1));
        tessellator.draw();
    }

    private static void renderTestHUD(Minecraft mc, ReagentStack reagentStack, int maxAmount) {
        GL11.glPushMatrix();
        Reagent reagent = reagentStack.reagent;
        int xSize = 32;
        int ySize = 32;
        int amount = Math.max((int)(256.0 * ((double)(maxAmount - reagentStack.amount) / (double)maxAmount)), 0);
        int x = (lpBarX + 16 - xSize / 2) * 8;
        int y = (lpBarY - ySize / 2) * 8;
        GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
        ResourceLocation test2 = new ResourceLocation("alchemicalwizardry", "textures/gui/container1.png");
        GL11.glColor4f((float)((float)reagent.getColourRed() / 255.0f), (float)((float)reagent.getColourGreen() / 255.0f), (float)((float)reagent.getColourBlue() / 255.0f), (float)1.0f);
        mc.getTextureManager().bindTexture(test2);
        RenderHelper.drawTexturedModalRect(x, y + amount, 0, amount, 256.0, 256 - amount);
        ResourceLocation test = new ResourceLocation("alchemicalwizardry", "textures/gui/container.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.getTextureManager().bindTexture(test);
        RenderHelper.drawTexturedModalRect(x, y, 0, 0, 256.0, 256.0);
        GL11.glPopMatrix();
    }

    public static void renderIcon(int p_94149_1_, int p_94149_2_, IIcon p_94149_3_, int p_94149_4_, int p_94149_5_) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)p_94149_1_, (double)(p_94149_2_ + p_94149_5_), (double)zLevel, (double)p_94149_3_.getMinU(), (double)p_94149_3_.getMaxV());
        tessellator.addVertexWithUV((double)(p_94149_1_ + p_94149_4_), (double)(p_94149_2_ + p_94149_5_), (double)zLevel, (double)p_94149_3_.getMaxU(), (double)p_94149_3_.getMaxV());
        tessellator.addVertexWithUV((double)(p_94149_1_ + p_94149_4_), (double)p_94149_2_, (double)zLevel, (double)p_94149_3_.getMaxU(), (double)p_94149_3_.getMinV());
        tessellator.addVertexWithUV((double)p_94149_1_, (double)p_94149_2_, (double)zLevel, (double)p_94149_3_.getMinU(), (double)p_94149_3_.getMinV());
        tessellator.draw();
    }

    private static void displayArmorStatus(Minecraft mc) {
        block2: {
            int yOffset;
            List<HUDElement> elements;
            block3: {
                elements = RenderHelper.getHUDElements(mc);
                if (elements.size() <= 0) break block2;
                int n = yOffset = enableItemName ? 18 : 16;
                if (!listMode.equalsIgnoreCase("vertical")) break block3;
                int yBase = RenderHelper.getY(elements.size(), yOffset);
                for (HUDElement e : elements) {
                    e.renderToHud(alignMode.toLowerCase().contains("right") ? RenderHelper.getX(0) : RenderHelper.getX(e.width()), yBase);
                    yBase += yOffset;
                }
                break block2;
            }
            if (!listMode.equalsIgnoreCase("horizontal")) break block2;
            int totalWidth = RenderHelper.getElementsWidth(elements);
            int yBase = RenderHelper.getY(1, yOffset);
            int xBase = RenderHelper.getX(totalWidth);
            int prevX = 0;
            for (HUDElement e : elements) {
                e.renderToHud(xBase + prevX + (alignMode.toLowerCase().contains("right") ? e.width() : 0), yBase);
                prevX += e.width();
            }
        }
    }

    static {
        xOffset = xOffsetDefault = 50;
        yOffset = yOffsetDefault = 2;
        yOffsetBottomCenter = yOffsetBottomCenterDefault = 41;
        applyXOffsetToCenter = applyXOffsetToCenterDefault = true;
        applyYOffsetToMiddle = applyYOffsetToMiddleDefault = false;
        listMode = "horizontal";
        alignMode = "bottomcenter";
    }
}

