/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.spell;

import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.spell.EntitySpellProjectile;
import WayofTime.alchemicalWizardry.api.spell.IProjectileImpactEffect;
import WayofTime.alchemicalWizardry.api.spell.IProjectileUpdateEffect;
import WayofTime.alchemicalWizardry.api.spell.SpellEffect;
import WayofTime.alchemicalWizardry.api.spell.SpellEnhancement;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigm;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class SpellParadigmProjectile
extends SpellParadigm {
    public DamageSource damageSource = DamageSource.generic;
    public float damage = 1.0f;
    public int cost = 0;
    public List<IProjectileImpactEffect> impactList = new ArrayList<IProjectileImpactEffect>();
    public List<IProjectileUpdateEffect> updateEffectList = new ArrayList<IProjectileUpdateEffect>();
    public boolean penetration = false;
    public int ricochetMax = 0;
    public boolean isSilkTouch = false;

    @Override
    public void enhanceParadigm(SpellEnhancement enh) {
    }

    @Override
    public void castSpell(World world, EntityPlayer entityPlayer, ItemStack itemStack) {
        int cost = this.getTotalCost();
        if (!SoulNetworkHandler.syphonAndDamageFromNetwork(itemStack, entityPlayer, cost)) {
            return;
        }
        EntitySpellProjectile proj = new EntitySpellProjectile(world, entityPlayer);
        this.prepareProjectile(proj);
        world.spawnEntityInWorld((Entity)proj);
    }

    public static SpellParadigmProjectile getParadigmForEffectArray(List<SpellEffect> effectList) {
        SpellParadigmProjectile parad = new SpellParadigmProjectile();
        for (SpellEffect eff : effectList) {
            parad.addBufferedEffect(eff);
        }
        return parad;
    }

    public void prepareProjectile(EntitySpellProjectile proj) {
        proj.setDamage(this.damage);
        proj.setImpactList(this.impactList);
        proj.setUpdateEffectList(this.updateEffectList);
        proj.setPenetration(this.penetration);
        proj.setRicochetMax(this.ricochetMax);
        proj.setIsSilkTouch(this.isSilkTouch);
        proj.setSpellEffectList(this.bufferedEffectList);
    }

    public void addImpactEffect(IProjectileImpactEffect eff) {
        if (eff != null) {
            this.impactList.add(eff);
        }
    }

    public void addUpdateEffect(IProjectileUpdateEffect eff) {
        if (eff != null) {
            this.updateEffectList.add(eff);
        }
    }

    @Override
    public int getDefaultCost() {
        return 50;
    }
}

