/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.spell;

import WayofTime.alchemicalWizardry.api.spell.ComplexSpellEffect;
import WayofTime.alchemicalWizardry.api.spell.ComplexSpellModifier;
import WayofTime.alchemicalWizardry.api.spell.ComplexSpellType;
import WayofTime.alchemicalWizardry.api.spell.SpellEffectRegistry;
import WayofTime.alchemicalWizardry.api.spell.SpellEnhancement;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigm;
import net.minecraft.nbt.NBTTagCompound;

public class SpellEffect {
    public ComplexSpellType type;
    public ComplexSpellModifier modifier;
    protected int powerEnhancement;
    protected int costEnhancement;
    protected int potencyEnhancement;

    public SpellEffect() {
        this(ComplexSpellType.FIRE);
    }

    public SpellEffect(ComplexSpellType type) {
        this(type, ComplexSpellModifier.DEFAULT);
    }

    public SpellEffect(ComplexSpellType type, ComplexSpellModifier modifier) {
        this.type = type;
        this.modifier = modifier;
        this.powerEnhancement = 0;
        this.potencyEnhancement = 0;
        this.costEnhancement = 0;
    }

    public void enhanceEffect(SpellEnhancement enh) {
        if (enh != null) {
            switch (enh.getState()) {
                case 0: {
                    ++this.powerEnhancement;
                    break;
                }
                case 1: {
                    ++this.costEnhancement;
                    break;
                }
                case 2: {
                    ++this.potencyEnhancement;
                }
            }
        }
    }

    public void modifyEffect(ComplexSpellModifier mod) {
        if (mod != null) {
            this.modifier = mod;
        }
    }

    public void modifyParadigm(SpellParadigm parad) {
        if (parad == null) {
            return;
        }
        Class<?> paraClass = parad.getClass();
        ComplexSpellEffect effect = SpellEffectRegistry.getSpellEffect(paraClass, this.type, this.modifier, this.powerEnhancement, this.potencyEnhancement, this.costEnhancement);
        if (effect != null) {
            effect.modifyParadigm(parad);
        }
    }

    public int getCostOfEffect(SpellParadigm parad) {
        if (parad == null) {
            return 0;
        }
        Class<?> paraClass = parad.getClass();
        ComplexSpellEffect effect = SpellEffectRegistry.getSpellEffect(paraClass, this.type, this.modifier, this.powerEnhancement, this.potencyEnhancement, this.costEnhancement);
        if (effect == null) {
            return 0;
        }
        return effect.getCostOfEffect();
    }

    public NBTTagCompound getTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("Class", this.getClass().getName());
        tag.setString("type", SpellEffectRegistry.getKeyForType(this.type));
        tag.setString("modifier", SpellEffectRegistry.getKeyForModifier(this.modifier));
        tag.setInteger("power", this.powerEnhancement);
        tag.setInteger("cost", this.costEnhancement);
        tag.setInteger("potency", this.potencyEnhancement);
        return tag;
    }

    public static SpellEffect getEffectFromTag(NBTTagCompound tag) {
        block6: {
            try {
                Class<?> clazz = Class.forName(tag.getString("Class"));
                if (clazz == null) break block6;
                try {
                    Object obj = clazz.newInstance();
                    if (obj instanceof SpellEffect) {
                        SpellEffect eff = (SpellEffect)obj;
                        eff.type = SpellEffectRegistry.getTypeForKey(tag.getString("type"));
                        eff.modifier = SpellEffectRegistry.getModifierForKey(tag.getString("modifier"));
                        eff.powerEnhancement = tag.getInteger("power");
                        eff.costEnhancement = tag.getInteger("cost");
                        eff.potencyEnhancement = tag.getInteger("potency");
                        return eff;
                    }
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int getPowerEnhancements() {
        return this.powerEnhancement;
    }

    public int getPotencyEnhancements() {
        return this.potencyEnhancement;
    }

    public int getCostEnhancements() {
        return this.costEnhancement;
    }
}

