/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.spell;

import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.api.spell.IProjectileImpactEffect;
import WayofTime.alchemicalWizardry.api.spell.IProjectileUpdateEffect;
import WayofTime.alchemicalWizardry.api.spell.SpellEffect;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigmProjectile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntitySpellProjectile
extends Entity
implements IProjectile {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private int inData = 0;
    private boolean inGround = false;
    public EntityPlayer shootingEntity;
    private int ticksInAir = 0;
    private int ricochetCounter = 0;
    private boolean scheduledForDeath = false;
    private boolean isSilkTouch = false;
    private int maxRicochet = 0;
    private float damage = 1.0f;
    public List<IProjectileImpactEffect> impactList = new ArrayList<IProjectileImpactEffect>();
    private boolean penetration = false;
    public List<IProjectileUpdateEffect> updateEffectList = new ArrayList<IProjectileUpdateEffect>();
    public List<SpellEffect> spellEffectList = new LinkedList<SpellEffect>();
    private int blocksBroken = 0;

    public EntitySpellProjectile(World par1World) {
        super(par1World);
        this.setSize(0.5f, 0.5f);
    }

    public EntitySpellProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World);
        this.setSize(0.5f, 0.5f);
        this.setPosition(par2, par4, par6);
        this.yOffset = 0.0f;
    }

    public EntitySpellProjectile(World par1World, EntityPlayer par2EntityPlayer) {
        super(par1World);
        this.shootingEntity = par2EntityPlayer;
        float par3 = 0.8f;
        this.setSize(0.1f, 0.1f);
        this.setLocationAndAngles(par2EntityPlayer.posX, par2EntityPlayer.posY + (double)par2EntityPlayer.getEyeHeight(), par2EntityPlayer.posZ, par2EntityPlayer.rotationYaw, par2EntityPlayer.rotationPitch);
        this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.posY -= 0.2;
        this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, par3 * 1.5f, 1.0f);
    }

    protected void entityInit() {
        this.dataWatcher.addObject(16, (Object)0);
    }

    public void setThrowableHeading(double var1, double var3, double var5, float var7, float var8) {
        float var9 = MathHelper.sqrt_double((double)(var1 * var1 + var3 * var3 + var5 * var5));
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        var1 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var3 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var5 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        this.motionX = var1 *= (double)var7;
        this.motionY = var3 *= (double)var7;
        this.motionZ = var5 *= (double)var7;
        float var10 = MathHelper.sqrt_double((double)(var1 * var1 + var5 * var5));
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(var1, var5) * 180.0 / Math.PI);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(var3, var10) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.setPosition(par1, par3, par5);
        this.setRotation(par7, par8);
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double par1, double par3, double par5) {
        this.motionX = par1;
        this.motionY = par3;
        this.motionZ = par5;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float var7 = MathHelper.sqrt_double((double)(par1 * par1 + par5 * par5));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(par3, var7) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch;
            this.prevRotationYaw = this.rotationYaw;
            this.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        }
    }

    public void onUpdate() {
        Block var16;
        super.onUpdate();
        this.performUpdateEffects();
        if (this.ticksInAir > 600) {
            this.setDead();
        }
        if (this.shootingEntity == null) {
            List players = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox((double)(this.posX - 1.0), (double)(this.posY - 1.0), (double)(this.posZ - 1.0), (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)));
            Iterator i = players.iterator();
            double closestDistance = Double.MAX_VALUE;
            EntityPlayer closestPlayer = null;
            while (i.hasNext()) {
                EntityPlayer e = (EntityPlayer)i.next();
                double distance = e.getDistanceToEntity((Entity)this);
                if (!(distance < closestDistance)) continue;
                closestPlayer = e;
            }
            if (closestPlayer != null) {
                this.shootingEntity = closestPlayer;
            }
        }
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float var1 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, var1) * 180.0 / Math.PI);
        }
        if ((var16 = this.worldObj.getBlock(this.xTile, this.yTile, this.zTile)) != null) {
            var16.setBlockBoundsBasedOnState((IBlockAccess)this.worldObj, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB var2 = var16.getCollisionBoundingBoxFromPool(this.worldObj, this.xTile, this.yTile, this.zTile);
            if (var2 != null && var2.isVecInside(APISpellHelper.createVec3(this.posX, this.posY, this.posZ))) {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            Block var18 = this.worldObj.getBlock(this.xTile, this.yTile, this.zTile);
            int var19 = this.worldObj.getBlockMetadata(this.xTile, this.yTile, this.zTile);
        } else {
            ++this.ticksInAir;
            if (this.ticksInAir > 1 && this.ticksInAir < 3) {
                for (int particles = 0; particles < 3; ++particles) {
                    this.doFiringParticles();
                }
            }
            Vec3 var17 = APISpellHelper.createVec3(this.posX, this.posY, this.posZ);
            Vec3 var3 = APISpellHelper.createVec3(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            MovingObjectPosition var4 = this.worldObj.func_147447_a(var17, var3, true, false, false);
            var17 = APISpellHelper.createVec3(this.posX, this.posY, this.posZ);
            var3 = APISpellHelper.createVec3(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            if (var4 != null) {
                var3 = APISpellHelper.createVec3(var4.hitVec.xCoord, var4.hitVec.yCoord, var4.hitVec.zCoord);
            }
            Entity var5 = null;
            List var6 = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double var7 = 0.0;
            for (Entity var10 : var6) {
                double var14;
                float var11;
                AxisAlignedBB var12;
                MovingObjectPosition var13;
                if (!var10.canBeCollidedWith() || var10 == this.shootingEntity && this.ticksInAir < 5 || (var13 = (var12 = var10.boundingBox.expand((double)(var11 = 0.3f), (double)var11, (double)var11)).calculateIntercept(var17, var3)) == null || !((var14 = var17.distanceTo(var13.hitVec)) < var7) && var7 != 0.0) continue;
                var5 = var10;
                var7 = var14;
            }
            if (var5 != null) {
                var4 = new MovingObjectPosition(var5);
            }
            if (var4 != null) {
                this.onImpact(var4);
                if (this.scheduledForDeath) {
                    this.setDead();
                }
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.setPosition(this.posX, this.posY, this.posZ);
        }
    }

    private void doFlightParticles() {
        if (this.ticksInAir % 3 == 0) {
            double gauss = this.gaussian(1.0);
            this.worldObj.spawnParticle("mobSpell", this.posX, this.posY, this.posZ, gauss, gauss, 0.0);
        }
    }

    private void doFiringParticles() {
        this.worldObj.spawnParticle("mobSpellAmbient", this.posX + this.smallGauss(0.1), this.posY + this.smallGauss(0.1), this.posZ + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.worldObj.spawnParticle("flame", this.posX, this.posY, this.posZ, this.gaussian(this.motionX), this.gaussian(this.motionY), this.gaussian(this.motionZ));
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setShort("xTile", (short)this.xTile);
        par1NBTTagCompound.setShort("yTile", (short)this.yTile);
        par1NBTTagCompound.setShort("zTile", (short)this.zTile);
        par1NBTTagCompound.setByte("inTile", (byte)this.inTile);
        par1NBTTagCompound.setByte("inData", (byte)this.inData);
        par1NBTTagCompound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        NBTTagList effectList = new NBTTagList();
        for (SpellEffect eff : this.spellEffectList) {
            effectList.appendTag((NBTBase)eff.getTag());
        }
        par1NBTTagCompound.setTag("Effects", (NBTBase)effectList);
        par1NBTTagCompound.setInteger("blocksBroken", this.blocksBroken);
        par1NBTTagCompound.setBoolean("isSilkTouch", this.isSilkTouch);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.xTile = par1NBTTagCompound.getShort("xTile");
        this.yTile = par1NBTTagCompound.getShort("yTile");
        this.zTile = par1NBTTagCompound.getShort("zTile");
        this.inTile = par1NBTTagCompound.getByte("inTile") & 0xFF;
        this.inData = par1NBTTagCompound.getByte("inData") & 0xFF;
        this.inGround = par1NBTTagCompound.getByte("inGround") == 1;
        this.blocksBroken = par1NBTTagCompound.getInteger("blocksBroken");
        this.isSilkTouch = par1NBTTagCompound.getBoolean("isSilkTouch");
        NBTTagList tagList = par1NBTTagCompound.getTagList("Effects", 10);
        LinkedList<SpellEffect> spellEffectList = new LinkedList<SpellEffect>();
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tag = tagList.getCompoundTagAt(i);
            SpellEffect eff = SpellEffect.getEffectFromTag(tag);
            if (eff == null) continue;
            spellEffectList.add(eff);
        }
        this.spellEffectList = spellEffectList;
        SpellParadigmProjectile parad = SpellParadigmProjectile.getParadigmForEffectArray(spellEffectList);
        parad.applyAllSpellEffects();
        parad.prepareProjectile(this);
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public void setKnockbackStrength(int par1) {
    }

    public boolean canAttackWithItem() {
        return false;
    }

    public void setIsCritical(boolean par1) {
        byte var2 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (Object)(var2 | 1));
        } else {
            this.dataWatcher.updateObject(16, (Object)(var2 & 0xFFFFFFFE));
        }
    }

    public boolean getIsCritical() {
        byte var1 = this.dataWatcher.getWatchableObjectByte(16);
        return (var1 & 1) != 0;
    }

    private void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit != null) {
            if (mop.entityHit == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.entityHit);
            this.performEntityImpactEffects(mop.entityHit);
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && !this.penetration) {
            this.groundImpact(mop.sideHit);
            this.performTileImpactEffects(mop);
        }
    }

    private void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.shootingEntity.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)this.shootingEntity), 1.0f);
            this.setDead();
        } else {
            this.doDamage(this.damage, mop);
        }
        this.spawnHitParticles("exorcism", 8);
        this.setDead();
    }

    private void spawnHitParticles(String string, int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.worldObj.spawnParticle("mobSpellAmbient", this.posX + this.smallGauss(0.1), this.posY + this.smallGauss(0.1), this.posZ + this.smallGauss(0.1), this.posGauss(1.0), this.posGauss(1.0), 0.0);
        }
    }

    private void doDamage(float f, Entity mop) {
        mop.attackEntityFrom(this.getDamageSource(), f);
    }

    private DamageSource getDamageSource() {
        return DamageSource.causePlayerDamage((EntityPlayer)this.shootingEntity);
    }

    private void groundImpact(int sideHit) {
        this.ricochet(sideHit);
    }

    private double smallGauss(double d) {
        return ((double)this.worldObj.rand.nextFloat() - 0.5) * d;
    }

    private double posGauss(double d) {
        return (double)this.rand.nextFloat() * 0.5 * d;
    }

    private double gaussian(double d) {
        return d + d * (((double)this.rand.nextFloat() - 0.5) / 4.0);
    }

    private void ricochet(int sideHit) {
        switch (sideHit) {
            case 0: 
            case 1: {
                this.motionY *= -1.0;
                break;
            }
            case 2: 
            case 3: {
                this.motionZ *= -1.0;
                break;
            }
            case 4: 
            case 5: {
                this.motionX *= -1.0;
            }
        }
        ++this.ricochetCounter;
        if (this.ricochetCounter > this.getRicochetMax()) {
            this.scheduledForDeath = true;
            block13: for (int particles = 0; particles < 4; ++particles) {
                switch (sideHit) {
                    case 0: {
                        this.worldObj.spawnParticle("smoke", this.posX, this.posY, this.posZ, this.gaussian(0.1), -this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 1: {
                        this.worldObj.spawnParticle("smoke", this.posX, this.posY, this.posZ, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 2: {
                        this.worldObj.spawnParticle("smoke", this.posX, this.posY, this.posZ, this.gaussian(0.1), this.gaussian(0.1), -this.gaussian(0.1));
                        continue block13;
                    }
                    case 3: {
                        this.worldObj.spawnParticle("smoke", this.posX, this.posY, this.posZ, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 4: {
                        this.worldObj.spawnParticle("smoke", this.posX, this.posY, this.posZ, -this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 5: {
                        this.worldObj.spawnParticle("smoke", this.posX, this.posY, this.posZ, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                    }
                }
            }
        }
    }

    public int getRicochetMax() {
        return this.maxRicochet;
    }

    public void setRicochetMax(int ricochet) {
        this.maxRicochet = ricochet;
    }

    public void setImpactList(List<IProjectileImpactEffect> list) {
        this.impactList = list;
    }

    public void setUpdateEffectList(List<IProjectileUpdateEffect> list) {
        this.updateEffectList = list;
    }

    private void performEntityImpactEffects(Entity mop) {
        if (this.impactList != null) {
            for (IProjectileImpactEffect impactEffect : this.impactList) {
                impactEffect.onEntityImpact(mop, this);
            }
        }
    }

    private void performTileImpactEffects(MovingObjectPosition mop) {
        if (this.impactList != null) {
            for (IProjectileImpactEffect impactEffect : this.impactList) {
                impactEffect.onTileImpact(this.worldObj, mop);
            }
        }
    }

    private void performUpdateEffects() {
        if (this.updateEffectList != null) {
            for (IProjectileUpdateEffect updateEffect : this.updateEffectList) {
                updateEffect.onUpdateEffect(this);
            }
        }
    }

    public void setPenetration(boolean penetration) {
        this.penetration = penetration;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setSpellEffectList(List<SpellEffect> list) {
        this.spellEffectList = list;
    }

    public int getBlocksBroken() {
        return this.blocksBroken;
    }

    public void setBlocksBroken(int blocksBroken) {
        this.blocksBroken = blocksBroken;
    }

    public boolean getIsSilkTouch() {
        return this.isSilkTouch;
    }

    public void setIsSilkTouch(boolean bool) {
        this.isSilkTouch = bool;
    }
}

