/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.guide;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.base.PageBase;
import amerifrance.guideapi.gui.GuiBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class PageMultiBlock
extends PageBase {
    ItemStack[][][] structure;
    boolean canTick = false;
    int tick = 0;
    int showLayer = -1;
    float scaleFactor = 1.0f;
    boolean renderMouseOver = true;
    int blockCount = 0;
    int[] countPerLevel;
    int structureHeight = 0;
    int structureLength = 0;
    int structureWidth = 0;

    public PageMultiBlock(ItemStack[][][] structure) {
        this.structure = structure;
        this.initPage(structure);
    }

    public void initPage(ItemStack[][][] structure) {
        this.structureHeight = structure.length;
        this.structureWidth = 0;
        this.structureLength = 0;
        this.countPerLevel = new int[this.structureHeight];
        this.blockCount = 0;
        for (int h = 0; h < structure.length; ++h) {
            if (structure[h].length - 1 > this.structureLength) {
                this.structureLength = structure[h].length - 1;
            }
            int perLvl = 0;
            for (int l = 0; l < structure[h].length; ++l) {
                if (structure[h][l].length - 1 > this.structureWidth) {
                    this.structureWidth = structure[h][l].length - 1;
                }
                for (ItemStack ss : structure[h][l]) {
                    if (ss == null) continue;
                    ++perLvl;
                }
            }
            this.countPerLevel[h] = perLvl;
            this.blockCount += perLvl;
        }
        this.tick = (this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) * 40;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
        Minecraft mc = Minecraft.getMinecraft();
        int x = guiLeft + 32;
        int y = guiTop + 30;
        if (this.canTick) {
            ++this.tick;
        }
        int prevLayers = 0;
        if (this.showLayer != -1) {
            for (int ll = 0; ll < this.showLayer; ++ll) {
                prevLayers += this.countPerLevel[ll];
            }
        }
        int limiter = prevLayers + this.tick / 40 % ((this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) + 4);
        int xHalf = this.structureWidth * 5 - this.structureLength * 5;
        int yOffPartial = (this.structureHeight - 1) * 12 + this.structureWidth * 5 + this.structureLength * 5;
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((1.0f - this.scaleFactor) * (float)(guiLeft + 64)), (float)((1.0f - this.scaleFactor) * (float)(guiTop + 60)), (float)0.0f);
        GL11.glScalef((float)this.scaleFactor, (float)this.scaleFactor, (float)this.scaleFactor);
        GL11.glEnable((int)32826);
        RenderHelper.enableGUIStandardItemLighting();
        RenderItem.getInstance().renderWithColor = true;
        int i = 0;
        ItemStack highlighted = null;
        for (int h = 0; h < this.structure.length; ++h) {
            if (this.showLayer != -1 && h > this.showLayer) continue;
            ItemStack[][] level = this.structure[h];
            for (int l = level.length - 1; l >= 0; --l) {
                ItemStack[] row = level[l];
                for (int w = row.length - 1; w >= 0; --w) {
                    int xx = 60 + xHalf - 10 * w + 10 * l - 7;
                    int yy = yOffPartial - 5 * w - 5 * l - 12 * h;
                    GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
                    if (row[w] == null || i > limiter) continue;
                    ++i;
                    RenderItem.getInstance().renderItemIntoGUI(mc.fontRenderer, mc.renderEngine, row[w], x + xx, y + yy);
                    if (mouseX < x + xx || mouseX >= x + xx + 16 || mouseY < y + yy || mouseY >= y + yy + 16) continue;
                    highlighted = row[w];
                }
            }
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-i));
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2929);
        mc.fontRenderer.setUnicodeFlag(false);
        if (highlighted != null && this.renderMouseOver) {
            guiBase.renderToolTip(highlighted, mouseX, mouseY);
        }
        RenderHelper.disableStandardItemLighting();
    }
}

