/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.guide;

import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.base.PageBase;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.gui.GuiBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class PageAltarRecipe
extends PageBase {
    public ItemStack input;
    public ItemStack output;
    public int tier;
    public int bloodRequired;

    public PageAltarRecipe(AltarRecipe recipe) {
        this.input = recipe.getRequiredItem();
        this.output = recipe.getResult();
        this.tier = recipe.getMinTier();
        this.bloodRequired = recipe.getLiquidRequired();
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(new ResourceLocation("alchemicalwizardry:textures/gui/guide/altar.png"));
        guiBase.drawTexturedModalRect(guiLeft + 42, guiTop + 53, 0, 87, 146, 104);
        guiBase.drawCenteredString(fontRenderer, StatCollector.translateToLocal((String)"text.recipe.altar"), guiLeft + guiBase.xSize / 2, guiTop + 12, 0);
        int inputX = 40 + (guiLeft + guiBase.xSize / 7) + 1;
        int inputY = 20 + (guiTop + guiBase.ySize / 5) - 1;
        GuiHelper.drawItemStack((ItemStack)this.input, (int)inputX, (int)inputY);
        if (GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)inputX, (int)inputY, (int)15, (int)15)) {
            guiBase.renderToolTip(this.input, mouseX, mouseY);
        }
        if (this.output == null) {
            this.output = new ItemStack((Block)Blocks.fire);
        }
        int outputX = 100 + (guiLeft + guiBase.xSize / 7) + 1;
        int outputY = 20 + (guiTop + guiBase.xSize / 5) - 1;
        GuiHelper.drawItemStack((ItemStack)this.output, (int)outputX, (int)outputY);
        if (GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)outputX, (int)outputY, (int)15, (int)15)) {
            guiBase.renderToolTip(this.output, outputX, outputY);
        }
        if (this.output.getItem() == Item.getItemFromBlock((Block)Blocks.fire)) {
            guiBase.drawCenteredString(fontRenderer, StatCollector.translateToLocal((String)"text.furnace.error"), guiLeft + guiBase.xSize / 2, guiTop + 4 * guiBase.ySize / 6, 15533885);
            guiBase.drawCenteredString(fontRenderer, StatCollector.translateToLocal((String)"bm.string.tier") + ": " + String.valueOf(this.tier), guiLeft + guiBase.xSize / 2, guiTop + 4 * guiBase.ySize / 6 + 15, 0);
            guiBase.drawCenteredString(fontRenderer, "LP: " + String.valueOf(this.bloodRequired), guiLeft + guiBase.xSize / 2, guiTop + 4 * guiBase.ySize / 6 + 30, 0);
        }
        guiBase.drawCenteredString(fontRenderer, String.format(StatCollector.translateToLocal((String)"text.recipe.altar.tier"), String.valueOf(this.tier)), guiLeft + guiBase.xSize / 2, guiTop + 4 * guiBase.ySize / 6, 0);
        guiBase.drawCenteredString(fontRenderer, String.format(StatCollector.translateToLocal((String)"text.recipe.altar.bloodRequired"), String.valueOf(this.bloodRequired)), guiLeft + guiBase.xSize / 2, guiTop + 4 * guiBase.ySize / 6 + 15, 0);
    }
}

