/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.guide;

import WayofTime.alchemicalWizardry.api.items.ShapedBloodOrbRecipe;
import WayofTime.alchemicalWizardry.api.items.ShapelessBloodOrbRecipe;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.abstraction.IRecipeRenderer;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.gui.GuiBase;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class OrbRecipeRenderer
implements IRecipeRenderer {
    public IRecipe recipe;

    public OrbRecipeRenderer(IRecipe recipe) {
        this.recipe = recipe;
    }

    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(new ResourceLocation("guideapi:textures/gui/recipe_elements.png"));
        guiBase.drawTexturedModalRect(guiLeft + 42, guiTop + 53, 0, 0, 105, 65);
        guiBase.drawCenteredString(fontRenderer, StatCollector.translateToLocal((String)"text.recipe.shapedOrb"), guiLeft + guiBase.xSize / 2, guiTop + 12, 0);
        if (this.recipe instanceof ShapelessBloodOrbRecipe) {
            ShapelessBloodOrbRecipe shapelessBloodOrbRecipe = (ShapelessBloodOrbRecipe)this.recipe;
            ArrayList<Object> list = shapelessBloodOrbRecipe.getInput();
            int width = 3;
            int height = 3;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (list.size() - 1 < y * width + x) continue;
                    int stackX = (x + 1) * 18 + (guiLeft + guiBase.xSize / 7);
                    int stackY = (y + 1) * 18 + (guiTop + guiBase.ySize / 5);
                    Object component = list.get(y * width + x);
                    if (component == null) continue;
                    if (component instanceof ItemStack) {
                        GuiHelper.drawItemStack((ItemStack)((ItemStack)component), (int)stackX, (int)stackY);
                        if (!GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)stackX, (int)stackY, (int)15, (int)15)) continue;
                        guiBase.renderToolTip((ItemStack)component, stackX, stackY);
                        continue;
                    }
                    if (component instanceof Integer) {
                        GuiHelper.drawItemStack((ItemStack)APISpellHelper.getOrbForLevel((Integer)component), (int)stackX, (int)stackY);
                        if (!GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)stackX, (int)stackY, (int)15, (int)15)) continue;
                        guiBase.renderToolTip(APISpellHelper.getOrbForLevel((Integer)component), stackX, stackY);
                        continue;
                    }
                    if (((ArrayList)component).isEmpty()) {
                        return;
                    }
                    GuiHelper.drawItemStack((ItemStack)((ItemStack)((ArrayList)component).get(0)), (int)stackX, (int)stackY);
                    if (!GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)stackX, (int)stackY, (int)15, (int)15)) continue;
                    guiBase.renderToolTip((ItemStack)((ArrayList)component).get(0), stackX, stackY);
                }
            }
            int outputX = 90 + (guiLeft + guiBase.xSize / 7);
            int outputY = 36 + (guiTop + guiBase.xSize / 5);
            GuiHelper.drawItemStack((ItemStack)shapelessBloodOrbRecipe.getRecipeOutput(), (int)outputX, (int)outputY);
            if (GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)outputX, (int)outputY, (int)15, (int)15)) {
                guiBase.renderToolTip(shapelessBloodOrbRecipe.getRecipeOutput(), outputX, outputY);
            }
        } else {
            ShapedBloodOrbRecipe shapedBloodOrbRecipe = (ShapedBloodOrbRecipe)this.recipe;
            int width = (Integer)ReflectionHelper.getPrivateValue(ShapedBloodOrbRecipe.class, (Object)shapedBloodOrbRecipe, (int)4);
            int height = (Integer)ReflectionHelper.getPrivateValue(ShapedBloodOrbRecipe.class, (Object)shapedBloodOrbRecipe, (int)5);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int stackX = (x + 1) * 18 + (guiLeft + guiBase.xSize / 7);
                    int stackY = (y + 1) * 18 + (guiTop + guiBase.ySize / 5);
                    Object component = shapedBloodOrbRecipe.getInput()[y * width + x];
                    if (component == null) continue;
                    if (component instanceof ItemStack) {
                        GuiHelper.drawItemStack((ItemStack)((ItemStack)component), (int)stackX, (int)stackY);
                        if (!GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)stackX, (int)stackY, (int)15, (int)15)) continue;
                        guiBase.renderToolTip((ItemStack)component, stackX, stackY);
                        continue;
                    }
                    if (component instanceof Integer) {
                        GuiHelper.drawItemStack((ItemStack)APISpellHelper.getOrbForLevel((Integer)component), (int)stackX, (int)stackY);
                        if (!GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)stackX, (int)stackY, (int)15, (int)15)) continue;
                        guiBase.renderToolTip(APISpellHelper.getOrbForLevel((Integer)component), stackX, stackY);
                        continue;
                    }
                    if (((ArrayList)component).isEmpty()) {
                        return;
                    }
                    GuiHelper.drawItemStack((ItemStack)((ItemStack)((ArrayList)component).get(0)), (int)stackX, (int)stackY);
                    if (!GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)stackX, (int)stackY, (int)15, (int)15)) continue;
                    guiBase.renderToolTip((ItemStack)((ArrayList)component).get(0), stackX, stackY);
                }
            }
            int outputX = 90 + (guiLeft + guiBase.xSize / 7);
            int outputY = 36 + (guiTop + guiBase.xSize / 5);
            GuiHelper.drawItemStack((ItemStack)shapedBloodOrbRecipe.getRecipeOutput(), (int)outputX, (int)outputY);
            if (GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)outputX, (int)outputY, (int)15, (int)15)) {
                guiBase.renderToolTip(shapedBloodOrbRecipe.getRecipeOutput(), outputX, outputY);
            }
        }
    }

    public void drawExtras(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
    }
}

