/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.command;

import WayofTime.alchemicalWizardry.api.command.ISubCommand;
import java.util.Locale;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public abstract class SubCommandBase
implements ISubCommand {
    private ICommand parent;
    private String name;

    public SubCommandBase(ICommand parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getSubCommandName() {
        return this.name;
    }

    @Override
    public ICommand getParentCommand() {
        return this.parent;
    }

    @Override
    public boolean canSenderUseSubCommand(ICommandSender commandSender) {
        return commandSender.canCommandSenderUseCommand(this.getRequiredPermissionLevel(), "op");
    }

    @Override
    public void processSubCommand(ICommandSender commandSender, String[] args) {
        if (args.length == 0 && !this.getSubCommandName().equals("help")) {
            this.displayErrorString(commandSender, String.format(StatCollector.translateToLocal((String)"commands.format.error"), this.capitalizeFirstLetter(this.getSubCommandName()), this.getArgUsage(commandSender)), new Object[0]);
        }
        if (this.isBounded(0, 2, args.length) && args[0].equals("help")) {
            this.displayHelpString(commandSender, String.format(StatCollector.translateToLocal((String)"commands.format.help"), this.capitalizeFirstLetter(this.getSubCommandName()), this.getHelpText()), new Object[0]);
        }
    }

    protected EntityPlayerMP getCommandSenderAsPlayer(ICommandSender commandSender) {
        if (commandSender instanceof EntityPlayerMP) {
            return (EntityPlayerMP)commandSender;
        }
        throw new PlayerNotFoundException(StatCollector.translateToLocal((String)"commands.error.arg.player.missing"), new Object[0]);
    }

    protected EntityPlayerMP getPlayer(ICommandSender commandSender, String playerName) {
        EntityPlayerMP entityplayermp = PlayerSelector.matchOnePlayer((ICommandSender)commandSender, (String)playerName);
        if (entityplayermp != null) {
            return entityplayermp;
        }
        entityplayermp = MinecraftServer.getServer().getConfigurationManager().func_152612_a(playerName);
        if (entityplayermp == null) {
            throw new PlayerNotFoundException();
        }
        return entityplayermp;
    }

    protected String capitalizeFirstLetter(String toCapital) {
        return String.valueOf(toCapital.charAt(0)).toUpperCase(Locale.ENGLISH) + toCapital.substring(1);
    }

    protected boolean isBounded(int low, int high, int given) {
        return given > low && given < high;
    }

    protected void displayHelpString(ICommandSender commandSender, String display, Object ... info) {
        commandSender.addChatMessage(new ChatComponentText(StatCollector.translateToLocalFormatted((String)display, (Object[])info)).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.GREEN)));
    }

    protected void displayErrorString(ICommandSender commandSender, String display, Object ... info) {
        commandSender.addChatMessage(new ChatComponentText(StatCollector.translateToLocalFormatted((String)display, (Object[])info)).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.RED)));
    }

    protected void displaySuccessString(ICommandSender commandSender, String display, Object ... info) {
        commandSender.addChatMessage(new ChatComponentText(StatCollector.translateToLocalFormatted((String)display, (Object[])info)).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.BLUE)));
    }
}

