/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.entities;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import ganymedes01.etfuturum.ModItems;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityTippedArrow
extends EntityArrow
implements IEntityAdditionalSpawnData {
    private ItemStack arrow;

    public EntityTippedArrow(World world) {
        super(world);
    }

    public EntityTippedArrow(World world, EntityLivingBase entity, float f0) {
        super(world, entity, f0);
    }

    public EntityTippedArrow(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityTippedArrow(World world, EntityLivingBase entity, EntityLivingBase target, float f0, float f1) {
        super(world, entity, target, f0, f1);
    }

    public void setArrow(ItemStack effect) {
        this.arrow = effect;
    }

    public ItemStack getArrow() {
        return this.arrow;
    }

    private boolean isEffectValid() {
        return this.arrow != null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_70252_j % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        }
    }

    private void spawnPotionParticles(int particleCount) {
        if (this.isEffectValid() && particleCount > 0) {
            Color colour = new Color(ModItems.TIPPED_ARROW.get().func_82790_a(this.arrow, 0));
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_72869_a("mobSpell", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - (double)this.field_70129_M, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (double)((float)colour.getRed() / 255.0f), (double)((float)colour.getGreen() / 255.0f), (double)((float)colour.getBlue() / 255.0f));
            }
        }
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("Potion", 10)) {
            this.arrow = ItemStack.func_77949_a((NBTTagCompound)tagCompund.func_74775_l("Potion"));
        } else {
            this.setPotionDamage(tagCompund.func_74762_e("potionValue"));
        }
        if (this.arrow == null) {
            this.func_70106_y();
        }
    }

    public void setPotionDamage(int p_82340_1_) {
        if (this.arrow == null) {
            this.arrow = ModItems.TIPPED_ARROW.newItemStack(1, 0);
        }
        this.arrow.func_77964_b(p_82340_1_);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.arrow != null) {
            tagCompound.func_74782_a("Potion", (NBTBase)this.arrow.func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.field_70249_b <= 0 && this.isEffectValid()) {
            boolean flag = this.field_70251_a == 1 || this.field_70251_a == 2 && player.field_71075_bZ.field_75098_d;
            ItemStack stack = this.arrow.func_77946_l();
            stack.field_77994_a = 1;
            if (this.field_70251_a == 1 && !player.field_71071_by.func_70441_a(stack)) {
                flag = false;
            }
            if (flag) {
                this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.field_70177_z);
        int id = this.field_70250_c == null ? this.func_145782_y() : this.field_70250_c.func_145782_y();
        buffer.writeInt(id);
        buffer.writeDouble(this.field_70159_w);
        buffer.writeDouble(this.field_70181_x);
        buffer.writeDouble(this.field_70179_y);
        PacketBuffer pb = new PacketBuffer(buffer);
        try {
            pb.func_150788_a(this.arrow);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        this.field_70177_z = buffer.readFloat();
        this.field_70250_c = this.field_70170_p.func_73045_a(buffer.readInt());
        this.field_70159_w = buffer.readDouble();
        this.field_70181_x = buffer.readDouble();
        this.field_70179_y = buffer.readDouble();
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        PacketBuffer pb = new PacketBuffer(buffer);
        try {
            this.arrow = pb.func_150791_c();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

