/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.inventory;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import de.eydamos.backpack.helper.InventoryHelper;
import de.eydamos.backpack.inventory.AbstractInventoryBackpack;
import de.eydamos.backpack.inventory.ISaveableInventory;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.backpack.util.BackpackUtil;
import java.util.Arrays;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;

public class InventoryCraftingGrid
extends InventoryCrafting
implements ISaveableInventory<BackpackSave> {
    protected AbstractInventoryBackpack backpackInventory = null;
    protected boolean useInventoryMode = false;
    protected boolean isDirty = false;
    protected int[] mapping;

    public InventoryCraftingGrid(IInventory inventoryBackpack) {
        super(null, 3, 3);
        if (inventoryBackpack instanceof AbstractInventoryBackpack) {
            this.backpackInventory = (AbstractInventoryBackpack)inventoryBackpack;
        }
        this.mapping = new int[this.func_70302_i_()];
        Arrays.fill(this.mapping, -1);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack returnStack = super.func_70298_a(slot, amount);
        this.func_70296_d();
        return returnStack;
    }

    public void func_70299_a(int slotPosition, ItemStack newItemStack) {
        int correspondingSlot;
        if (this.useInventoryMode && (correspondingSlot = this.findCorrespondingSlot(slotPosition)) != -1) {
            this.backpackInventory.func_70299_a(correspondingSlot, newItemStack);
            return;
        }
        super.func_70299_a(slotPosition, newItemStack);
        this.func_70296_d();
    }

    public void func_70296_d() {
        this.isDirty = true;
    }

    public ItemStack func_70301_a(int slotPosition) {
        if (this.useInventoryMode) {
            int correspondingSlot = this.findCorrespondingSlot(slotPosition);
            if (correspondingSlot == -1) {
                return null;
            }
            return this.backpackInventory.func_70301_a(correspondingSlot);
        }
        return super.func_70301_a(slotPosition);
    }

    @Override
    public void readFromNBT(BackpackSave backpackSave) {
        InventoryHelper.readInventory(backpackSave, "craftingGrid", this.getStackList());
    }

    @Override
    public void writeToNBT(BackpackSave backpackSave) {
        if (this.isDirty) {
            InventoryHelper.writeInventory(backpackSave, "craftingGrid", this.getStackList());
            this.isDirty = false;
        }
    }

    protected ItemStack[] getStackList() {
        return (ItemStack[])ObfuscationReflectionHelper.getPrivateValue(InventoryCrafting.class, (Object)this, (String[])new String[]{"stackList", "a"});
    }

    public void setEventHandler(Container container) {
        ObfuscationReflectionHelper.setPrivateValue(InventoryCrafting.class, (Object)this, (Object)container, (String[])new String[]{"eventHandler", "c"});
    }

    public void setUseInventoryMode(boolean value) {
        this.useInventoryMode = value;
        if (!value) {
            Arrays.fill(this.mapping, -1);
        }
    }

    protected int findCorrespondingSlot(int recipeSlotPosition) {
        ItemStack inventoryStack;
        int i;
        if (this.mapping[recipeSlotPosition] != -1) {
            return this.mapping[recipeSlotPosition];
        }
        ItemStack craftingGridStack = super.func_70301_a(recipeSlotPosition);
        for (i = 0; i < this.backpackInventory.func_70302_i_(); ++i) {
            inventoryStack = this.backpackInventory.func_70301_a(i);
            if (!BackpackUtil.areStacksEqual(craftingGridStack, inventoryStack)) continue;
            this.mapping[recipeSlotPosition] = i;
            return i;
        }
        for (i = 0; i < this.backpackInventory.func_70302_i_(); ++i) {
            inventoryStack = this.backpackInventory.func_70301_a(i);
            if (!BackpackUtil.areStacksEqualByOD(craftingGridStack, inventoryStack)) continue;
            this.mapping[recipeSlotPosition] = i;
            return i;
        }
        return -1;
    }
}

