/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymapserver.forge.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.techbrew.journeymapserver.common.config.ConfigHandler;
import net.techbrew.journeymapserver.common.network.PacketManager;
import net.techbrew.journeymapserver.common.util.LogHelper;
import net.techbrew.journeymapserver.forge.util.ForgePlayerUtil;

public class WorldIDPacket
implements IMessage {
    private String worldID;

    public WorldIDPacket() {
    }

    public WorldIDPacket(String worldID) {
        this.worldID = worldID;
    }

    public String getWorldID() {
        return this.worldID;
    }

    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
        try {
            if (this.worldID != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.worldID);
            }
        }
        catch (Throwable t) {
            LogHelper.error("[toBytes]Failed to read message: " + t);
        }
    }

    public static class WorldIdListener
    implements IMessageHandler<WorldIDPacket, IMessage> {
        public IMessage onMessage(WorldIDPacket message, MessageContext ctx) {
            LogHelper.info("On Request: Sending WorldID packet to: " + ForgePlayerUtil.instance.getPlayerInfoById(ctx.getServerHandler().field_147369_b.func_110124_au()).getName());
            String worldName = ctx.getServerHandler().field_147369_b.func_130014_f_().func_72912_H().func_76065_j();
            String worldID = ConfigHandler.getConfigByWorldName(worldName).getWorldID();
            PacketManager.instance.sendPlayerWorldID(worldID, ctx.getServerHandler().field_147369_b.func_70005_c_());
            return null;
        }
    }
}

