/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymapserver.common.mapcontrol;

import net.techbrew.journeymapserver.common.config.ConfigHandler;
import net.techbrew.journeymapserver.common.config.Configuration;
import net.techbrew.journeymapserver.common.util.PlayerUtil;

public class MappingOptionsHandler {
    private Configuration config;

    public MappingOptionsHandler(String worldName) {
        this.config = ConfigHandler.getConfigByWorldName(worldName);
    }

    public boolean disableRadar(String player) {
        if (this.config.getRadar().isPlayerRadar()) {
            return false;
        }
        if (PlayerUtil.isOp(player) && this.config.getRadar().isOpRadar()) {
            return false;
        }
        return this.config.getRadar().getWhiteListRadar() == null || !this.isUserInWhiteList(this.config.getRadar().getWhiteListRadar(), player);
    }

    public boolean disableCaveMapping(String player) {
        if (this.config.getCaveMapping().isPlayerCaveMapping()) {
            return false;
        }
        if (PlayerUtil.isOp(player) && this.config.getCaveMapping().isOpCaveMapping()) {
            return false;
        }
        return this.config.getCaveMapping().getWhiteListCaveMapping() == null || !this.isUserInWhiteList(this.config.getCaveMapping().getWhiteListCaveMapping(), player);
    }

    private boolean isUserInWhiteList(String userList, String player) {
        if ((userList = userList.replace(" ", "")).contains(",")) {
            String[] whiteListedUsers = userList.split(",");
            for (int i = 0; i < whiteListedUsers.length; ++i) {
                if (!whiteListedUsers[i].equalsIgnoreCase(player)) continue;
                return true;
            }
        } else if (userList.equalsIgnoreCase(player)) {
            return true;
        }
        return false;
    }
}

