/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymapserver.common.config;

import java.io.File;
import java.util.UUID;
import net.minecraft.util.com.google.gson.Gson;
import net.minecraft.util.com.google.gson.GsonBuilder;
import net.techbrew.journeymapserver.common.config.Configuration;
import net.techbrew.journeymapserver.common.reference.Controller;
import net.techbrew.journeymapserver.common.util.FileManager;
import net.techbrew.journeymapserver.common.util.LogHelper;

public class ConfigHandler {
    private static File configPath;
    private static final float CONFIG_VERSION = 1.11f;

    public static void init(File configPath) {
        ConfigHandler.configPath = configPath;
    }

    public static Configuration getConfigByWorldName(String worldName) {
        Configuration config = ConfigHandler.loadConfig(worldName = ConfigHandler.parseWorldName(worldName));
        if (config != null) {
            ConfigHandler.validateConfigVersion(config, worldName);
            return config;
        }
        return ConfigHandler.addNewWorldConfig(worldName);
    }

    private static Configuration addNewWorldConfig(String worldName) {
        worldName = ConfigHandler.parseWorldName(worldName);
        LogHelper.info("Attempting to create new config file for: " + worldName);
        Configuration config = ConfigHandler.generateDefaultConfig();
        ConfigHandler.saveWorld(config, worldName);
        return config;
    }

    private static Configuration generateDefaultConfig() {
        Configuration config = new Configuration();
        config.setConfigVersion(1.11f);
        config.setWorldID(UUID.randomUUID().toString());
        config.getRadar().setOpRadar(true);
        config.getRadar().setPlayerRadar(true);
        config.getRadar().setWhiteListRadar("");
        config.getCaveMapping().setOpCaveMapping(true);
        config.getCaveMapping().setPlayerCaveMapping(true);
        config.getCaveMapping().setWhiteListCaveMapping("");
        if (Controller.FORGE.equals((Object)Controller.getController())) {
            config.setUsingWorldID(false);
        } else {
            config.setUsingWorldID(true);
        }
        return config;
    }

    private static void validateConfigVersion(Configuration config, String worldName) {
        worldName = ConfigHandler.parseWorldName(worldName);
        float version = config.getConfigVersion();
        if (version != 1.11f) {
            if (version < 1.11f && Controller.FORGE.equals((Object)Controller.getController())) {
                config.setUsingWorldID(false);
            }
            if (version < 1.1f) {
                config.setSaveInWorldFolder(false);
            }
            if (version < 1.11f) {
                config.setConfigVersion(1.11f);
            }
        } else {
            return;
        }
        ConfigHandler.saveWorld(config, worldName);
    }

    public static boolean saveWorld(Configuration configuration, String worldName) {
        String gsonFile;
        worldName = ConfigHandler.parseWorldName(worldName);
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gsonFile = gson.toJson((Object)configuration);
        }
        catch (NoClassDefFoundError nce) {
            com.google.gson.Gson gson = new com.google.gson.GsonBuilder().setPrettyPrinting().create();
            gsonFile = gson.toJson((Object)configuration);
        }
        File config = new File(configPath, String.format("%s.cfg", worldName));
        if (!configPath.exists() || !configPath.isDirectory()) {
            configPath.mkdirs();
        }
        return FileManager.writeFile(config, gsonFile);
    }

    private static Configuration loadConfig(String worldName) {
        Configuration config;
        worldName = ConfigHandler.parseWorldName(worldName);
        File configFile = new File(configPath, String.format("%s.cfg", worldName));
        try {
            Gson gson = new Gson();
            config = (Configuration)gson.fromJson(FileManager.readFile(configFile), Configuration.class);
        }
        catch (NoClassDefFoundError nce) {
            com.google.gson.Gson gson = new com.google.gson.Gson();
            config = (Configuration)gson.fromJson(FileManager.readFile(configFile), Configuration.class);
        }
        return config;
    }

    private static String parseWorldName(String worldName) {
        String[] name = worldName.split("/");
        return name[name.length - 1];
    }
}

