/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.server;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.config.HEConfig;
import com.sinthoras.hydroenergy.network.packet.HEPacketConfigUpdate;
import com.sinthoras.hydroenergy.network.packet.HEPacketWaterUpdate;
import com.sinthoras.hydroenergy.server.HEBlockQueue;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class HEDam {
    private float waterLevel;
    private boolean isPlaced;
    private HE.DamMode mode = HE.DamMode.DRAIN;
    public int limitUp;
    public int limitDown;
    public int limitEast;
    public int limitWest;
    public int limitSouth;
    public int limitNorth;
    private int[] blocksPerY = new int[256];
    private int blockX;
    private int blockY;
    private int blockZ;
    private int dimensionId;
    private int waterBlockX;
    private int waterBlockY;
    private int waterBlockZ;
    private String ownerName = "";
    private final int waterId;
    private final long[] euCapacityUpToY = new long[256];
    private long timestampLastUpdate = 0L;

    public HEDam(int waterId) {
        this.waterId = waterId;
    }

    public void readFromNBTFull(NBTTagCompound compound) {
        this.waterLevel = compound.func_74760_g("walv");
        boolean drainState = compound.func_74767_n("drai");
        this.isPlaced = compound.func_74767_n("isPl");
        this.limitUp = compound.func_74762_e("limU");
        this.limitDown = compound.func_74762_e("limD");
        this.limitEast = compound.func_74762_e("limE");
        this.limitWest = compound.func_74762_e("limW");
        this.limitSouth = compound.func_74762_e("limS");
        this.limitNorth = compound.func_74762_e("limN");
        this.blocksPerY = compound.func_74759_k("BlPY");
        this.blockX = compound.func_74762_e("bloX");
        this.blockY = compound.func_74762_e("bloY");
        this.blockZ = compound.func_74762_e("bloZ");
        this.dimensionId = compound.func_74762_e("dimI");
        this.waterBlockX = compound.func_74762_e("watX");
        this.waterBlockY = compound.func_74762_e("watY");
        this.waterBlockZ = compound.func_74762_e("watZ");
        this.ownerName = compound.func_74779_i("ownN");
        this.mode = !this.isPlaced || drainState ? HE.DamMode.DRAIN : HE.DamMode.SPREAD;
    }

    public void writeToNBTFull(NBTTagCompound compound) {
        compound.func_74776_a("walv", this.waterLevel);
        compound.func_74757_a("drai", this.mode == HE.DamMode.DRAIN);
        compound.func_74757_a("isPl", this.isPlaced);
        compound.func_74768_a("limU", this.limitUp);
        compound.func_74768_a("limD", this.limitDown);
        compound.func_74768_a("limE", this.limitEast);
        compound.func_74768_a("limW", this.limitWest);
        compound.func_74768_a("limS", this.limitSouth);
        compound.func_74768_a("limN", this.limitNorth);
        compound.func_74783_a("BlPY", this.blocksPerY);
        compound.func_74768_a("bloX", this.blockX);
        compound.func_74768_a("bloY", this.blockY);
        compound.func_74768_a("bloZ", this.blockZ);
        compound.func_74768_a("dimI", this.dimensionId);
        compound.func_74768_a("watX", this.waterBlockX);
        compound.func_74768_a("watY", this.waterBlockY);
        compound.func_74768_a("watZ", this.waterBlockZ);
        compound.func_74778_a("ownN", this.ownerName);
    }

    public void setMode(HE.DamMode mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.sendConfigUpdate();
        }
    }

    public HE.DamMode getMode() {
        return this.mode;
    }

    public boolean setWaterLevel(float waterLevel) {
        this.waterLevel = waterLevel;
        long timestamp = System.currentTimeMillis();
        if (timestamp - this.timestampLastUpdate >= (long)HEConfig.minimalWaterUpdateInterval) {
            this.timestampLastUpdate = timestamp;
            this.sendWaterUpdate();
            return true;
        }
        return false;
    }

    public boolean setLimitWest(int limitWest) {
        if (limitWest != this.limitWest) {
            this.limitWest = limitWest;
            this.sendConfigUpdate();
            return true;
        }
        return false;
    }

    public int getLimitWest() {
        return this.limitWest;
    }

    public boolean setLimitDown(int limitDown) {
        if (limitDown != this.limitDown) {
            this.limitDown = limitDown;
            this.sendConfigUpdate();
            return true;
        }
        return false;
    }

    public int getLimitDown() {
        return this.limitDown;
    }

    public boolean setLimitNorth(int limitNorth) {
        if (limitNorth != this.limitNorth) {
            this.limitNorth = limitNorth;
            this.sendConfigUpdate();
            return true;
        }
        return false;
    }

    public int getLimitNorth() {
        return this.limitNorth;
    }

    public boolean setLimitEast(int limitEast) {
        if (limitEast != this.limitEast) {
            this.limitEast = limitEast;
            this.sendConfigUpdate();
            return true;
        }
        return false;
    }

    public int getLimitEast() {
        return this.limitEast;
    }

    public boolean setLimitUp(int limitUp) {
        if (limitUp != this.limitUp) {
            this.limitUp = limitUp;
            this.sendConfigUpdate();
            return true;
        }
        return false;
    }

    public int getLimitUp() {
        return this.limitUp;
    }

    public boolean setLimitSouth(int limitSouth) {
        if (limitSouth != this.limitSouth) {
            this.limitSouth = limitSouth;
            this.sendConfigUpdate();
            return true;
        }
        return false;
    }

    public int getLimitSouth() {
        return this.limitSouth;
    }

    public void sendWaterUpdate() {
        HEPacketWaterUpdate message = new HEPacketWaterUpdate(this.waterId, this.waterLevel);
        HE.network.sendToAll((IMessage)message);
    }

    public void sendConfigUpdate() {
        HEPacketConfigUpdate message = new HEPacketConfigUpdate(this.waterId, this.blockX, this.blockY, this.blockZ, this.mode, this.limitWest, this.limitDown, this.limitNorth, this.limitEast, this.limitUp, this.limitSouth);
        HE.network.sendToAll((IMessage)message);
    }

    public void breakController() {
        this.isPlaced = false;
        this.sendConfigUpdate();
    }

    public void placeController(String ownerName, int dimensionId, int blockX, int blockY, int blockZ, int waterBlockX, int waterBlockY, int waterBlockZ) {
        this.isPlaced = true;
        this.mode = HE.DamMode.DRAIN;
        this.limitEast = blockX + 20;
        this.limitWest = blockX - 20;
        this.limitUp = blockY + 10;
        this.limitDown = blockY;
        this.limitSouth = blockZ + 20;
        this.limitNorth = blockZ - 20;
        this.waterLevel = blockY;
        this.blocksPerY = new int[256];
        this.blockX = blockX;
        this.blockY = blockY;
        this.blockZ = blockZ;
        this.dimensionId = dimensionId;
        this.waterBlockX = waterBlockX;
        this.waterBlockY = waterBlockY;
        this.waterBlockZ = waterBlockZ;
        this.ownerName = ownerName;
        this.sendConfigUpdate();
    }

    public void onWaterRemoved(int blockY) {
        int n = blockY;
        this.blocksPerY[n] = this.blocksPerY[n] - 1;
    }

    public void onWaterPlaced(int blockY) {
        int n = blockY;
        this.blocksPerY[n] = this.blocksPerY[n] + 1;
    }

    public float getWaterLevel() {
        return this.waterLevel;
    }

    public boolean isPlaced() {
        return this.isPlaced;
    }

    public int getBlocksOnY(int blockY) {
        return this.blocksPerY[blockY];
    }

    public int getBlockX() {
        return this.blockX;
    }

    public int getBlockY() {
        return this.blockY;
    }

    public int getBlockZ() {
        return this.blockZ;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean onConfigRequest(HE.DamMode mode, int limitWest, int limitDown, int limitNorth, int limitEast, int limitUp, int limitSouth) {
        limitWest = this.blockX - HEUtil.clamp(this.blockX - limitWest, 0, HEConfig.maxWaterSpreadWest);
        limitDown = this.blockY - HEUtil.clamp(this.blockY - limitDown, 0, HEConfig.maxWaterSpreadDown);
        limitNorth = this.blockZ - HEUtil.clamp(this.blockZ - limitNorth, 0, HEConfig.maxWaterSpreadNorth);
        limitEast = this.blockX + HEUtil.clamp(limitEast - this.blockX, 0, HEConfig.maxWaterSpreadEast);
        limitUp = this.blockY + HEUtil.clamp(limitUp - this.blockY, 0, HEConfig.maxWaterSpreadUp);
        limitSouth = this.blockZ + HEUtil.clamp(limitSouth - this.blockZ, 0, HEConfig.maxWaterSpreadSouth);
        if (this.mode != mode || this.limitWest != limitWest || this.limitDown != limitDown || this.limitNorth != limitNorth || this.limitEast != limitEast || this.limitUp != limitUp || this.limitSouth != limitSouth) {
            this.mode = mode;
            this.limitWest = limitWest;
            this.limitDown = limitDown;
            this.limitNorth = limitNorth;
            this.limitEast = limitEast;
            this.limitUp = limitUp;
            this.limitSouth = limitSouth;
            this.sendConfigUpdate();
            HEBlockQueue.enqueueBlock(MinecraftServer.func_71276_C().func_71218_a((int)this.dimensionId).field_73011_w.field_76579_a, this.waterBlockX, this.waterBlockY, this.waterBlockZ, this.waterId);
            return true;
        }
        return false;
    }

    public boolean canSpread() {
        return this.mode != HE.DamMode.DRAIN && this.isPlaced;
    }

    public String getShortDescription() {
        return "HEController @(" + this.blockX + ", " + this.blockY + ", " + this.blockZ + ")";
    }

    public long getEuCapacity() {
        long euCapacity = 0L;
        for (int blockY = this.blockY; blockY < 256; ++blockY) {
            this.euCapacityUpToY[blockY] = euCapacity = (long)((float)euCapacity + (float)(this.blocksPerY[blockY] * 1000) * HEConfig.euPerMilliBucket * (float)(blockY - this.blockY + 1));
        }
        return euCapacity;
    }

    public long getEuCapacityAt(int blockY) {
        return this.euCapacityUpToY[blockY];
    }

    public void setWaterLevel(long euStored) {
        for (int blockY = this.blockY; blockY < 256; ++blockY) {
            if (euStored >= this.euCapacityUpToY[blockY]) continue;
            float energyCapacityAtY = (float)(this.blocksPerY[blockY] * 1000) * HEConfig.euPerMilliBucket * (float)(blockY - this.blockY + 1);
            float decimals = 1.0f + ((float)euStored - (float)this.euCapacityUpToY[blockY]) / energyCapacityAtY;
            this.setWaterLevel((float)blockY + decimals);
            return;
        }
    }

    public int getRainedOnBlocks() {
        for (int blockY = 255; blockY >= 0; --blockY) {
            if (this.blocksPerY[blockY] <= 0) continue;
            return this.blocksPerY[blockY];
        }
        return 0;
    }
}

