/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.utils.carthesian;

import com.google.common.collect.UnmodifiableIterator;
import gcewing.sg.utils.carthesian.Cartesian;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ProductIterator<T>
extends UnmodifiableIterator<T[]> {
    private int index = -2;
    private final Iterable<? extends T>[] iterables;
    private final Iterator<? extends T>[] iterators;
    private final T[] results;

    ProductIterator(Class<T> clazz, Iterable<? extends T>[] iterables) {
        this.iterables = iterables;
        this.iterators = Cartesian.createArray(Iterator.class, this.iterables.length);
        for (int i = 0; i < this.iterables.length; ++i) {
            this.iterators[i] = iterables[i].iterator();
        }
        this.results = Cartesian.createArray(clazz, this.iterators.length);
    }

    private void endOfData() {
        this.index = -1;
        Arrays.fill(this.iterators, null);
        Arrays.fill(this.results, null);
    }

    public boolean hasNext() {
        if (this.index == -2) {
            this.index = 0;
            for (Iterator<T> iterator : this.iterators) {
                if (iterator.hasNext()) continue;
                this.endOfData();
                break;
            }
            return true;
        }
        if (this.index >= this.iterators.length) {
            Iterator<T> iterator;
            this.index = this.iterators.length - 1;
            while (this.index >= 0 && !(iterator = this.iterators[this.index]).hasNext()) {
                if (this.index == 0) {
                    this.endOfData();
                    break;
                }
                iterator = this.iterables[this.index].iterator();
                this.iterators[this.index] = iterator;
                if (!iterator.hasNext()) {
                    this.endOfData();
                    break;
                }
                --this.index;
            }
        }
        return this.index >= 0;
    }

    public T[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        while (this.index < this.iterators.length) {
            this.results[this.index] = this.iterators[this.index].next();
            ++this.index;
        }
        return (Object[])this.results.clone();
    }
}

