/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import com.glodblock.github.util.BlockPos;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileCertusQuartzTank
extends TileEntity
implements IFluidHandler {
    public FluidTank tank = new FluidTank(32000);

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public int getFluidLightLevel() {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid == null || tankFluid.amount == 0 ? 0 : tankFluid.getFluid().getLuminosity(tankFluid);
    }

    public FluidStack drain(FluidStack fluid, boolean doDrain, boolean findMainTank) {
        FluidStack fluidToDrain;
        FluidStack externallyDrained;
        TileCertusQuartzTank tankBelow;
        int drained;
        if (fluid == null || this.getFluid() == null || this.getFluid() != fluid.getFluid()) {
            return null;
        }
        if (findMainTank) {
            TileCertusQuartzTank tankAbove;
            TileCertusQuartzTank mainTank = this;
            while ((tankAbove = mainTank.getTankAbove()) != null && fluid.getFluid() == tankAbove.getFluid()) {
                mainTank = tankAbove;
            }
            return mainTank.drain(fluid, doDrain, false);
        }
        FluidStack drainedFluid = this.tank.drain(fluid.amount, doDrain);
        int n = drained = drainedFluid != null ? drainedFluid.amount : 0;
        if (drained > 0) {
            this.update();
        }
        if (drained < fluid.amount && (tankBelow = this.getTankBelow()) != null && (externallyDrained = tankBelow.drain(fluidToDrain = new FluidStack(fluid.getFluid(), fluid.amount - drained), doDrain, false)) != null) {
            return new FluidStack(fluid.getFluid(), drained + externallyDrained.amount);
        }
        return drainedFluid;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(resource, doDrain, true);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.tank.getFluid() == null) {
            return null;
        }
        return this.drain(from, new FluidStack(this.tank.getFluid(), maxDrain), doDrain);
    }

    public int fill(FluidStack fluid, boolean doFill, boolean findMainTank) {
        TileCertusQuartzTank tankAbove;
        if (fluid == null || this.getFluid() != null && this.getFluid() != fluid.getFluid()) {
            return 0;
        }
        if (findMainTank) {
            FluidStack fluidBelow;
            TileCertusQuartzTank tankBelow;
            TileCertusQuartzTank mainTank = this;
            while (!((tankBelow = mainTank.getTankBelow()) == null || (fluidBelow = tankBelow.tank.getFluid()) != null && fluidBelow.amount == tankBelow.tank.getCapacity() || tankBelow.getFluid() != null && fluid.getFluid() != tankBelow.getFluid())) {
                mainTank = tankBelow;
            }
            return mainTank.fill(fluid, doFill, false);
        }
        int filled = this.tank.fill(fluid, doFill);
        if (filled > 0) {
            this.update();
        }
        if (filled < fluid.amount && (tankAbove = this.getTankAbove()) != null) {
            FluidStack fluidToFill = new FluidStack(fluid.getFluid(), fluid.amount - filled);
            return filled + tankAbove.fill(fluidToFill, doFill, false);
        }
        return filled;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill, true);
    }

    public Fluid getFluid() {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid != null && tankFluid.amount > 0 ? tankFluid.getFluid() : null;
    }

    public Fluid getRenderFluid() {
        return this.tank.getFluid() != null ? this.tank.getFluid().getFluid() : null;
    }

    public float getRenderScale() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    private TileCertusQuartzTank getTankAbove() {
        TileEntity tile = new BlockPos(this).getOffSet(0, 1, 0).getTileEntity();
        if (tile instanceof TileCertusQuartzTank) {
            TileCertusQuartzTank tankTile = (TileCertusQuartzTank)tile;
            return tankTile;
        }
        return null;
    }

    private TileCertusQuartzTank getTankBelow() {
        TileEntity tile = new BlockPos(this).getOffSet(0, -1, 0).getTileEntity();
        if (tile instanceof TileCertusQuartzTank) {
            TileCertusQuartzTank tankTile = (TileCertusQuartzTank)tile;
            return tankTile;
        }
        return null;
    }

    public FluidTankInfo[] getTankInfo(boolean countAllTanksInColumn) {
        if (!countAllTanksInColumn) {
            return new FluidTankInfo[]{this.tank.getInfo()};
        }
        FluidStack tankFluidStack = this.tank.getFluid();
        Fluid mainFluid = tankFluidStack != null ? tankFluidStack.getFluid() : null;
        int amount = tankFluidStack == null ? 0 : tankFluidStack.amount;
        int capacity = this.tank.getCapacity();
        TileCertusQuartzTank tankAbove = this;
        while ((tankAbove = tankAbove.getTankAbove()) != null && tankAbove.getFluid() != null && mainFluid == tankAbove.getFluid()) {
            FluidTankInfo info = tankAbove.tank.getInfo();
            amount += info.fluid == null ? 0 : info.fluid.amount;
            capacity += info.capacity;
        }
        TileCertusQuartzTank tankBelow = this;
        while ((tankBelow = tankBelow.getTankBelow()) != null && mainFluid != null && mainFluid == tankBelow.getFluid()) {
            FluidTankInfo info = tankBelow.tank.getInfo();
            amount += info.fluid == null ? 0 : info.fluid.amount;
            capacity += info.capacity;
        }
        return new FluidTankInfo[]{new FluidTankInfo(mainFluid != null ? new FluidStack(mainFluid, amount) : null, capacity)};
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getTankInfo(true);
    }

    public FluidTankInfo[] getInternalFluid() {
        return this.getTankInfo(true);
    }

    private void flowFluidDown(boolean checkTankAbove) {
        TileCertusQuartzTank above;
        FluidStack fluid;
        int amount;
        TileCertusQuartzTank below;
        if (this.getFluid() != null && (below = this.getTankBelow()) != null && (amount = below.tank.fill(fluid = this.tank.getFluid().copy(), true)) > 0) {
            this.tank.drain(amount, true);
            this.update();
            below.update();
            below.flowFluidDown(false);
        }
        if (checkTankAbove && (above = this.getTankAbove()) != null && above.getFluid() != null && (this.getFluid() == null || this.getFluid() == above.getFluid())) {
            above.flowFluidDown(true);
        }
    }

    public void update() {
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readFromNBTWithoutCoords(tag);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tag) {
        this.tank.readFromNBT(tag);
    }

    public void readFromItemNBT(NBTTagCompound tag) {
        if (tag != null) {
            this.readFromNBTWithoutCoords(tag.func_74775_l("tileEntity"));
        }
        this.flowFluidDown(true);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeToNBTWithoutCoords(tag);
    }

    public void writeToNBTWithoutCoords(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
    }
}

