/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.minecraft.McBlockPart;
import codechicken.multipart.minecraft.McSidedMetaPart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ButtonPart
extends McSidedMetaPart
implements IFaceRedstonePart {
    public static BlockButton stoneButton = (BlockButton)Blocks.field_150430_aB;
    public static BlockButton woodenButton = (BlockButton)Blocks.field_150471_bO;
    public static int[] metaSideMap = new int[]{-1, 4, 5, 2, 3, -1, -1, -1};
    public static int[] sideMetaMap = new int[]{-1, -1, 3, 4, 1, 2};
    public static Cuboid6[] cuboidRegions = ButtonPart.setupCuboids();

    private static Cuboid6[] setupCuboids() {
        Cuboid6[] regions = new Cuboid6[16];
        for (int i = 0; i < regions.length; ++i) {
            woodenButton.func_149683_g();
            woodenButton.func_150043_b(i);
            regions[i] = new Cuboid6(woodenButton.func_149704_x(), woodenButton.func_149665_z(), woodenButton.func_149706_B(), woodenButton.func_149753_y(), woodenButton.func_149669_A(), woodenButton.func_149693_C());
        }
        return regions;
    }

    public static BlockButton getButton(int meta) {
        return (meta & 0x10) > 0 ? woodenButton : stoneButton;
    }

    public ButtonPart() {
    }

    public ButtonPart(int meta) {
        super(meta);
    }

    @Override
    public int sideForMeta(int meta) {
        return metaSideMap[meta & 7];
    }

    @Override
    public Block getBlock() {
        return ButtonPart.getButton(this.meta);
    }

    @Override
    public String getType() {
        return "mc_button";
    }

    public int delay() {
        return this.sensitive() ? 30 : 20;
    }

    public boolean sensitive() {
        return (this.meta & 0x10) > 0;
    }

    @Override
    public Cuboid6 getBounds() {
        return cuboidRegions[this.meta & 0xF].copy();
    }

    public static McBlockPart placement(World world, BlockCoord pos, int side, int type) {
        if (sideMetaMap[side ^ 1] == -1) {
            return null;
        }
        pos = pos.copy().offset(side ^ 1);
        if (!world.isSideSolid(pos.x, pos.y, pos.z, ForgeDirection.getOrientation((int)side))) {
            return null;
        }
        return new ButtonPart(sideMetaMap[side ^ 1] | type << 4);
    }

    @Override
    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (this.pressed()) {
            return false;
        }
        if (!this.world().field_72995_K) {
            this.toggle();
        }
        return true;
    }

    @Override
    public void scheduledTick() {
        if (this.pressed()) {
            this.updateState();
        }
    }

    public boolean pressed() {
        return (this.meta & 8) > 0;
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (!this.pressed() && !this.world().field_72995_K && entity instanceof EntityArrow) {
            this.updateState();
        }
    }

    private void toggle() {
        boolean in = !this.pressed();
        this.meta = (byte)(this.meta ^ 8);
        this.world().func_72908_a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, "random.click", 0.3f, in ? 0.6f : 0.5f);
        if (in) {
            this.scheduleTick(this.delay());
        }
        this.sendDescUpdate();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(metaSideMap[this.meta & 7]);
        this.tile().func_70296_d();
    }

    private void updateState() {
        boolean pressed;
        boolean arrows = this.sensitive() && !this.world().func_72872_a(EntityArrow.class, this.getBounds().add(Vector3.fromTileEntity((TileEntity)this.tile())).toAABB()).isEmpty();
        if (arrows != (pressed = this.pressed())) {
            this.toggle();
        }
        if (arrows && pressed) {
            this.scheduleTick(this.delay());
        }
    }

    @Override
    public void onRemoved() {
        if (this.pressed()) {
            this.tile().notifyNeighborChange(metaSideMap[this.meta & 7]);
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.pressed() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.pressed() && side == metaSideMap[this.meta & 7] ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return metaSideMap[this.meta & 7];
    }
}

