/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.api.infusionrecipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.glease.tc4tweak.api.infusionrecipe.RecipeIngredient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;

public class EnhancedInfusionRecipe
extends InfusionRecipe {
    protected final RecipeIngredient central;
    protected final List<RecipeIngredient> components;

    protected EnhancedInfusionRecipe(String research, Object output, int inst, AspectList aspects2, RecipeIngredient input, List<RecipeIngredient> recipe) {
        super(research, output, inst, aspects2, input.getRepresentativeStack(), (ItemStack[])recipe.stream().map(RecipeIngredient::getRepresentativeStack).toArray(ItemStack[]::new));
        this.central = input;
        this.components = recipe;
    }

    public RecipeIngredient getCentral() {
        return this.central;
    }

    public List<RecipeIngredient> getComponentsExt() {
        return Collections.unmodifiableList(this.components);
    }

    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        if (this.getRecipeInput() == null) {
            return false;
        }
        if (!this.research.isEmpty() && !ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)this.research)) {
            return false;
        }
        if (!this.getCentral().matches(central)) {
            return false;
        }
        ArrayList<ItemStack> l = new ArrayList<ItemStack>(input);
        block0: for (RecipeIngredient ingredient : this.getComponentsExt()) {
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (!ingredient.matches(stack)) continue;
                iterator.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }
}

